/*******************************************************************************
 * Copyright (c) 2011, 2023 Ericsson, Ecole Polytechnique de Montreal and others
 *
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0 which
 * accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors: Sehr Moosabhoy - Implementation
 *******************************************************************************/

package org.eclipse.tracecompass.internal.ctf.core.utils;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;

/**
 * Various strings for CTF2 implementation.
 *
 * @author Sehr Moosabhoy
 */
public final class JsonMetadataStrings {

    private JsonMetadataStrings() {
        // Do nothing
    }

    // ------------------------------------------------------------------------
    // Constants
    // ------------------------------------------------------------------------

    /**
     * Type string for a CTF2 preamble fragment
     */
    public static final String FRAGMENT_PREAMBLE = "preamble"; //$NON-NLS-1$

    /**
     * Type string for a CTF2 trace class fragment
     */
    public static final String FRAGMENT_TRACE = "trace-class"; //$NON-NLS-1$

    /**
     * Type string for a CTF2 field class alias fragment
     */
    public static final String FRAGMENT_FIELD_ALIAS = "field-class-alias"; //$NON-NLS-1$

    /**
     * The field class
     */
    public static final String FIELD_CLASS = "field-class"; //$NON-NLS-1$

    /**
     * The name of the fragment
     */
    public static final String NAME = "name"; //$NON-NLS-1$


    /**
     * Type string for a CTF2 clock class fragment
     */
    public static final String FRAGMENT_CLOCK = "clock-class"; //$NON-NLS-1$

    /**
     * Type string for a CTF2 data stream class fragment
     */
    public static final String FRAGMENT_DATA_STREAM = "data-stream-class"; //$NON-NLS-1$

    /**
     * Type string for a CTF2 event record class fragment
     */
    public static final String FRAGMENT_EVENT_RECORD = "event-record-class"; //$NON-NLS-1$

    /**
     * Field string for the type of a CTF2 node
     */
    public static final String TYPE = "type"; //$NON-NLS-1$

    /**
     * String for the roles field of a field class
     */
    public static final String ROLES = "roles"; //$NON-NLS-1$

    /**
     * String for the packet header magic role of a field class
     */
    public static final String MAGIC_NUMBER = "packet-magic-number"; //$NON-NLS-1$

    /**
     * String for the packet header uuid role of a field class
     */
    public static final String UUID = "metadata-stream-uuid"; //$NON-NLS-1$

    /**
     * String for the packet header data stream class id role of a field class
     */
    public static final String DATA_STREAM_ID = "data-stream-class-id"; //$NON-NLS-1$

    /**
     * String for the packet content length role of a data stream packet context
     */
    public static final String PACKET_CONTENT_LENGTH = "packet-content-length"; //$NON-NLS-1$

    /**
     * String for the packet total length role of a data stream packet context
     */
    public static final String PACKET_TOTAL_LENGTH = "packet-total-length"; //$NON-NLS-1$

    /**
     * String for the default clock timestamp role of a data stream packet
     * context or data stream event record header
     */
    public static final String DEFAULT_CLOCK_TIMESTAMP = "default-clock-timestamp"; //$NON-NLS-1$

    /**
     * String for the discarded event record counter snapshot role of a data
     * stream packet context
     */
    public static final String CURRENT_DISCARDED_EVENT_COUNT = "discarded-event-record-counter-snapshot"; //$NON-NLS-1$

    /**
     * String for the packet end default clock timestamp role of a data stream
     * packet context
     */
    public static final String PACKET_END_TIMESTAMP = "packet-end-default-clock-timestamp"; //$NON-NLS-1$

    /**
     * String for the event record class id role of a data stream event record
     * header
     */
    public static final String EVENT_RECORD_CLASS_ID = "event-record-class-id"; //$NON-NLS-1$

    /**
     * Type string for a field class that points to an alias
     */
    public static final String ALIAS = "alias"; //$NON-NLS-1$

    /**
     * Type string for an unsigned fixed integer field class
     */
    public static final String FIXED_UNSIGNED_INTEGER_FIELD = "fixed-length-unsigned-integer"; //$NON-NLS-1$

    /**
     * Type string for a signed fixed integer field class
     */
    public static final String FIXED_SIGNED_INTEGER_FIELD = "fixed-length-signed-integer"; //$NON-NLS-1$

    /**
     * Type string for an unsigned variable integer field class
     */
    public static final String VARIABLE_UNSIGNED_INTEGER_FIELD = "variable-length-unsigned-integer"; //$NON-NLS-1$

    /**
     * Type string for a signed variable integer field class
     */
    public static final String VARIABLE_SIGNED_INTEGER_FIELD = "variable-length-signed-integer"; //$NON-NLS-1$

    /**
     * Type string for a fixed length floating point number field class
     */
    public static final String FIXED_LENGTH_FLOATING_POINT = "fixed-length-floating-point-number"; //$NON-NLS-1$

    /**
     * Type string for a variable length floating point number field class
     */
    public static final String VARIABLE_LENGTH_FLOATING_POINT = "variable-length-floating-point-number"; //$NON-NLS-1$

    /**
     * Type string for a static length blob field class
     */
    public static final String STATIC_LENGTH_BLOB = "static-length-blob"; //$NON-NLS-1$

    /**
     * Type string for a null terminated string field class
     */
    public static final String NULL_TERMINATED_STRING = "null-terminated-string"; //$NON-NLS-1$

    /**
     * Field string for the length of a field class
     */
    public static final String LENGTH = "length"; //$NON-NLS-1$

    /**
     * Type string for a dynamic length string field class
     */
    public static final String DYNAMIC_LENGTH_STRING = "dynamic-length-string"; //$NON-NLS-1$

    /**
     * The length field location for a dynamic string
     */
    public static final String LENGTH_FIELD_LOCATION = "length-field-location"; //$NON-NLS-1$
    /**
     * Type string for a fixed length unsigned enumeration field class
     */
    public static final String FIXED_UNSIGNED_ENUMERATION = "fixed-length-unsigned-enumeration"; //$NON-NLS-1$

    /**
     * Type string for a variant field class
     */
    public static final String VARIANT = "variant"; //$NON-NLS-1$

    /**
     * Field string for a path
     */
    public static final String PATH = "path"; //$NON-NLS-1$

    /**
     * Type string for a structure field class
     */
    public static final String STRUCTURE = "structure"; //$NON-NLS-1$

    /**
     * Type string for an internal structure field class
     */
    public static final String STRUCT = "struct"; //$NON-NLS-1$

    /**
     * Map of encoding names to Charset objects
     */
    public static final Map<String, Charset> ENCODINGS = Map.of("utf-8",StandardCharsets.UTF_8, //$NON-NLS-1$
            "utf-16be",StandardCharsets.UTF_16BE,"utf-16le",StandardCharsets.UTF_16LE, //$NON-NLS-1$ //$NON-NLS-2$
            "utf-32be", Charset.forName("UTF-32BE"),"utf-32le", Charset.forName("UTF-32LE")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$

    /**
     * Field string for encoding
     */
    public static final String ENCODING = "encoding"; //$NON-NLS-1$

    /**
     * Type string for a static length string field class
     */
    public static final String STATIC_LENGTH_STRING = "static-length-string"; //$NON-NLS-1$

    /**
     * Type string for a static length array field class
     */
    public static final String STATIC_LENGTH_ARRAY = "static-length-array"; //$NON-NLS-1$

    /**
     * Type string for a dynamic length array field class
     */
    public static final String DYNAMIC_LENGTH_ARRAY = "dynamic-length-array"; //$NON-NLS-1$

    /**
     * Field string for element field class
     */
    public static final String ELEMENT_FIELD_CLASS = "element-field-class"; //$NON-NLS-1$

    /**
     * Field string for member classes in a structure
     */
    public static final String MEMBER_CLASSES = "member-classes"; //$NON-NLS-1$

    /**
     * Field string for minimum alignment
     */
    public static final String MINIMUM_ALIGNMENT = "minimum-alignment"; //$NON-NLS-1$

    /**
     * Field string for alignment
     */
    public static final String ALIGNMENT = "alignment"; //$NON-NLS-1$

    /**
     * Field string for byte order
     */
    public static final String BYTE_ORDER = "byte-order"; //$NON-NLS-1$

}
