/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.intro.config;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class IntroElement {
    private final String name;
    private String value;
    private final Hashtable<String, String> atts = new Hashtable();
    private List<IntroElement> children;

    public IntroElement(String name) {
        this.name = name;
    }

    public void setAttribute(String name, String value) {
        this.atts.put(name, value);
    }

    public String getAttribute(String name) {
        return this.atts.get(name);
    }

    public Enumeration<String> getAttributes() {
        return this.atts.keys();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void addChild(IntroElement child) {
        if (this.children == null) {
            this.children = new ArrayList<IntroElement>();
        }
        this.children.add(child);
    }

    public IntroElement[] getChildren() {
        if (this.children == null) {
            return new IntroElement[0];
        }
        return this.children.toArray(new IntroElement[this.children.size()]);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntroElement) {
            if (obj == this) {
                return true;
            }
            String id1 = this.atts.get("id");
            String id2 = ((IntroElement)obj).atts.get("id");
            if (id1 == null && id2 == null) {
                return super.equals(obj);
            }
            if (id1 != null && id2 != null) {
                return id1.equals(id2);
            }
        }
        return false;
    }
}

