/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.signal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.component.TmfComponent;
import org.eclipse.tracecompass.tmf.core.signal.TmfEndSynchSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfStartSynchSignal;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TmfSignalManagerTest {
    private final @NonNull TestSignalSender signalSender = new TestSignalSender();

    @After
    public void tearDown() {
        this.signalSender.dispose();
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testSendReceive() {
        signalReceivers = new TestSignalHandler[10];
        i = 0;
        while (i < 10) {
            signalReceivers[i] = new TestSignalHandler();
            ++i;
        }
        firstSignal = new TestSignal1((Object)this.signalSender);
        secondSignal = new TestSignal2((Object)this.signalSender);
        expectedOrder = new Class[]{TmfStartSynchSignal.class, TestSignal1.class, TmfEndSynchSignal.class, TmfStartSynchSignal.class, TestSignal2.class, TmfEndSynchSignal.class};
        try {
            this.signalSender.sendSignal(firstSignal);
            this.signalSender.sendSignal(secondSignal);
            i = 0;
            while (i < 10) {
                Assert.assertEquals((long)expectedOrder.length, (long)signalReceivers[i].receivedSignals.size());
                k = 0;
                while (k < expectedOrder.length) {
                    Assert.assertEquals(((TmfSignal)signalReceivers[i].receivedSignals.get(k)).getClass(), (Object)expectedOrder[k]);
                    ++k;
                }
                k = 0;
                while (k < expectedOrder.length) {
                    startSyncId = ((TmfSignal)signalReceivers[i].receivedSignals.get(k)).getReference();
                    signalId = ((TmfSignal)signalReceivers[i].receivedSignals.get(k + 1)).getReference();
                    endSyncId = ((TmfSignal)signalReceivers[i].receivedSignals.get(k + 2)).getReference();
                    Assert.assertEquals((long)startSyncId, (long)signalId);
                    Assert.assertEquals((long)startSyncId, (long)endSyncId);
                    k += 3;
                }
                ++i;
            }
        }
        finally {
            i = 0;
            ** while (i < 10)
        }
lbl-1000:
        // 1 sources

        {
            signalReceivers[i].dispose();
            ++i;
            continue;
        }
lbl39:
        // 1 sources

    }

    @Test
    public void testInboundBlacklisting() {
        this.testInboundBlacklisting(Arrays.asList(new Class[0]), Arrays.asList(TmfStartSynchSignal.class, TestSignal1.class, TmfEndSynchSignal.class, TmfStartSynchSignal.class, TestSignal2.class, TmfEndSynchSignal.class));
        this.testInboundBlacklisting(Arrays.asList(TestSignal1.class), Arrays.asList(TmfStartSynchSignal.class, TmfEndSynchSignal.class, TmfStartSynchSignal.class, TestSignal2.class, TmfEndSynchSignal.class));
        this.testInboundBlacklisting(Arrays.asList(TestSignal2.class), Arrays.asList(TmfStartSynchSignal.class, TestSignal1.class, TmfEndSynchSignal.class, TmfStartSynchSignal.class, TmfEndSynchSignal.class));
        this.testInboundBlacklisting(Arrays.asList(TestSignal1.class, TestSignal2.class), Arrays.asList(TmfStartSynchSignal.class, TmfEndSynchSignal.class, TmfStartSynchSignal.class, TmfEndSynchSignal.class));
        this.testInboundBlacklisting(Arrays.asList(TmfSignal.class), Arrays.asList(new Class[0]));
    }

    private void testInboundBlacklisting(List<@NonNull Class<? extends TmfSignal>> ignoredSignals, List<Class<? extends TmfSignal>> expectedSignals) {
        TestSignalHandler receiver = new TestSignalHandler();
        for (Class<? extends TmfSignal> ignoredSignal : ignoredSignals) {
            TmfSignalManager.addIgnoredInboundSignal((Object)((Object)receiver), ignoredSignal);
        }
        this.signalSender.sendSignal(new TestSignal1((Object)this.signalSender));
        this.signalSender.sendSignal(new TestSignal2((Object)this.signalSender));
        Assert.assertEquals((long)expectedSignals.size(), (long)receiver.receivedSignals.size());
        int i = 0;
        while (i < expectedSignals.size()) {
            Assert.assertEquals(expectedSignals.get(i), ((TmfSignal)receiver.receivedSignals.get(i)).getClass());
            ++i;
        }
        receiver.dispose();
    }

    @Test
    public void testOutboundBlacklisting() {
        this.testOutboundBlacklisting(Arrays.asList(new Class[0]), Arrays.asList(TmfStartSynchSignal.class, TestSignal1.class, TmfEndSynchSignal.class, TmfStartSynchSignal.class, TestSignal2.class, TmfEndSynchSignal.class));
        this.testOutboundBlacklisting(Arrays.asList(TestSignal1.class), Arrays.asList(TmfStartSynchSignal.class, TestSignal2.class, TmfEndSynchSignal.class));
        this.testOutboundBlacklisting(Arrays.asList(TestSignal2.class), Arrays.asList(TmfStartSynchSignal.class, TestSignal1.class, TmfEndSynchSignal.class));
        this.testOutboundBlacklisting(Arrays.asList(TestSignal1.class, TestSignal2.class), Arrays.asList(new Class[0]));
        this.testOutboundBlacklisting(Arrays.asList(TmfSignal.class), Arrays.asList(new Class[0]));
    }

    private void testOutboundBlacklisting(List<@NonNull Class<? extends TmfSignal>> blockedSignals, List<Class<? extends TmfSignal>> expectedSignals) {
        TestSignalHandler receiver = new TestSignalHandler();
        for (Class<? extends TmfSignal> blockedSignal : blockedSignals) {
            TmfSignalManager.addIgnoredOutboundSignal((Object)((Object)this.signalSender), blockedSignal);
        }
        this.signalSender.sendSignal(new TestSignal1((Object)this.signalSender));
        this.signalSender.sendSignal(new TestSignal2((Object)this.signalSender));
        Assert.assertEquals((long)expectedSignals.size(), (long)receiver.receivedSignals.size());
        int i = 0;
        while (i < expectedSignals.size()) {
            Assert.assertEquals(expectedSignals.get(i), ((TmfSignal)receiver.receivedSignals.get(i)).getClass());
            ++i;
        }
        receiver.dispose();
        TmfSignalManager.clearIgnoredOutboundSignalList((Object)((Object)this.signalSender));
    }

    @Test
    public void testNestedSignals() {
        TestSignalHandlerNested signalResender = new TestSignalHandlerNested();
        TestSignalHandler signalReceiver = new TestSignalHandler();
        TestSignal1 mainSignal = new TestSignal1((Object)this.signalSender);
        Class[] expectedOrder = new Class[]{TmfStartSynchSignal.class, TmfStartSynchSignal.class, TestSignal2.class, TmfEndSynchSignal.class, TmfStartSynchSignal.class, TmfStartSynchSignal.class, TestSignal4.class, TmfEndSynchSignal.class, TestSignal3.class, TmfEndSynchSignal.class, TestSignal1.class, TmfEndSynchSignal.class};
        int[] nArray = new int[12];
        nArray[1] = 10;
        nArray[2] = 11;
        nArray[3] = 1;
        nArray[4] = 2;
        nArray[5] = 3;
        nArray[6] = 4;
        nArray[7] = 8;
        nArray[8] = 9;
        nArray[9] = 5;
        nArray[10] = 6;
        nArray[11] = 7;
        int[] sameSigNoIndex = nArray;
        try {
            this.signalSender.sendSignal(mainSignal);
            Assert.assertEquals((long)expectedOrder.length, (long)signalReceiver.receivedSignals.size());
            int i = 0;
            while (i < expectedOrder.length) {
                Assert.assertEquals(((TmfSignal)signalReceiver.receivedSignals.get(i)).getClass(), (Object)expectedOrder[i]);
                ++i;
            }
            i = 0;
            while (i < sameSigNoIndex.length) {
                int startSyncId = ((TmfSignal)signalReceiver.receivedSignals.get(sameSigNoIndex[i])).getReference();
                int signalId = ((TmfSignal)signalReceiver.receivedSignals.get(sameSigNoIndex[i + 1])).getReference();
                int endSyncId = ((TmfSignal)signalReceiver.receivedSignals.get(sameSigNoIndex[i + 2])).getReference();
                Assert.assertEquals((long)startSyncId, (long)signalId);
                Assert.assertEquals((long)startSyncId, (long)endSyncId);
                i += 3;
            }
        }
        finally {
            signalResender.dispose();
            signalReceiver.dispose();
        }
    }

    @Test
    public void testConcurrentSignals() {
        TestSignalHandlerNested signalResender = new TestSignalHandlerNested();
        TestSignalHandler signalReceiver = new TestSignalHandler(false, null);
        Class[] expectedOrder1 = new Class[]{TestSignal2.class, TestSignal4.class, TestSignal3.class, TestSignal1.class, TestSignal4.class};
        Class[] expectedOrder2 = new Class[]{TestSignal4.class, TestSignal2.class, TestSignal4.class, TestSignal3.class, TestSignal1.class};
        try {
            int k = 0;
            while (k < 10) {
                final CountDownLatch startLatch = new CountDownLatch(2);
                final CountDownLatch sendLatch = new CountDownLatch(1);
                final CountDownLatch endLatch = new CountDownLatch(2);
                signalReceiver.receivedSignals.clear();
                Thread senderThread1 = new Thread(){

                    @Override
                    public void run() {
                        startLatch.countDown();
                        try {
                            sendLatch.await();
                        }
                        catch (InterruptedException interruptedException) {}
                        TmfSignalManagerTest.this.signalSender.sendSignal(new TestSignal1((Object)TmfSignalManagerTest.this.signalSender));
                        endLatch.countDown();
                    }
                };
                Thread senderThread2 = new Thread(){

                    @Override
                    public void run() {
                        startLatch.countDown();
                        try {
                            sendLatch.await();
                        }
                        catch (InterruptedException interruptedException) {}
                        TmfSignalManagerTest.this.signalSender.sendSignal(new TestSignal4((Object)TmfSignalManagerTest.this.signalSender));
                        endLatch.countDown();
                    }
                };
                senderThread1.start();
                senderThread2.start();
                try {
                    startLatch.await();
                }
                catch (InterruptedException interruptedException) {}
                sendLatch.countDown();
                try {
                    endLatch.await();
                }
                catch (InterruptedException interruptedException) {}
                Assert.assertEquals((long)expectedOrder1.length, (long)signalReceiver.receivedSignals.size());
                boolean pass = true;
                int i = 0;
                while (i < expectedOrder1.length) {
                    if (!((TmfSignal)signalReceiver.receivedSignals.get(i)).getClass().equals(expectedOrder1[i])) {
                        pass = false;
                        break;
                    }
                    ++i;
                }
                if (!pass) {
                    i = 0;
                    while (i < expectedOrder2.length) {
                        if (!((TmfSignal)signalReceiver.receivedSignals.get(i)).getClass().equals(expectedOrder2[i])) {
                            Assert.fail((String)"Concurrent signal test failure!");
                        }
                        ++i;
                    }
                }
                ++k;
            }
        }
        finally {
            signalResender.dispose();
            signalReceiver.dispose();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testBroadcastAsync() {
        signalResender = new TestSignalHandlerNested(false);
        latch = new CountDownLatch(10);
        signalReceivers = new TestSignalHandler[10];
        i = 0;
        while (i < 10) {
            signalReceivers[i] = new TestSignalHandler(false, latch);
            ++i;
        }
        expectedOrder = new Class[]{TestSignal1.class, TestSignal2.class, TestSignal3.class, TestSignal4.class};
        try {
            mainSignal = new TestSignal1((Object)this.signalSender);
            this.signalSender.sendSignal(mainSignal);
            try {
                latch.await();
            }
            catch (InterruptedException v0) {}
            i = 0;
            while (i < 10) {
                Assert.assertEquals((long)expectedOrder.length, (long)signalReceivers[i].receivedSignals.size());
                k = 0;
                while (k < expectedOrder.length) {
                    Assert.assertEquals(((TmfSignal)signalReceivers[i].receivedSignals.get(k)).getClass(), (Object)expectedOrder[k]);
                    ++k;
                }
                ++i;
            }
        }
        finally {
            i = 0;
            ** while (i < 10)
        }
lbl-1000:
        // 1 sources

        {
            signalReceivers[i].dispose();
            ++i;
            continue;
        }
lbl34:
        // 1 sources

        signalResender.dispose();
    }

    public abstract class AbstractBaseSignalHandler
    extends TmfComponent {
        List<TmfSignal> receivedSignals;
        private boolean logSyncSigs;

        private AbstractBaseSignalHandler(String name, boolean logSyncSignal) {
            super(name);
            this.receivedSignals = new ArrayList<TmfSignal>();
            this.logSyncSigs = logSyncSignal;
        }

        @TmfSignalHandler
        public void receiveStartSynch(TmfStartSynchSignal signal) {
            if (this.logSyncSigs) {
                this.receivedSignals.add((TmfSignal)signal);
            }
        }

        @TmfSignalHandler
        public void receiveEndSynch(TmfEndSynchSignal signal) {
            if (this.logSyncSigs) {
                this.receivedSignals.add((TmfSignal)signal);
            }
        }
    }

    private class TestSignal1
    extends TmfSignal {
        public TestSignal1(Object source) {
            super(source);
        }
    }

    private class TestSignal2
    extends TmfSignal {
        public TestSignal2(Object source) {
            super(source);
        }
    }

    private class TestSignal3
    extends TmfSignal {
        public TestSignal3(Object source) {
            super(source);
        }
    }

    private class TestSignal4
    extends TmfSignal {
        public TestSignal4(Object source) {
            super(source);
        }
    }

    public class TestSignalHandler
    extends AbstractBaseSignalHandler {
        private CountDownLatch latch;

        private TestSignalHandler() {
            this(true, null);
        }

        private TestSignalHandler(boolean logSyncSigs, CountDownLatch latch) {
            super("TestSignalHandler", logSyncSigs);
            this.latch = latch;
        }

        @TmfSignalHandler
        public void receiveSignal1(TestSignal1 signal) {
            this.receivedSignals.add(signal);
        }

        @TmfSignalHandler
        public void receiveSignal2(TestSignal2 signal) {
            this.receivedSignals.add(signal);
        }

        @TmfSignalHandler
        public void receiveSignal3(TestSignal3 signal) {
            this.receivedSignals.add(signal);
        }

        @TmfSignalHandler
        public void receiveSignal4(TestSignal4 signal) {
            this.receivedSignals.add(signal);
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
    }

    public class TestSignalHandlerNested
    extends AbstractBaseSignalHandler {
        private boolean sync;

        private TestSignalHandlerNested() {
            this(true);
        }

        private TestSignalHandlerNested(boolean sync) {
            super("TestSignalHandlerNested", false);
            this.sync = sync;
            TmfSignalManager.deregister((Object)((Object)this));
            TmfSignalManager.registerVIP((Object)((Object)this));
        }

        @TmfSignalHandler
        public void receiveSignal1(TestSignal1 signal) {
            if (this.sync) {
                this.broadcast(new TestSignal2(signal.getSource()));
                this.broadcast(new TestSignal3(signal.getSource()));
            } else {
                this.broadcastAsync(new TestSignal2(signal.getSource()));
                this.broadcastAsync(new TestSignal3(signal.getSource()));
            }
        }

        @TmfSignalHandler
        public void receiveSignal3(TestSignal3 signal) {
            if (this.sync) {
                this.broadcast(new TestSignal4(signal.getSource()));
            } else {
                this.broadcastAsync(new TestSignal4(signal.getSource()));
            }
        }
    }

    private class TestSignalSender
    extends TmfComponent {
        TestSignalSender() {
            super("TestSignalSender");
        }

        public void sendSignal(TmfSignal signal) {
            this.broadcast(signal);
        }
    }
}

