/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.trace.indexer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.core.TmfCoreTracer;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.ICheckpointCollection;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.Messages;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfPersistentlyIndexable;

public abstract class AbstractFileCheckpointCollection
implements ICheckpointCollection {
    private static final int INVALID_VERSION = -1;
    private static final int VERSION = 3;
    private static final int SUB_VERSION_NONE = -1;
    protected static final int INT_SIZE = 4;
    protected static final int LONG_SIZE = 8;
    protected static final int MAX_TIME_RANGE_SERIALIZE_SIZE = 128;
    private ITmfPersistentlyIndexable fTrace;
    private long fCacheMisses = 0L;
    private boolean fCreatedFromScratch;
    private boolean fIsDirty = false;
    private @Nullable RandomAccessFile fRandomAccessFile;
    private File fFile;
    private final CheckpointCollectionFileHeader fHeader;
    private FileChannel fFileChannel;

    public AbstractFileCheckpointCollection(File file, ITmfPersistentlyIndexable trace) {
        this.fTrace = trace;
        this.fFile = file;
        this.setCreatedFromScratch(!this.fFile.exists());
        CheckpointCollectionFileHeader header = null;
        if (!this.isCreatedFromScratch() && (header = this.tryRestore()) == null) {
            this.delete();
        }
        if (this.isCreatedFromScratch()) {
            this.fIsDirty = true;
            header = this.initialize();
        }
        this.fHeader = header;
    }

    protected CheckpointCollectionFileHeader createHeader() {
        return new CheckpointCollectionFileHeader(3);
    }

    protected CheckpointCollectionFileHeader createHeader(RandomAccessFile randomAccessFile) throws IOException {
        return new CheckpointCollectionFileHeader(randomAccessFile);
    }

    protected int getVersion() {
        return 3;
    }

    protected int getSubVersion() {
        return -1;
    }

    private CheckpointCollectionFileHeader initialize() {
        CheckpointCollectionFileHeader header = null;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.fFile, "rw");
            this.fFileChannel = randomAccessFile.getChannel();
            header = this.createHeader();
            randomAccessFile.setLength(header.getSize());
            TmfCoreTracer.traceIndexer(CheckpointCollectionFileHeader.class.getSimpleName() + " initialize nbEvents: " + header.fNbEvents + " fTimeRange: " + String.valueOf(header.fTimeRange));
            this.fRandomAccessFile = randomAccessFile;
        }
        catch (IOException e) {
            Activator.logError(MessageFormat.format(Messages.ErrorOpeningIndex, this.fFile), e);
            return null;
        }
        return header;
    }

    private CheckpointCollectionFileHeader tryRestore() {
        CheckpointCollectionFileHeader header = null;
        RandomAccessFile randomAccessFile = this.fRandomAccessFile;
        try {
            try {
                randomAccessFile = new RandomAccessFile(this.fFile, "rw");
                this.fFileChannel = randomAccessFile.getChannel();
            }
            catch (FileNotFoundException e) {
                Activator.logError(MessageFormat.format(Messages.ErrorOpeningIndex, this.fFile), e);
                this.fRandomAccessFile = randomAccessFile;
                return null;
            }
        }
        finally {
            this.fRandomAccessFile = randomAccessFile;
        }
        try {
            header = this.createHeader(randomAccessFile);
            if (header.fVersion != 3 || header.getSubVersion() != this.getSubVersion()) {
                return null;
            }
            try {
                TmfCoreTracer.traceIndexer(CheckpointCollectionFileHeader.class.getSimpleName() + " read " + String.valueOf(this.fFile) + " nbEvents: " + header.fNbEvents + " fTimeRange: " + String.valueOf(header.fTimeRange));
            }
            catch (IOException e) {
                Activator.logError(MessageFormat.format(Messages.IOErrorReadingHeader, this.fFile), e);
                return null;
            }
        }
        finally {
            this.fRandomAccessFile = randomAccessFile;
        }
        return header;
    }

    protected void markDirty() {
        RandomAccessFile randomAccessFile = this.fRandomAccessFile;
        if (this.fIsDirty || randomAccessFile == null) {
            return;
        }
        try {
            randomAccessFile.seek(0L);
            randomAccessFile.writeInt(-1);
        }
        catch (IOException e) {
            Activator.logError(MessageFormat.format(Messages.IOErrorWritingHeader, this.fFile), e);
        }
        this.fIsDirty = true;
    }

    @Override
    public boolean isCreatedFromScratch() {
        return this.fCreatedFromScratch;
    }

    protected void setCreatedFromScratch(boolean isCreatedFromScratch) {
        this.fCreatedFromScratch = isCreatedFromScratch;
    }

    public long getCacheMisses() {
        return this.fCacheMisses;
    }

    protected void incCacheMisses() {
        ++this.fCacheMisses;
    }

    @Override
    public int size() {
        return this.fHeader.fSize;
    }

    @Override
    public void setTimeRange(TmfTimeRange timeRange) {
        if (!this.fHeader.fTimeRange.equals(timeRange)) {
            this.markDirty();
        }
        this.fHeader.fTimeRange = timeRange;
    }

    @Override
    public TmfTimeRange getTimeRange() {
        return this.fHeader.fTimeRange;
    }

    @Override
    public void setNbEvents(long nbEvents) {
        if (this.fHeader.fNbEvents != nbEvents) {
            this.markDirty();
        }
        this.fHeader.fNbEvents = nbEvents;
    }

    @Override
    public long getNbEvents() {
        return this.fHeader.fNbEvents;
    }

    protected ITmfPersistentlyIndexable getTrace() {
        return this.fTrace;
    }

    protected RandomAccessFile getRandomAccessFile() {
        return this.fRandomAccessFile;
    }

    protected File getFile() {
        return this.fFile;
    }

    public CheckpointCollectionFileHeader getHeader() {
        return this.fHeader;
    }

    @Override
    public void delete() {
        this.dispose(true);
        File file = this.fFile;
        if (file.exists()) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                Activator.logError(e.getMessage(), e);
            }
        }
    }

    @Override
    public void dispose() {
        this.dispose(false);
    }

    private void dispose(boolean deleting) {
        try {
            try {
                RandomAccessFile randomAccessFile = this.fRandomAccessFile;
                if (randomAccessFile != null) {
                    if (!deleting && this.fIsDirty) {
                        if (this.fHeader != null) {
                            this.fHeader.serialize(randomAccessFile);
                        }
                        randomAccessFile.seek(0L);
                        randomAccessFile.writeInt(this.getVersion());
                        this.fIsDirty = false;
                    }
                    randomAccessFile.close();
                }
                this.setCreatedFromScratch(true);
                String headerTrace = this.fHeader == null ? "No header" : "nbEvents: " + this.fHeader.fNbEvents + " timerange:" + String.valueOf(this.fHeader.fTimeRange);
                TmfCoreTracer.traceIndexer(this.getClass().getSimpleName() + " disposed. " + headerTrace);
            }
            catch (IOException e) {
                Activator.logError(MessageFormat.format(Messages.IOErrorClosingIndex, this.fFile), e);
                this.fRandomAccessFile = null;
            }
        }
        finally {
            this.fRandomAccessFile = null;
        }
    }

    protected class CheckpointCollectionFileHeader {
        private static final int SIZE = 152;
        protected final int fVersion;
        protected int fSize = 0;
        protected long fNbEvents;
        protected TmfTimeRange fTimeRange = new TmfTimeRange(TmfTimestamp.ZERO, TmfTimestamp.ZERO);

        public int getSize() {
            return 152;
        }

        public int getSubVersion() {
            return -1;
        }

        public CheckpointCollectionFileHeader(RandomAccessFile randomAccessFile) throws IOException {
            this.fVersion = randomAccessFile.readInt();
            this.fSize = randomAccessFile.readInt();
            this.fNbEvents = randomAccessFile.readLong();
            ByteBuffer b = ByteBuffer.allocate(128);
            b.clear();
            AbstractFileCheckpointCollection.this.fFileChannel.read(b);
            b.flip();
            this.fTimeRange = new TmfTimeRange(TmfTimestamp.create(b), TmfTimestamp.create(b));
        }

        public CheckpointCollectionFileHeader(int version) {
            this.fVersion = version;
        }

        public void serialize(RandomAccessFile randomAccessFile) throws IOException {
            randomAccessFile.seek(0L);
            randomAccessFile.writeInt(-1);
            randomAccessFile.writeInt(this.fSize);
            randomAccessFile.writeLong(this.fNbEvents);
            ByteBuffer b = ByteBuffer.allocate(128);
            b.clear();
            TmfTimestamp.serialize(b, this.fTimeRange.getStartTime());
            TmfTimestamp.serialize(b, this.fTimeRange.getEndTime());
            b.rewind();
            AbstractFileCheckpointCollection.this.fFileChannel.write(b);
        }
    }
}

