/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlLocationCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlMappingGroupCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlPatternEventHandlerCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenMappingGroup;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.pattern.DataDrivenPattern;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.ISegmentListener;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.w3c.dom.Element;

public class TmfXmlPatternCu {
    private final String fProviderId;
    private final int fVersion;
    private final List<TmfXmlMappingGroupCu> fMappingGroups;
    private final TmfXmlPatternEventHandlerCu fHandlerCu;
    private final Map<String, String> fStoredFields;

    private TmfXmlPatternCu(String providerId, int version, List<TmfXmlMappingGroupCu> mapGroups, TmfXmlPatternEventHandlerCu handlerCu, Map<String, String> storedFields) {
        this.fProviderId = providerId;
        this.fVersion = version;
        this.fMappingGroups = mapGroups;
        this.fHandlerCu = handlerCu;
        this.fStoredFields = storedFields;
    }

    public DataDrivenPattern generate(ITmfTrace trace, ISegmentListener listener) {
        List<DataDrivenMappingGroup> mappingGroups = this.fMappingGroups.stream().map(TmfXmlMappingGroupCu::generate).collect(Collectors.toList());
        return new DataDrivenPattern(trace, this.fProviderId, this.fVersion, this.fHandlerCu.generate(), mappingGroups, listener, this.fStoredFields);
    }

    public static @Nullable TmfXmlPatternCu compile(Path file, String providerId) {
        Element spEl = TmfXmlUtils.getElementInFile(file.toAbsolutePath().toString(), "pattern", providerId);
        if (spEl == null) {
            Activator.logError("XML pattern: Cannot find pattern element in file " + String.valueOf(file));
            return null;
        }
        return TmfXmlPatternCu.compile(spEl, providerId);
    }

    public static @Nullable TmfXmlPatternCu compile(Element patternEl) {
        String id = patternEl.getAttribute("id");
        if (id.isEmpty()) {
            Activator.logError("XML pattern: The pattern must have an 'id' attribute");
            return null;
        }
        return TmfXmlPatternCu.compile(patternEl, id);
    }

    private static @Nullable TmfXmlPatternCu compile(Element patternEl, String providerId) {
        int version;
        AnalysisCompilationData analysisData = new AnalysisCompilationData();
        try {
            version = Integer.parseInt(patternEl.getAttribute("version"));
        }
        catch (NumberFormatException e) {
            Activator.logError("XML pattern: The version is not a parseable integer");
            return null;
        }
        List<Element> childElements = TmfXmlUtils.getChildElements(patternEl, "definedValue");
        for (Element element : childElements) {
            analysisData.addDefinedValue(element.getAttribute("name"), element.getAttribute("value"));
        }
        childElements = TmfXmlUtils.getChildElements(patternEl, "storedFields");
        HashMap<String, String> storedFields = new HashMap<String, String>();
        for (Element element : childElements) {
            String key = element.getAttribute("alias");
            String id = element.getAttribute("id");
            storedFields.put(id, key.isEmpty() ? id : key);
        }
        childElements = TmfXmlUtils.getChildElements(patternEl, "location");
        for (Element element : childElements) {
            TmfXmlLocationCu.compile(analysisData, element);
        }
        ArrayList<TmfXmlMappingGroupCu> mapGroups = new ArrayList<TmfXmlMappingGroupCu>();
        childElements = TmfXmlUtils.getChildElements(patternEl, "mappingGroup");
        for (Element map : childElements) {
            TmfXmlMappingGroupCu compile = TmfXmlMappingGroupCu.compile(analysisData, map);
            if (compile == null) {
                return null;
            }
            mapGroups.add(compile);
        }
        childElements = TmfXmlUtils.getChildElements(patternEl, "patternHandler");
        if (childElements.size() != 1) {
            Activator.logError("XML pattern: Only one pattern handler should be present");
            return null;
        }
        TmfXmlPatternEventHandlerCu handlerCu = TmfXmlPatternEventHandlerCu.compile(analysisData, childElements.get(0));
        if (handlerCu == null) {
            return null;
        }
        return new TmfXmlPatternCu(providerId, version, mapGroups, handlerCu, storedFields);
    }
}

