/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.analysis;

import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.Ros2ObjectTimeGraphEntryModelType;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ClientObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2NodeObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2PublisherObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ServiceObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2SubscriptionObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2TimerObject;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;

public class Ros2ObjectTimeGraphEntryModel
extends TimeGraphEntryModel {
    public static final String KEY_OBJECT_TYPE = "object_type";
    public static final String KEY_OBJECT = "object";
    private final @NonNull Ros2ObjectTimeGraphEntryModelType fType;
    private final @NonNull Object fObject;

    public Ros2ObjectTimeGraphEntryModel(long id, long parentId, long startTime, long endTime, @NonNull Ros2ObjectTimeGraphEntryModelType type, @NonNull Object object) {
        super(id, parentId, Objects.requireNonNull(Ros2ObjectTimeGraphEntryModel.getEntryModelName(type, object)), startTime, endTime, true);
        this.fType = type;
        this.fObject = object;
    }

    private static String getEntryModelName(Ros2ObjectTimeGraphEntryModelType type, Object object) {
        switch (type) {
            case TRACE: {
                return ((Ros2NodeObject)((Object)object)).getTraceName();
            }
            case NODE: {
                return ((Ros2NodeObject)((Object)object)).getNodeName();
            }
            case PUBLISHER: {
                return ((Ros2PublisherObject)((Object)object)).getTopicName();
            }
            case SUBSCRIPTION: {
                return ((Ros2SubscriptionObject)((Object)object)).getTopicName();
            }
            case CLIENT: {
                return ((Ros2ClientObject)((Object)object)).getTopicName();
            }
            case SERVICE: {
                return ((Ros2ServiceObject)((Object)object)).getTopicName();
            }
            case TIMER: {
                return Ros2ObjectTimeGraphEntryModel.getTimerPeriodAsString((Ros2TimerObject)((Object)object));
            }
        }
        throw new IllegalStateException();
    }

    private static String getTimerPeriodAsString(Ros2TimerObject timerObject) {
        DecimalFormat df = new DecimalFormat("0");
        df.setMaximumFractionDigits(10);
        return df.format((double)Long.valueOf(timerObject.getPeriod()).longValue() / 1000000.0) + " ms";
    }

    public @NonNull Ros2ObjectTimeGraphEntryModelType getType() {
        return this.fType;
    }

    public boolean isLeafObject() {
        return this.fType.equals((Object)Ros2ObjectTimeGraphEntryModelType.PUBLISHER) || this.fType.equals((Object)Ros2ObjectTimeGraphEntryModelType.SUBSCRIPTION) || this.fType.equals((Object)Ros2ObjectTimeGraphEntryModelType.TIMER);
    }

    public @NonNull Object getObject() {
        return this.fObject;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Multimap<@NonNull String, @NonNull Object> getMetadata() {
        @NonNull @NonNull Multimap metadata = super.getMetadata();
        metadata.put((Object)KEY_OBJECT_TYPE, (Object)this.fType);
        metadata.put((Object)KEY_OBJECT, this.fObject);
        return metadata;
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.fType, this.fObject});
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Ros2ObjectTimeGraphEntryModel o = (Ros2ObjectTimeGraphEntryModel)((Object)obj);
        return this.fType.equals((Object)o.fType) && this.fObject.equals(o.fObject);
    }
}

