/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.format.DecimalUnitFormat;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.Otf2FlowsDataProvider;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.presentation.IPaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.presentation.SequentialPaletteProvider;

final class FlowsRowModel
extends TimeGraphRowModel {
    private static final String COLOR = "#ee0000cc";
    private static final int COLORS_NUMBER = 20;
    private static final float ZSCORE_FACTOR = 7.0f;
    private static final double ZERO_THRESHOLD = 1.0E-10;
    private DecimalUnitFormat fFormat = new DecimalUnitFormat(1.0E9);
    private List<RGBAColor> fColors;
    private double fMean;
    private double fStandardDeviation;
    private TreeMap<Long, Double> fTimestampFlowChangeMap = new TreeMap();
    private @Nullable FlowsRowModel fParentModel;

    private static boolean isZero(double value) {
        return Math.abs(value) <= 1.0E-10;
    }

    public FlowsRowModel(long entryID, List<ITimeGraphState> states, @Nullable FlowsRowModel parentModel) {
        super(entryID, states);
        List colors;
        this.fParentModel = parentModel;
        RGBAColor baseColor = RGBAColor.fromString((String)COLOR);
        IPaletteProvider paletteProvider = baseColor != null ? SequentialPaletteProvider.create((RGBAColor)baseColor, (int)20) : null;
        this.fColors = colors = paletteProvider != null ? paletteProvider.get() : new ArrayList();
    }

    private static double clip(double min, double max, double value) {
        return Math.min(max, Math.max(min, value));
    }

    private OutputElementStyle getStateStyle(double value) {
        double zScore = this.fStandardDeviation != 0.0 ? (value - this.fMean) / this.fStandardDeviation : 0.0;
        int index = (int)FlowsRowModel.clip(0.0, 19.0, 10.0 + 7.0 * zScore);
        RGBAColor color = this.fColors.get(index);
        return new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"border-style", (Object)"solid", (Object)"background-color", (Object)color.toString().substring(0, 7)));
    }

    public void computeStatisticsAndStates(Otf2FlowsDataProvider dataProvider, Map<Integer, Predicate<Multimap<String, Object>>> predicates, @Nullable IProgressMonitor monitor) {
        if (this.fTimestampFlowChangeMap.isEmpty()) {
            return;
        }
        long lastTimestamp = this.fTimestampFlowChangeMap.firstKey();
        ArrayList<FlowsState> flowsStates = new ArrayList<FlowsState>();
        double currentFlowValue = 0.0;
        double cumulativeFlow = 0.0;
        double cumulativeSquaredFlow = 0.0;
        long numberOfStates = 0L;
        for (Map.Entry<Long, Double> entry : this.fTimestampFlowChangeMap.entrySet()) {
            long timestamp = entry.getKey();
            double flowChange = entry.getValue();
            long durationSinceLastTimestamp = timestamp - lastTimestamp;
            if (!FlowsRowModel.isZero(currentFlowValue)) {
                if (FlowsRowModel.isZero(flowChange)) continue;
                flowsStates.add(new FlowsState(lastTimestamp, durationSinceLastTimestamp, currentFlowValue));
                ++numberOfStates;
                cumulativeFlow += currentFlowValue;
                cumulativeSquaredFlow += Math.pow(currentFlowValue, 2.0);
                currentFlowValue += flowChange;
                lastTimestamp = timestamp;
                continue;
            }
            flowsStates.add(new FlowsState(lastTimestamp, durationSinceLastTimestamp, 0.0));
            currentFlowValue += flowChange;
            lastTimestamp = timestamp;
        }
        this.fMean = cumulativeFlow / (double)numberOfStates;
        double squaredDataMean = cumulativeSquaredFlow / (double)numberOfStates;
        double squaredMean = Math.pow(this.fMean, 2.0);
        this.fStandardDeviation = squaredDataMean >= squaredMean ? Math.sqrt(squaredDataMean - squaredMean) : 0.0;
        List states = this.getStates();
        for (FlowsState state : flowsStates) {
            double value = state.getValue();
            @Nullable OutputElementStyle style = FlowsRowModel.isZero(value) ? null : this.getStateStyle(value);
            @Nullable String label = FlowsRowModel.isZero(value) ? null : this.fFormat.format((Object)value, new StringBuffer(), null).append("B/s").toString();
            TimeGraphState timeGraphState = new TimeGraphState(state.getStart(), state.getDuration(), label, style);
            dataProvider.applyFilterAndAddState(states, (ITimeGraphState)timeGraphState, this.getEntryID(), predicates, monitor);
        }
    }

    public void addFlowChange(long timestamp, double value) {
        this.fTimestampFlowChangeMap.merge(timestamp, value, (oldValue, newValue) -> oldValue + newValue);
        if (this.fParentModel != null) {
            this.fParentModel.addFlowChange(timestamp, value);
        }
    }

    public double getMean() {
        return this.fMean;
    }

    public double getStandardDeviation() {
        return this.fStandardDeviation;
    }

    private static class FlowsState {
        private long fStart;
        private long fDuration;
        private double fValue;

        public FlowsState(long start, long duration, double value) {
            this.fStart = start;
            this.fDuration = duration;
            this.fValue = value;
        }

        public long getStart() {
            return this.fStart;
        }

        public long getDuration() {
            return this.fDuration;
        }

        public double getValue() {
            return this.fValue;
        }
    }
}

