/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros2.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.AbstractRos2StateProvider;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2MessagesAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2MessagesUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.objects.Ros2ObjectsUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.HostProcessPointer;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.HostThread;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2CallbackInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2CallbackPublicationInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2MessageTimestamp;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2MessageTransportInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2PubInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2SubCallbackInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2TakeInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2TimerCallbackInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2CallbackType;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2NodeObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2PublisherObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2SubscriptionObject;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class Ros2MessagesStateProvider
extends AbstractRos2StateProvider {
    private static final int VERSION_NUMBER = 0;
    private final ITmfStateSystem fObjectsSs;
    private boolean fInitialSetupDone = false;
    private Collection<HostProcessPointer> fKnownDdsWriters = new ArrayList<HostProcessPointer>();
    private Collection<Ros2ObjectHandle> fKnownRmwPublishers = new ArrayList<Ros2ObjectHandle>();
    private Map<HostProcessPointer, ITmfEvent> fRclcppPublishEvents = Maps.newHashMap();
    private Map<HostProcessPointer, ITmfEvent> fRclPublishEvents = Maps.newHashMap();
    private Map<HostProcessPointer, ITmfEvent> fDdsWritePreEvents = Maps.newHashMap();
    private Map<HostProcessPointer, ITmfEvent> fRmwTakeEvents = Maps.newHashMap();
    private Map<Ros2ObjectHandle, Ros2TakeInstance> fTakeInstances = Maps.newHashMap();
    private Map<HostProcessPointer, ITmfEvent> fCallbackStartEvents = Maps.newHashMap();
    private Multimap<HostThread, Pair<@NonNull Ros2ObjectHandle, @NonNull Long>> fCallbackPublications = MultimapBuilder.hashKeys().arrayListValues().build();
    private Map<Ros2MessageTimestamp, Pair<@NonNull Ros2ObjectHandle, @NonNull Long>> fPublications = Maps.newHashMap();

    public Ros2MessagesStateProvider(ITmfTrace trace, ITmfStateSystem objectsSs) {
        super(trace, Ros2MessagesAnalysis.getFullAnalysisId());
        this.fObjectsSs = objectsSs;
    }

    public int getVersion() {
        return 0;
    }

    public @NonNull ITmfStateProvider getNewInstance() {
        return new Ros2MessagesStateProvider(this.getTrace(), this.fObjectsSs);
    }

    protected void eventHandle(@NonNull ITmfEvent event) {
        if (!Ros2MessagesStateProvider.considerEvent(event)) {
            return;
        }
        ITmfStateSystemBuilder ss = Objects.requireNonNull(this.getStateSystemBuilder());
        long timestamp = event.getTimestamp().toNanos();
        if (!this.fInitialSetupDone) {
            this.fInitialSetupDone = true;
            this.createObjects(ss);
        }
        this.eventHandleHelpers(event);
        if (!this.isPubSourceTimestampAvailableFromRmw()) {
            this.eventHandlePublishDds(event, ss, timestamp);
        }
        this.eventHandlePublish(event, ss, timestamp);
        this.eventHandleTake(ss, event, timestamp);
        this.eventHandleCallback(event, ss, timestamp);
    }

    private void eventHandleHelpers(@NonNull ITmfEvent event) {
        if (!this.isPubSourceTimestampAvailableFromRmw()) {
            String topicName;
            if (Ros2MessagesStateProvider.isEvent(event, LAYOUT.eventDdsCreateWriter()) && !(topicName = (String)Ros2MessagesStateProvider.getField(event, LAYOUT.fieldTopicName())).equals("ros_discovery_info")) {
                HostProcessPointer writer = Ros2MessagesStateProvider.hostProcessPointerFrom(event, (long)((Long)Ros2MessagesStateProvider.getField(event, LAYOUT.fieldWriter())));
                this.fKnownDdsWriters.add(writer);
            }
        } else if (Ros2MessagesStateProvider.isEvent(event, LAYOUT.eventRclPublisherInit())) {
            Ros2ObjectHandle rmwPublisher = Ros2MessagesStateProvider.handleFrom(event, (long)((Long)Ros2MessagesStateProvider.getField(event, LAYOUT.fieldRmwPublisherHandle())));
            this.fKnownRmwPublishers.add(rmwPublisher);
        }
    }

    private void eventHandlePublish(@NonNull ITmfEvent event, ITmfStateSystemBuilder ss, long timestamp) {
        if (Ros2MessagesStateProvider.isEvent(event, LAYOUT.eventRclcppPublish())) {
            HostProcessPointer message = Ros2MessagesStateProvider.hostProcessPointerFrom(event, (long)((Long)Ros2MessagesStateProvider.getField(event, LAYOUT.fieldMessage())));
            this.fRclcppPublishEvents.put(message, event);
        } else if (Ros2MessagesStateProvider.isEvent(event, LAYOUT.eventRclPublish())) {
            HostProcessPointer message = Ros2MessagesStateProvider.hostProcessPointerFrom(event, (long)((Long)Ros2MessagesStateProvider.getField(event, LAYOUT.fieldMessage())));
            this.fRclPublishEvents.put(message, event);
        } else if (this.isPubSourceTimestampAvailableFromRmw() && Ros2MessagesStateProvider.isEvent(event, LAYOUT.eventRmwPublish())) {
            this.handleRmwPublish(event, ss, timestamp);
        }
    }

    private void eventHandlePublishDds(@NonNull ITmfEvent event, ITmfStateSystemBuilder ss, long timestamp) {
        if (Ros2MessagesStateProvider.isEvent(event, LAYOUT.eventDdsWritePre())) {
            HostProcessPointer writer = Ros2MessagesStateProvider.hostProcessPointerFrom(event, (long)((Long)Ros2MessagesStateProvider.getField(event, LAYOUT.fieldWriter())));
            this.fDdsWritePreEvents.put(writer, event);
        } else if (Ros2MessagesStateProvider.isEvent(event, LAYOUT.eventDdsWrite())) {
            this.eventHandlePublishDdsWrite(event, ss, timestamp);
        }
    }

    private void eventHandlePublishDdsWrite(@NonNull ITmfEvent event, ITmfStateSystemBuilder ss, long timestamp) {
        HostProcessPointer writer = Ros2MessagesStateProvider.hostProcessPointerFrom(event, (long)((Long)Ros2MessagesStateProvider.getField(event, LAYOUT.fieldWriter())));
        if (!this.fKnownDdsWriters.contains((Object)writer)) {
            return;
        }
        HostProcessPointer message = this.getDdsMessage(event, writer);
        if (message == null) {
            return;
        }
        this.handlePublish(event, ss, timestamp, message);
    }

    private HostProcessPointer getDdsMessage(@NonNull ITmfEvent event, HostProcessPointer writer) {
        if (Ros2MessagesStateProvider.hasField(event, LAYOUT.fieldData())) {
            return Ros2MessagesStateProvider.hostProcessPointerFrom(event, (long)((Long)Ros2MessagesStateProvider.getField(event, LAYOUT.fieldData())));
        }
        ITmfEvent ddsWritePre = this.fDdsWritePreEvents.remove((Object)writer);
        if (ddsWritePre == null) {
            Activator.getInstance().logError("could not get corresponding dds:write_pre event for writer=0x" + Long.toHexString(writer.getPointer()));
            return null;
        }
        return Ros2MessagesStateProvider.hostProcessPointerFrom(ddsWritePre, (long)((Long)Ros2MessagesStateProvider.getField(ddsWritePre, LAYOUT.fieldData())));
    }

    private void handleRmwPublish(@NonNull ITmfEvent event, ITmfStateSystemBuilder ss, long timestamp) {
        Ros2ObjectHandle rmwPublisher = Ros2MessagesStateProvider.handleFrom(event, (long)((Long)Ros2MessagesStateProvider.getField(event, LAYOUT.fieldRmwPublisherHandle())));
        if (!this.fKnownRmwPublishers.contains((Object)rmwPublisher)) {
            return;
        }
        HostProcessPointer message = Ros2MessagesStateProvider.hostProcessPointerFrom(event, (long)((Long)Ros2MessagesStateProvider.getField(event, LAYOUT.fieldMessage())));
        this.handlePublish(event, ss, timestamp, message);
    }

    private void handlePublish(@NonNull ITmfEvent event, ITmfStateSystemBuilder ss, long endPubTimestamp, @NonNull HostProcessPointer message) {
        ITmfEvent rclPublish = this.fRclPublishEvents.remove((Object)message);
        if (rclPublish == null) {
            Activator.getInstance().logError("could not find corresponding rcl_publish event for message=" + message.toString());
            return;
        }
        Ros2ObjectHandle publisherHandle = Ros2MessagesStateProvider.handleFrom(rclPublish, (long)((Long)Ros2MessagesStateProvider.getField(rclPublish, LAYOUT.fieldPublisherHandle())));
        Ros2PublisherObject publisherObject = Ros2ObjectsUtil.getPublisherObjectFromHandle(this.fObjectsSs, endPubTimestamp, publisherHandle);
        if (publisherObject == null) {
            Activator.getInstance().logError("could not find publisher object for publisher handle=0x" + Long.toHexString(publisherHandle.getHandle()));
            return;
        }
        ITmfEvent rclcppPublish = this.fRclcppPublishEvents.remove((Object)message);
        if (rclcppPublish == null) {
            return;
        }
        long pubTimestamp = rclcppPublish.getTimestamp().toNanos();
        long sourceTimestamp = (Long)Ros2MessagesStateProvider.getField(event, LAYOUT.fieldTimestamp());
        HostThread thread = Ros2MessagesStateProvider.hostThreadFrom(event);
        Ros2PubInstance pubInstance = new Ros2PubInstance((Ros2ObjectHandle)((Object)publisherObject.getHandle()), thread.getTid(), message, sourceTimestamp);
        this.addPublicationInstance(ss, pubTimestamp, endPubTimestamp, thread, publisherObject, pubInstance);
    }

    private void addPublicationInstance(ITmfStateSystemBuilder ss, long pubTimestamp, long endPubTimestamp, @NonNull HostThread thread, Ros2PublisherObject publisherObject, @NonNull Ros2PubInstance pubInstance) {
        Integer pubQuark = Ros2MessagesUtil.getPublisherQuarkAndAdd(ss, this.fObjectsSs, endPubTimestamp, (Ros2ObjectHandle)((Object)publisherObject.getHandle()));
        if (pubQuark == null) {
            return;
        }
        ss.modifyAttribute(pubTimestamp, (Object)pubInstance, pubQuark.intValue());
        ss.modifyAttribute(endPubTimestamp, null, pubQuark.intValue());
        Ros2MessageTimestamp messageSourceTimestamp = new Ros2MessageTimestamp(pubInstance.getSourceTimestamp(), publisherObject.getTopicName());
        this.fPublications.put(messageSourceTimestamp, (Pair<Ros2ObjectHandle, Long>)new Pair((Object)((Ros2ObjectHandle)((Object)publisherObject.getHandle())), (Object)endPubTimestamp));
        this.fCallbackPublications.put((Object)thread, (Object)new Pair((Object)((Ros2ObjectHandle)((Object)publisherObject.getHandle())), (Object)pubTimestamp));
    }

    private void eventHandleTake(@NonNull ITmfStateSystemBuilder ss, @NonNull ITmfEvent event, long timestamp) {
        if (Ros2MessagesStateProvider.isEvent(event, LAYOUT.eventRmwTake())) {
            HostProcessPointer message = Ros2MessagesStateProvider.hostProcessPointerFrom(event, (long)((Long)Ros2MessagesStateProvider.getField(event, LAYOUT.fieldMessage())));
            this.fRmwTakeEvents.put(message, event);
            return;
        }
        if (Ros2MessagesStateProvider.isEvent(event, LAYOUT.eventRclcppTake())) {
            HostProcessPointer message = Ros2MessagesStateProvider.hostProcessPointerFrom(event, (long)((Long)Ros2MessagesStateProvider.getField(event, LAYOUT.fieldMessage())));
            long tid = Ros2MessagesStateProvider.getTid(event);
            ITmfEvent rmwTake = this.fRmwTakeEvents.remove((Object)message);
            if (rmwTake == null) {
                Activator.getInstance().logError("could not find corresponding rmw_take event for message=" + message.toString());
                return;
            }
            long sourceTimestamp = (Long)Ros2MessagesStateProvider.getField(rmwTake, LAYOUT.fieldSourceTimestamp());
            Ros2ObjectHandle rmwSubscriptionHandle = Ros2MessagesStateProvider.handleFrom(rmwTake, (long)((Long)Ros2MessagesStateProvider.getField(rmwTake, LAYOUT.fieldRmwSubscriptionHandle())));
            Long rmwTakeTimestamp = rmwTake.getTimestamp().toNanos();
            Ros2ObjectHandle subscriptionHandle = Ros2ObjectsUtil.getSubscriptionHandleFromRmwSubscriptionHandle(this.fObjectsSs, timestamp, rmwSubscriptionHandle);
            if (subscriptionHandle == null) {
                Activator.getInstance().logError("could not find subscription handle for rmw subscription handle");
                return;
            }
            Ros2SubscriptionObject subscriptionObject = Ros2ObjectsUtil.getSubscriptionObjectFromHandle(this.fObjectsSs, timestamp, subscriptionHandle);
            if (subscriptionObject == null) {
                Activator.getInstance().logError("could not find subscription object for subscription handle");
                return;
            }
            Ros2TakeInstance takeInstance = new Ros2TakeInstance(subscriptionHandle, tid, message, sourceTimestamp, rmwTakeTimestamp, timestamp);
            this.fTakeInstances.put(subscriptionHandle, takeInstance);
            Ros2MessageTimestamp messageSourceTimestamp = new Ros2MessageTimestamp(sourceTimestamp, subscriptionObject.getTopicName());
            Pair<@NonNull Ros2ObjectHandle, @NonNull Long> sourcePubInfo = this.fPublications.get(messageSourceTimestamp);
            if (sourcePubInfo == null) {
                Activator.getInstance().logError("could not find corresponding message publication for sourceTimestamp=[" + messageSourceTimestamp.toString() + "] for trace=" + this.getTrace().getName());
                return;
            }
            Ros2ObjectHandle sourcePubHandle = (Ros2ObjectHandle)((Object)sourcePubInfo.getFirst());
            Long sourcePubTimestamp = (Long)sourcePubInfo.getSecond();
            Ros2MessageTransportInstance transportInstance = new Ros2MessageTransportInstance(sourcePubHandle, subscriptionHandle, sourcePubTimestamp, rmwTakeTimestamp);
            Ros2MessagesStateProvider.addTransportInstance(ss, transportInstance);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void addTransportInstance(ITmfStateSystemBuilder ss, @NonNull Ros2MessageTransportInstance transportInstance) {
        int transportInstanceQuark = Ros2MessagesUtil.getTransportInstanceQuarkAndAdd(ss, transportInstance.getPublisherHandle(), transportInstance.getSubscriptionHandle());
        long sourceTimestamp = transportInstance.getSourceTimestamp();
        long destinationTimestamp = transportInstance.getDestinationTimestamp();
        @NonNull List subQuarks = ss.getSubAttributes(transportInstanceQuark, false);
        Integer freeQuark = null;
        for (Integer subQuark : subQuarks) {
            Iterable intervals;
            try {
                intervals = ss.query2D(Collections.singleton(subQuark), sourceTimestamp, destinationTimestamp);
            }
            catch (StateSystemDisposedException e) {
                continue;
            }
            Predicate<ITmfStateInterval> compatible = interval -> interval.getValue() == null && (sourceTimestamp >= interval.getStartTime() || interval.getEndTime() >= destinationTimestamp);
            if (!Streams.stream((Iterable)intervals).allMatch(compatible)) continue;
            freeQuark = subQuark;
            break;
        }
        if (freeQuark == null) {
            freeQuark = ss.getQuarkRelativeAndAdd(transportInstanceQuark, new String[]{Integer.toString(subQuarks.size() + 1)});
        }
        ss.modifyAttribute(sourceTimestamp, (Object)transportInstance, freeQuark.intValue());
        ss.modifyAttribute(destinationTimestamp, null, freeQuark.intValue());
    }

    private void eventHandleCallback(@NonNull ITmfEvent event, ITmfStateSystemBuilder ss, long timestamp) {
        if (Ros2MessagesStateProvider.isEvent(event, LAYOUT.eventCallbackStart())) {
            this.eventHandleCallbackStart(event);
        } else if (Ros2MessagesStateProvider.isEvent(event, LAYOUT.eventCallbackEnd())) {
            this.eventHandleCallbackEnd(event, ss, timestamp);
        }
    }

    private void eventHandleCallbackStart(@NonNull ITmfEvent event) {
        long callback = (Long)Ros2MessagesStateProvider.getField(event, LAYOUT.fieldCallback());
        this.fCallbackStartEvents.put(Ros2MessagesStateProvider.hostProcessPointerFrom(event, callback), event);
        this.fCallbackPublications.removeAll((Object)Ros2MessagesStateProvider.hostThreadFrom(event));
    }

    private void eventHandleCallbackEnd(@NonNull ITmfEvent event, ITmfStateSystemBuilder ss, long timestamp) {
        HostProcessPointer callback = Ros2MessagesStateProvider.hostProcessPointerFrom(event, (long)((Long)Ros2MessagesStateProvider.getField(event, LAYOUT.fieldCallback())));
        ITmfEvent callbackStart = this.fCallbackStartEvents.remove((Object)callback);
        if (callbackStart == null) {
            Activator.getInstance().logError("could not find corresponding callback_start for callback=" + callback.toString());
            return;
        }
        Pair<@NonNull Ros2ObjectHandle, Ros2CallbackType> callbackOwnerHandle = Ros2ObjectsUtil.getCallbackOwnerHandle(this.fObjectsSs, timestamp, callback);
        if (callbackOwnerHandle != null) {
            Long startTimestamp = callbackStart.getTimestamp().toNanos();
            Boolean isIntraProcess = 1L == (Long)Ros2MessagesStateProvider.getField(callbackStart, LAYOUT.fieldIsIntraProcess());
            long tid = Ros2MessagesStateProvider.getTid(callbackStart);
            Ros2ObjectHandle ownerHandle = (Ros2ObjectHandle)((Object)callbackOwnerHandle.getFirst());
            Ros2CallbackType callbackType = (Ros2CallbackType)((Object)callbackOwnerHandle.getSecond());
            if (callbackType.equals((Object)Ros2CallbackType.SUBSCRIPTION)) {
                this.addSubscriptionCallback(ss, timestamp, startTimestamp, isIntraProcess, tid, ownerHandle);
            } else if (callbackType.equals((Object)Ros2CallbackType.TIMER)) {
                this.addTimerCallback(ss, timestamp, startTimestamp, isIntraProcess, tid, ownerHandle);
            }
            this.addCallbackPublications(ss, callbackStart, ownerHandle, callbackType);
            return;
        }
        Activator.getInstance().logError("could not find callback owner for callback=" + callback.toString());
    }

    private void addSubscriptionCallback(ITmfStateSystemBuilder ss, long timestamp, long startTimestamp, boolean isIntraProcess, long tid, @NonNull Ros2ObjectHandle subHandle) {
        Ros2TakeInstance takeInstance = this.fTakeInstances.remove((Object)subHandle);
        if (takeInstance == null) {
            Activator.getInstance().logError("could not find corresponding take instance");
            return;
        }
        Ros2CallbackInstance callbackInstance = new Ros2CallbackInstance(subHandle, tid, isIntraProcess, startTimestamp, timestamp);
        Ros2SubCallbackInstance subCallbackInstance = new Ros2SubCallbackInstance(takeInstance, callbackInstance);
        Integer subQuark = Ros2MessagesUtil.getSubscriptionQuarkAndAdd(ss, this.fObjectsSs, timestamp, subHandle);
        if (subQuark == null) {
            return;
        }
        ss.modifyAttribute(takeInstance.getStartTime(), (Object)subCallbackInstance, subQuark.intValue());
        ss.modifyAttribute(callbackInstance.getEndTime(), null, subQuark.intValue());
    }

    private void addTimerCallback(ITmfStateSystemBuilder ss, long timestamp, long startTimestamp, boolean isIntraProcess, long tid, @NonNull Ros2ObjectHandle timerHandle) {
        Ros2CallbackInstance callbackInstance = new Ros2CallbackInstance(timerHandle, tid, isIntraProcess, startTimestamp, timestamp);
        Ros2TimerCallbackInstance timerCallbackInstance = new Ros2TimerCallbackInstance(timerHandle, callbackInstance);
        Integer timerQuark = Ros2MessagesUtil.getTimerQuarkAndAdd(ss, this.fObjectsSs, timestamp, timerHandle);
        if (timerQuark == null) {
            return;
        }
        ss.modifyAttribute(callbackInstance.getStartTime(), (Object)timerCallbackInstance, timerQuark.intValue());
        ss.modifyAttribute(callbackInstance.getEndTime(), null, timerQuark.intValue());
    }

    private void addCallbackPublications(ITmfStateSystemBuilder ss, @NonNull ITmfEvent callbackStart, @NonNull Ros2ObjectHandle ownerHandle, @NonNull Ros2CallbackType callbackType) {
        HostThread hostThread = Ros2MessagesStateProvider.hostThreadFrom(callbackStart);
        for (Pair pair : this.fCallbackPublications.get((Object)hostThread)) {
            Ros2ObjectHandle publisherHandle = (Ros2ObjectHandle)((Object)pair.getFirst());
            Long pubTimestamp = (Long)pair.getSecond();
            int callbackPublicationInstanceQuark = Ros2MessagesUtil.getCallbackPublicationInstanceQuarkAndAdd(ss, ownerHandle, publisherHandle);
            Ros2CallbackPublicationInstance callbackPublicationInstance = new Ros2CallbackPublicationInstance(ownerHandle, publisherHandle, pubTimestamp, callbackType);
            ss.modifyAttribute(pubTimestamp.longValue(), (Object)callbackPublicationInstance, callbackPublicationInstanceQuark);
            ss.modifyAttribute(pubTimestamp + 1L, null, callbackPublicationInstanceQuark);
        }
        this.fCallbackPublications.removeAll((Object)hostThread);
    }

    private void createObjects(ITmfStateSystemBuilder ss) {
        for (ITmfStateInterval nodeObjectInterval : Ros2ObjectsUtil.getNodeObjectIntervals(this.fObjectsSs)) {
            Ros2NodeObject nodeObject = (Ros2NodeObject)((Object)nodeObjectInterval.getValue());
            if (nodeObject == null) continue;
            int nodeQuark = Ros2MessagesUtil.getNodeQuarkAndAdd(ss, nodeObject);
            ss.modifyAttribute(nodeObjectInterval.getStartTime(), (Object)nodeObject, nodeQuark);
            ss.modifyAttribute(nodeObjectInterval.getEndTime(), null, nodeQuark);
        }
    }
}

