/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.ui.views;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.Ros2ObjectTimeGraphEntryModel;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.Ros2ObjectTimeGraphEntryModelType;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2NodeObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class Ros2ObjectTreeLabelProvider {
    public static final String[] TREE_COLUMNS = new String[]{"", "PID", "Hostname"};
    private static final String COLUMN_TEXT_PREFIX_MACHINE = "\ud83e\udd16 ";
    private static final String COLUMN_TEXT_PREFIX_NODE = "\ud83d\udd32 ";
    private static final String COLUMN_TEXT_PREFIX_PUBLISHER = "\u2197\ufe0f ";
    private static final String COLUMN_TEXT_PREFIX_SUBSCRIPTION = "\u2198\ufe0f ";
    private static final String COLUMN_TEXT_PREFIX_TIMER = "\u23f3 ";

    private Ros2ObjectTreeLabelProvider() {
    }

    public static String getColumnText(Object element, int columnIndex) {
        TimeGraphEntry entry = (TimeGraphEntry)element;
        ITmfTreeDataModel model = entry.getEntryModel();
        if (model instanceof Ros2ObjectTimeGraphEntryModel) {
            Ros2ObjectTimeGraphEntryModel entryModel = (Ros2ObjectTimeGraphEntryModel)model;
            Ros2ObjectTimeGraphEntryModelType type = entryModel.getType();
            if (columnIndex >= 0 && columnIndex < TREE_COLUMNS.length) {
                String hostId;
                if (columnIndex == 0) {
                    @Nullable String name = Ros2ObjectTreeLabelProvider.getName(entry, type);
                    if (name != null) {
                        return name;
                    }
                } else if (1 == columnIndex) {
                    @Nullable String pid = Ros2ObjectTreeLabelProvider.getPid(entryModel, type);
                    if (pid != null) {
                        return pid;
                    }
                } else if (2 == columnIndex && (hostId = Ros2ObjectTreeLabelProvider.getHostname(entryModel, type)) != null) {
                    return hostId;
                }
            }
        } else if (columnIndex == 0) {
            return entry.getName();
        }
        return "";
    }

    private static @Nullable String getName(TimeGraphEntry entry, Ros2ObjectTimeGraphEntryModelType type) {
        if (Ros2ObjectTimeGraphEntryModelType.TRACE == type) {
            return COLUMN_TEXT_PREFIX_MACHINE + entry.getName();
        }
        if (Ros2ObjectTimeGraphEntryModelType.NODE == type) {
            return COLUMN_TEXT_PREFIX_NODE + entry.getName();
        }
        if (Ros2ObjectTimeGraphEntryModelType.PUBLISHER == type) {
            return COLUMN_TEXT_PREFIX_PUBLISHER + entry.getName();
        }
        if (Ros2ObjectTimeGraphEntryModelType.SUBSCRIPTION == type) {
            return COLUMN_TEXT_PREFIX_SUBSCRIPTION + entry.getName();
        }
        if (Ros2ObjectTimeGraphEntryModelType.TIMER == type) {
            return COLUMN_TEXT_PREFIX_TIMER + entry.getName();
        }
        return null;
    }

    private static @Nullable String getPid(Ros2ObjectTimeGraphEntryModel entryModel, Ros2ObjectTimeGraphEntryModelType type) {
        if (Ros2ObjectTimeGraphEntryModelType.NODE == type) {
            Ros2NodeObject nodeObject = (Ros2NodeObject)entryModel.getObject();
            return Long.toString(((Ros2ObjectHandle)nodeObject.getHandle()).getPid());
        }
        return null;
    }

    private static @Nullable String getHostname(Ros2ObjectTimeGraphEntryModel entryModel, Ros2ObjectTimeGraphEntryModelType type) {
        if (Ros2ObjectTimeGraphEntryModelType.TRACE == type) {
            Ros2NodeObject nodeObject = (Ros2NodeObject)entryModel.getObject();
            return Ros2ObjectTreeLabelProvider.hostnameToString(((Ros2ObjectHandle)nodeObject.getHandle()).getHostProcess().getHostId().getHostname());
        }
        return null;
    }

    public static @NonNull String hostnameToString(@NonNull String hostname) {
        return Ros2ObjectTreeLabelProvider.removeQuotes(hostname);
    }

    public static @NonNull String hostIdToString(@NonNull String hostId) {
        return Ros2ObjectTreeLabelProvider.removeQuotes(hostId);
    }

    private static @NonNull String removeQuotes(@NonNull String quotedString) {
        return Objects.requireNonNull(quotedString.replace("\"", ""));
    }
}

