/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.objects;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros2.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.AbstractRos2StateProvider;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.objects.Ros2ObjectsAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.objects.Ros2ObjectsUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.HostProcessPointer;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Gid;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2CallbackObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2CallbackType;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2NodeObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2PublisherObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2SubscriptionObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2TimerObject;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class Ros2ObjectsStateProvider
extends AbstractRos2StateProvider {
    private static final int VERSION_NUMBER = 0;
    private static final @NonNull String ROS_2_NAMESPACE_SEP = "/";
    private Map<@NonNull Gid, ITmfEvent> fDdsCreateWriterEvents = Maps.newHashMap();
    private Map<HostProcessPointer, ITmfEvent> fRmwPublisherInitEvents = Maps.newHashMap();
    private Collection<HostProcessPointer> fIgnoredCallbacks = new ArrayList<HostProcessPointer>();
    private Map<HostProcessPointer, Pair<Ros2CallbackType, @NonNull Ros2ObjectHandle>> fCallbackOwners = Maps.newHashMap();
    private Map<@NonNull Gid, ITmfEvent> fDdsCreateReaderEvents = Maps.newHashMap();
    private Map<@NonNull Ros2ObjectHandle, ITmfEvent> fRmwSubscriptionInitEvents = Maps.newHashMap();
    private Map<@NonNull Ros2ObjectHandle, ITmfEvent> fRclSubscriptionInitEvents = Maps.newHashMap();
    private Map<HostProcessPointer, ITmfEvent> fRclcppSubscriptionInitEvents = Maps.newHashMap();
    private Map<@NonNull Ros2ObjectHandle, ITmfEvent> fRclTimerInit = Maps.newHashMap();
    private Map<@NonNull Ros2ObjectHandle, ITmfEvent> fRclcppTimerCallbackAdded = Maps.newHashMap();

    public Ros2ObjectsStateProvider(ITmfTrace trace) {
        super(trace, Ros2ObjectsAnalysis.getFullAnalysisId());
    }

    public int getVersion() {
        return 0;
    }

    public @NonNull ITmfStateProvider getNewInstance() {
        return new Ros2ObjectsStateProvider(this.getTrace());
    }

    protected void eventHandle(@NonNull ITmfEvent event) {
        if (!Ros2ObjectsStateProvider.considerEvent(event)) {
            return;
        }
        ITmfStateSystemBuilder ss = Objects.requireNonNull(this.getStateSystemBuilder());
        long timestamp = event.getTimestamp().toNanos();
        Ros2ObjectsStateProvider.eventHandleNode(event, ss, timestamp);
        this.eventHandlePublisher(event, ss);
        this.eventHandleSubscription(event, ss);
        this.eventHandleTimer(event, ss, timestamp);
        this.eventHandleService(event);
        this.eventHandleCallback(event, ss, timestamp);
    }

    private static void eventHandleNode(@NonNull ITmfEvent event, ITmfStateSystemBuilder ss, long timestamp) {
        if (Ros2ObjectsStateProvider.isEvent(event, LAYOUT.eventRclNodeInit())) {
            String nodeName = (String)Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldNodeName());
            String nodeNamespace = (String)Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldNamespace());
            Ros2ObjectHandle nodeHandle = Ros2ObjectsStateProvider.handleFrom(event, (long)((Long)Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldNodeHandle())));
            String fullNodeName = Ros2ObjectsStateProvider.getFullNodeName(nodeNamespace, nodeName);
            Ros2NodeObject node = new Ros2NodeObject(nodeHandle, fullNodeName, Objects.requireNonNull(event.getTrace().getName()));
            int nodeQuark = Ros2ObjectsUtil.getNodeQuarkAndAdd(ss, (Ros2ObjectHandle)((Object)node.getHandle()));
            ss.modifyAttribute(timestamp, (Object)node, nodeQuark);
        }
    }

    private void eventHandlePublisher(@NonNull ITmfEvent event, ITmfStateSystemBuilder ss) {
        this.eventHandlePublisherDdsCreate(event);
        this.eventHandlePublisherInit(event, ss);
    }

    private void eventHandlePublisherDdsCreate(@NonNull ITmfEvent event) {
        if (Ros2ObjectsStateProvider.isEvent(event, LAYOUT.eventDdsCreateWriter())) {
            long[] gid;
            if (Ros2ObjectsStateProvider.hasField(event, LAYOUT.fieldGid())) {
                gid = (long[])Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldGid());
            } else {
                long[] gidPrefix = (long[])Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldGidPrefix());
                long[] gidEntityId = (long[])Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldGidEntity());
                gid = Ros2ObjectsStateProvider.combineFastDdsGid(gidPrefix, gidEntityId);
            }
            this.fDdsCreateWriterEvents.put(new Gid(gid), event);
        }
    }

    private void eventHandlePublisherInit(@NonNull ITmfEvent event, ITmfStateSystemBuilder ss) {
        if (Ros2ObjectsStateProvider.isEvent(event, LAYOUT.eventRmwPublisherInit())) {
            Ros2ObjectHandle rmwPublisherHandle = Ros2ObjectsStateProvider.handleFrom(event, (long)((Long)Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldRmwPublisherHandle())));
            this.fRmwPublisherInitEvents.put(rmwPublisherHandle, event);
            return;
        }
        if (Ros2ObjectsStateProvider.isEvent(event, LAYOUT.eventRclPublisherInit())) {
            Ros2ObjectHandle publisherHandle = Ros2ObjectsStateProvider.handleFrom(event, (long)((Long)Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldPublisherHandle())));
            Ros2ObjectHandle rmwPublisherHandle = Ros2ObjectsStateProvider.handleFrom(event, (long)((Long)Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldRmwPublisherHandle())));
            Ros2ObjectHandle nodeHandle = Ros2ObjectsStateProvider.handleFrom(event, (long)((Long)Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldNodeHandle())));
            String topicName = Objects.requireNonNull((String)Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldTopicName()));
            if (topicName.equals("/rosout")) {
                return;
            }
            ITmfEvent rmwPublisherInit = this.fRmwPublisherInitEvents.remove((Object)rmwPublisherHandle);
            if (rmwPublisherInit == null) {
                Activator.getInstance().logError("could not find corresponding rmw_publisher_init event for rmwPublisherHandle=" + rmwPublisherHandle.toString());
                return;
            }
            long[] rmwGid = (long[])Ros2ObjectsStateProvider.getField(rmwPublisherInit, LAYOUT.fieldGid());
            Gid gid = Ros2ObjectsStateProvider.getDdsGidFromRmwGidArray(rmwGid);
            ITmfEvent ddsCreateWriter = this.fDdsCreateWriterEvents.remove(gid);
            if (ddsCreateWriter == null) {
                Activator.getInstance().logError("could find corresponding dds:dds_create writer for gid=" + gid.toString());
                return;
            }
            HostProcessPointer ddsWriter = Ros2ObjectsStateProvider.hostProcessPointerFrom(ddsCreateWriter, (long)((Long)Ros2ObjectsStateProvider.getField(ddsCreateWriter, LAYOUT.fieldWriter())));
            Ros2PublisherObject pubObject = new Ros2PublisherObject(publisherHandle, rmwPublisherHandle, topicName, nodeHandle, gid, ddsWriter);
            int pubQuark = Ros2ObjectsUtil.getPublisherQuarkAndAdd(ss, (Ros2ObjectHandle)((Object)pubObject.getHandle()));
            long ddsTimestamp = ddsCreateWriter.getTimestamp().toNanos();
            ss.modifyAttribute(ddsTimestamp, (Object)pubObject, pubQuark);
        }
    }

    private void eventHandleSubscription(@NonNull ITmfEvent event, ITmfStateSystemBuilder ss) {
        this.eventHandleSubscriptionDdsCreate(event);
        this.eventHandleSubscriptionInit(event);
        this.eventHandleSubscriptionCallbackAdded(event, ss);
    }

    private void eventHandleSubscriptionDdsCreate(@NonNull ITmfEvent event) {
        if (Ros2ObjectsStateProvider.isEvent(event, LAYOUT.eventDdsCreateReader())) {
            long[] gid;
            if (Ros2ObjectsStateProvider.hasField(event, LAYOUT.fieldGid())) {
                gid = (long[])Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldGid());
            } else {
                long[] gidPrefix = (long[])Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldGidPrefix());
                long[] gidEntityId = (long[])Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldGidEntity());
                gid = ArrayUtils.addAll((long[])gidPrefix, (long[])gidEntityId);
            }
            this.fDdsCreateReaderEvents.put(new Gid(gid), event);
        }
    }

    private void eventHandleSubscriptionInit(@NonNull ITmfEvent event) {
        if (Ros2ObjectsStateProvider.isEvent(event, LAYOUT.eventRmwSubscriptionInit())) {
            Ros2ObjectHandle rmwSubscriptionHandle = Ros2ObjectsStateProvider.handleFrom(event, (long)((Long)Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldRmwSubscriptionHandle())));
            this.fRmwSubscriptionInitEvents.put(rmwSubscriptionHandle, event);
            return;
        }
        if (Ros2ObjectsStateProvider.isEvent(event, LAYOUT.eventRclSubscriptionInit())) {
            Ros2ObjectHandle subscriptionHandle = Ros2ObjectsStateProvider.handleFrom(event, (long)((Long)Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldSubscriptionHandle())));
            this.fRclSubscriptionInitEvents.put(subscriptionHandle, event);
            return;
        }
        if (Ros2ObjectsStateProvider.isEvent(event, LAYOUT.eventRclcppSubscriptionInit())) {
            HostProcessPointer subscription = Ros2ObjectsStateProvider.hostProcessPointerFrom(event, (long)((Long)Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldSubscription())));
            this.fRclcppSubscriptionInitEvents.put(subscription, event);
        }
    }

    private void eventHandleSubscriptionCallbackAdded(@NonNull ITmfEvent event, ITmfStateSystemBuilder ss) {
        if (Ros2ObjectsStateProvider.isEvent(event, LAYOUT.eventRclcppSubscriptionCallbackAdded())) {
            HostProcessPointer subscription = Ros2ObjectsStateProvider.hostProcessPointerFrom(event, (long)((Long)Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldSubscription())));
            HostProcessPointer callback = Ros2ObjectsStateProvider.hostProcessPointerFrom(event, (long)((Long)Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldCallback())));
            ITmfEvent rclcppSubscriptionInit = this.fRclcppSubscriptionInitEvents.remove((Object)subscription);
            if (rclcppSubscriptionInit == null) {
                Activator.getInstance().logError("could not find corresponding rclcpp_subscription_init event for subscription=" + subscription.toString());
                return;
            }
            Ros2ObjectHandle subscriptionHandle = Ros2ObjectsStateProvider.handleFrom(rclcppSubscriptionInit, (long)((Long)Ros2ObjectsStateProvider.getField(rclcppSubscriptionInit, LAYOUT.fieldSubscriptionHandle())));
            ITmfEvent rclSubscriptionInit = this.fRclSubscriptionInitEvents.remove((Object)subscriptionHandle);
            if (rclSubscriptionInit == null) {
                Activator.getInstance().logError("could not find corresponding rcl_subscription_init event for subscriptionHandle=" + subscriptionHandle.toString());
                return;
            }
            Ros2ObjectHandle rmwSubscriptionHandle = Ros2ObjectsStateProvider.handleFrom(rclSubscriptionInit, (long)((Long)Ros2ObjectsStateProvider.getField(rclSubscriptionInit, LAYOUT.fieldRmwSubscriptionHandle())));
            Ros2ObjectHandle nodeHandle = Ros2ObjectsStateProvider.handleFrom(rclSubscriptionInit, (long)((Long)Ros2ObjectsStateProvider.getField(rclSubscriptionInit, LAYOUT.fieldNodeHandle())));
            String topicName = Objects.requireNonNull((String)Ros2ObjectsStateProvider.getField(rclSubscriptionInit, LAYOUT.fieldTopicName()));
            ITmfEvent rmwSubscriptionInit = this.fRmwSubscriptionInitEvents.remove((Object)rmwSubscriptionHandle);
            if (rmwSubscriptionInit == null) {
                Activator.getInstance().logError("could not find corresponding rmw_susbcription_init event for rmwSubscriptionHandle=" + rmwSubscriptionHandle.toString());
                return;
            }
            long[] gidRmw = (long[])Ros2ObjectsStateProvider.getField(rmwSubscriptionInit, LAYOUT.fieldGid());
            Gid gid = Ros2ObjectsStateProvider.getDdsGidFromRmwGidArray(gidRmw);
            ITmfEvent ddsCreateReader = this.fDdsCreateReaderEvents.remove(gid);
            if (ddsCreateReader == null) {
                Activator.getInstance().logError("could not find corresponding dds:create_reader event for gid=" + gid.toString());
                return;
            }
            HostProcessPointer ddsReader = Ros2ObjectsStateProvider.hostProcessPointerFrom(ddsCreateReader, (long)((Long)Ros2ObjectsStateProvider.getField(ddsCreateReader, LAYOUT.fieldReader())));
            this.fCallbackOwners.put(callback, (Pair<Ros2CallbackType, Ros2ObjectHandle>)new Pair((Object)Ros2CallbackType.SUBSCRIPTION, (Object)subscriptionHandle));
            Ros2SubscriptionObject subscriptionObject = new Ros2SubscriptionObject(subscriptionHandle, rmwSubscriptionHandle, topicName, nodeHandle, gid, ddsReader, subscription, callback);
            int subQuark = Ros2ObjectsUtil.getSubscriptionQuarkAndAdd(ss, (Ros2ObjectHandle)((Object)subscriptionObject.getHandle()));
            long ddsTimestamp = ddsCreateReader.getTimestamp().toNanos();
            ss.modifyAttribute(ddsTimestamp, (Object)subscriptionObject, subQuark);
        }
    }

    private void eventHandleTimer(@NonNull ITmfEvent event, ITmfStateSystemBuilder ss, long timestamp) {
        this.eventHandleTimerInit(event);
        this.eventHandleTimerCallbackAdded(event);
        this.eventHandleTimerLinkNode(event, ss, timestamp);
    }

    private void eventHandleTimerInit(@NonNull ITmfEvent event) {
        if (Ros2ObjectsStateProvider.isEvent(event, LAYOUT.eventRclTimerInit())) {
            Ros2ObjectHandle timerHandle = Ros2ObjectsStateProvider.handleFrom(event, (long)((Long)Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldTimerHandle())));
            this.fRclTimerInit.put(timerHandle, event);
        }
    }

    private void eventHandleTimerCallbackAdded(@NonNull ITmfEvent event) {
        if (Ros2ObjectsStateProvider.isEvent(event, LAYOUT.eventRclcppTimerCallbackAdded())) {
            Ros2ObjectHandle timerHandle = Ros2ObjectsStateProvider.handleFrom(event, (long)((Long)Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldTimerHandle())));
            this.fRclcppTimerCallbackAdded.put(timerHandle, event);
            HostProcessPointer callback = Ros2ObjectsStateProvider.hostProcessPointerFrom(event, (long)((Long)Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldCallback())));
            this.fCallbackOwners.put(callback, (Pair<Ros2CallbackType, Ros2ObjectHandle>)new Pair((Object)Ros2CallbackType.TIMER, (Object)timerHandle));
        }
    }

    private void eventHandleTimerLinkNode(@NonNull ITmfEvent event, ITmfStateSystemBuilder ss, long timestamp) {
        if (Ros2ObjectsStateProvider.isEvent(event, LAYOUT.eventRclcppTimerLinkNode())) {
            Ros2ObjectHandle timerHandle = Ros2ObjectsStateProvider.handleFrom(event, (long)((Long)Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldTimerHandle())));
            Ros2ObjectHandle nodeHandle = Ros2ObjectsStateProvider.handleFrom(event, (long)((Long)Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldNodeHandle())));
            ITmfEvent rclcppTimerCallbackAdded = this.fRclcppTimerCallbackAdded.remove((Object)timerHandle);
            if (rclcppTimerCallbackAdded == null) {
                Activator.getInstance().logError("could not find corresponding rclcpp_timer_callback_added event for timerHandle=" + timerHandle.toString());
                return;
            }
            HostProcessPointer callback = Ros2ObjectsStateProvider.hostProcessPointerFrom(rclcppTimerCallbackAdded, (long)((Long)Ros2ObjectsStateProvider.getField(rclcppTimerCallbackAdded, LAYOUT.fieldCallback())));
            ITmfEvent rclTimerInit = this.fRclTimerInit.remove((Object)timerHandle);
            if (rclTimerInit == null) {
                Activator.getInstance().logError("could not find corresponding rcl_timer_init event for timerHandle=" + timerHandle.toString());
                return;
            }
            long period = (Long)Ros2ObjectsStateProvider.getField(rclTimerInit, LAYOUT.fieldPeriod());
            Ros2TimerObject timerObject = new Ros2TimerObject(timerHandle, period, callback, nodeHandle);
            int timerQuark = Ros2ObjectsUtil.getTimerQuarkAndAdd(ss, (Ros2ObjectHandle)((Object)timerObject.getHandle()));
            ss.modifyAttribute(timestamp, (Object)timerObject, timerQuark);
        }
    }

    private void eventHandleService(@NonNull ITmfEvent event) {
        if (Ros2ObjectsStateProvider.isEvent(event, LAYOUT.eventRclcppServiceCallbackAdded())) {
            HostProcessPointer callback = Ros2ObjectsStateProvider.hostProcessPointerFrom(event, (long)((Long)Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldCallback())));
            this.fIgnoredCallbacks.add(callback);
        }
    }

    private void eventHandleCallback(@NonNull ITmfEvent event, ITmfStateSystemBuilder ss, long timestamp) {
        if (Ros2ObjectsStateProvider.isEvent(event, LAYOUT.eventRclcppCallbackRegister())) {
            HostProcessPointer callback = Ros2ObjectsStateProvider.hostProcessPointerFrom(event, (long)((Long)Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldCallback())));
            String symbol = (String)Ros2ObjectsStateProvider.getField(event, LAYOUT.fieldSymbol());
            if (this.fIgnoredCallbacks.contains((Object)callback)) {
                return;
            }
            Pair<Ros2CallbackType, @NonNull Ros2ObjectHandle> ownerInfo = this.fCallbackOwners.remove((Object)callback);
            if (ownerInfo == null) {
                Activator.getInstance().logError("could not find callback owner info for callback=" + callback.toString());
                return;
            }
            Ros2CallbackType type = (Ros2CallbackType)((Object)ownerInfo.getFirst());
            @NonNull Ros2ObjectHandle ownerHandle = (Ros2ObjectHandle)((Object)ownerInfo.getSecond());
            Ros2CallbackObject callbackObject = new Ros2CallbackObject(callback, ownerHandle, Objects.requireNonNull(symbol), type);
            int callbackQuark = Ros2ObjectsUtil.getCallbackQuarkAndAdd(ss, callbackObject.getCallback());
            ss.modifyAttribute(timestamp, (Object)callbackObject, callbackQuark);
        }
    }

    private static @NonNull String getFullNodeName(String namespace, String nodeName) {
        String separator = "";
        if (!namespace.endsWith(ROS_2_NAMESPACE_SEP)) {
            separator = ROS_2_NAMESPACE_SEP;
        }
        return namespace + separator + nodeName;
    }

    private static long[] combineFastDdsGid(long[] gidPrefix, long[] gidEntityId) {
        return ArrayUtils.addAll((long[])gidPrefix, (long[])gidEntityId);
    }

    private static @NonNull Gid getDdsGidFromRmwGidArray(long[] rmwGid) {
        long[] ddsGid = Arrays.copyOfRange(rmwGid, 0, rmwGid.length - 8);
        return new Gid(ddsGid);
    }
}

