/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiGenericAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.Messages;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiIRQ;

public class LamiIRQTypeAspect
extends LamiGenericAspect {
    public LamiIRQTypeAspect(String colName, int colIndex) {
        super(colName + " (" + Messages.LamiAspect_Type + ")", null, colIndex, false, false);
    }

    @Override
    public @Nullable String resolveString(LamiTableEntry entry) {
        LamiData data = entry.getValue(this.getColIndex());
        if (data instanceof LamiIRQ) {
            LamiIRQ irq = (LamiIRQ)data;
            switch (irq.getType()) {
                case HARD: {
                    return Messages.LamiIRQTypeAspect_HardwareIRQ;
                }
                case SOFT: {
                    return Messages.LamiIRQTypeAspect_SoftIRQ;
                }
            }
            return "?";
        }
        return data.toString();
    }

    @Override
    public @Nullable Number resolveNumber(LamiTableEntry entry) {
        return null;
    }
}

