/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.ui.internal.ide.registry.IDERegistryReader;
import org.eclipse.ui.internal.ide.registry.ProjectImageRegistry;

public class ProjectImageRegistryReader
extends IDERegistryReader {
    private static final String TAG_IMAGE = "image";
    private static final String ATT_ID = "id";
    private static final String ATT_NATURE_ID = "natureId";
    private static final String ATT_ICON = "icon";
    private ProjectImageRegistry registry;

    @Override
    protected boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(TAG_IMAGE)) {
            return false;
        }
        String id = element.getAttribute(ATT_ID);
        if (id == null) {
            this.logMissingAttribute(element, ATT_ID);
            return true;
        }
        String natureId = element.getAttribute(ATT_NATURE_ID);
        if (natureId == null) {
            this.logMissingAttribute(element, ATT_NATURE_ID);
            return true;
        }
        String icon = element.getAttribute(ATT_ICON);
        if (icon == null) {
            this.logMissingAttribute(element, ATT_ICON);
            return true;
        }
        String extendingPluginId = element.getContributor().getName();
        ResourceLocator.imageDescriptorFromBundle((String)extendingPluginId, (String)icon).ifPresent(d -> this.registry.setNatureImage(natureId, (ImageDescriptor)d));
        return true;
    }

    public void readProjectNatureImages(IExtensionRegistry in, ProjectImageRegistry out) {
        this.registry = out;
        this.readRegistry(in, "org.eclipse.ui.ide", "projectNatureImages");
    }
}

