/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.memory;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.memory.MemoryUsageTreeModel;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.memory.Messages;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.memory.UstMemoryAnalysisModule;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.YModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.AbstractTreeCommonXDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

@NonNullByDefault
public class UstMemoryUsageDataProvider
extends AbstractTreeCommonXDataProvider<UstMemoryAnalysisModule, MemoryUsageTreeModel> {
    public static final String ID = "org.eclipse.tracecompass.lttng2.ust.core.analysis.memory.UstMemoryUsageDataProvider";

    public static @Nullable UstMemoryUsageDataProvider create(ITmfTrace trace) {
        UstMemoryAnalysisModule module = (UstMemoryAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, UstMemoryAnalysisModule.class, (String)"org.eclipse.linuxtools.lttng2.ust.analysis.memory");
        if (module != null) {
            module.schedule();
            return new UstMemoryUsageDataProvider(trace, module);
        }
        return null;
    }

    private UstMemoryUsageDataProvider(ITmfTrace trace, UstMemoryAnalysisModule module) {
        super(trace, (TmfStateSystemAnalysisModule)module);
    }

    protected @Nullable Collection<IYModel> getYSeriesModels(ITmfStateSystem ss, Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(fetchParameters);
        if (filter == null) {
            return null;
        }
        long[] xValues = filter.getTimesRequested();
        long currentEnd = ss.getCurrentEndTime();
        Map<Integer, IYModel> models = this.initYModels(ss, filter);
        for (ITmfStateInterval interval : ss.query2D(models.keySet(), UstMemoryUsageDataProvider.getTimes((TimeQueryFilter)filter, (long)ss.getStartTime(), (long)currentEnd))) {
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            IYModel model = models.get(interval.getAttribute());
            Object value = interval.getValue();
            if (model == null || !(value instanceof Number)) continue;
            int from = Arrays.binarySearch(xValues, interval.getStartTime());
            from = from >= 0 ? from : -1 - from;
            int to = Arrays.binarySearch(xValues, interval.getEndTime());
            to = to >= 0 ? to + 1 : -1 - to;
            Arrays.fill(model.getData(), from, to, ((Number)value).doubleValue());
        }
        return models.values();
    }

    private Map<Integer, IYModel> initYModels(ITmfStateSystem ss, SelectionTimeQueryFilter filter) {
        HashMap<Integer, IYModel> selectedSeries = new HashMap<Integer, IYModel>();
        int length = filter.getTimesRequested().length;
        for (Map.Entry entry : this.getSelectedEntries(filter).entrySet()) {
            int tidQuark = (Integer)entry.getValue();
            int memoryAttribute = ss.optQuarkRelative(tidQuark, new String[]{"Memory"});
            if (memoryAttribute == -2) continue;
            String name = String.valueOf(this.getTrace().getName()) + ':' + ss.getAttributeName(tidQuark);
            selectedSeries.put(memoryAttribute, (IYModel)new YModel(((Long)entry.getKey()).longValue(), name, new double[length]));
        }
        return selectedSeries;
    }

    protected TmfTreeModel<MemoryUsageTreeModel> getTree(ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        TimeQueryFilter filter = FetchParametersUtils.createTimeQuery(parameters);
        if (filter == null) {
            return new TmfTreeModel(Collections.emptyList(), Collections.emptyList());
        }
        long start = filter.getStart();
        long end = filter.getEnd();
        List active = null;
        Boolean isFiltered = DataProviderParameterUtils.extractIsFiltered(parameters);
        if (isFiltered != null && isFiltered.booleanValue()) {
            if (start == end || start > ss.getCurrentEndTime() || end < ss.getStartTime()) {
                return new TmfTreeModel(Collections.emptyList(), Collections.emptyList());
            }
            active = ss.queryFullState(Long.max(start, ss.getStartTime()));
        }
        List nameFullState = ss.queryFullState(ss.getCurrentEndTime());
        List tidQuarks = ss.getSubAttributes(-1, false);
        ImmutableList.Builder builder = ImmutableList.builder();
        long rootId = this.getId(-1);
        builder.add((Object)new MemoryUsageTreeModel(rootId, -1L, -1, Collections.singletonList(this.getTrace().getName())));
        Iterator iterator = tidQuarks.iterator();
        while (iterator.hasNext()) {
            int quark = (Integer)iterator.next();
            int memoryAttribute = ss.optQuarkRelative(quark, new String[]{"Memory"});
            int procNameQuark = ss.optQuarkRelative(quark, new String[]{"Procname"});
            String name = ss.getAttributeName(quark);
            if (procNameQuark != -2 && procNameQuark < nameFullState.size()) {
                name = String.valueOf(((ITmfStateInterval)nameFullState.get(procNameQuark)).getValue());
            }
            if (memoryAttribute == -2 || active != null && (memoryAttribute >= active.size() || ((ITmfStateInterval)active.get(memoryAttribute)).getEndTime() >= end)) continue;
            int tid = Integer.parseInt(ss.getAttributeName(quark));
            builder.add((Object)new MemoryUsageTreeModel(this.getId(quark), rootId, tid, Collections.singletonList(name)));
        }
        return new TmfTreeModel(Collections.emptyList(), (List)builder.build());
    }

    public String getId() {
        return ID;
    }

    protected boolean isCacheable() {
        return false;
    }

    protected String getTitle() {
        return Objects.requireNonNull(Messages.MemoryUsageDataProvider_Title);
    }
}

