/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.dom.binding;

import java.util.List;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.internal.core.dom.binding.BindingBase;
import org.eclipse.wst.jsdt.internal.core.dom.binding.IReference;
import org.eclipse.wst.jsdt.internal.core.dom.binding.VariableDeclaration;

public class VariableBinding
extends BindingBase
implements IVariableBinding {
    protected ITypeBinding type;
    protected IFunctionBinding declaringMethod;
    protected boolean isArguments;

    public VariableBinding(VariableDeclaration declaration, List<IReference> refs, IFunctionBinding declaringMethod, int modifiers) {
        super(declaration, modifiers);
        this.isArguments = declaration.isArguments();
        this.setDeclaration(this);
        this.declaringMethod = declaringMethod;
        int i = this.isArguments ? 0 : 1;
        while (i < refs.size()) {
            IReference r = refs.get(i);
            this.references.add(new VariableBinding(r, modifiers, this));
            ++i;
        }
    }

    public VariableBinding(IReference reference, int modifiers, VariableBinding variableDeclaration) {
        super(reference, modifiers);
        this.isArguments = variableDeclaration.isArguments;
        this.setDeclaration(variableDeclaration);
        this.declaringMethod = variableDeclaration.declaringMethod;
    }

    @Override
    public int getKind() {
        return 3;
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean isParameter() {
        return false;
    }

    @Override
    public ITypeBinding getDeclaringClass() {
        return null;
    }

    @Override
    public ITypeBinding getType() {
        return this.type;
    }

    @Override
    public int getVariableId() {
        return 0;
    }

    @Override
    public Object getConstantValue() {
        return null;
    }

    @Override
    public IFunctionBinding getDeclaringMethod() {
        return this.declaringMethod;
    }

    public void setDeclaringMethod(IFunctionBinding declaringMethod) {
        this.declaringMethod = declaringMethod;
    }

    @Override
    public IVariableBinding getVariableDeclaration() {
        return (IVariableBinding)((Object)this.getDeclaration());
    }

    @Override
    public String toString() {
        String result = "{VB name: " + this.getName();
        result = String.valueOf(result) + " key: " + this.getKey();
        result = String.valueOf(result) + " in " + (this.declaringMethod != null ? this.declaringMethod.toString() : "script") + "}";
        return result;
    }

    @Override
    public String getName() {
        if (this.isArguments) {
            return "arguments";
        }
        return super.getName();
    }
}

