/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.helpers;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewProjectAction;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.navigator.wizards.WizardShortcutAction;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.ui.wizards.IWizardRegistry;

public final class EmptyWorkspaceHelper {
    private Composite parent;
    private Composite emptyArea;
    private StackLayout layout;
    private Control control;
    private Composite displayArea;
    private ArrayList<IAction> projectWizardActions;
    private IAction newProjectAction;
    private IAction importAction;
    private LocalResourceManager resourceManager;
    private Runnable switchTopControlRunnable = () -> {
        if (this.switchTopControl()) {
            this.displayArea.requestLayout();
        }
    };

    public Composite getComposite(Composite aParent) {
        this.parent = aParent;
        this.displayArea = new Composite(this.parent, 0);
        this.layout = new StackLayout();
        this.displayArea.setLayout((Layout)this.layout);
        this.createEmptyArea(this.displayArea);
        this.registerListeners();
        return this.displayArea;
    }

    public void setNonEmptyControl(Control control) {
        this.control = control;
        this.emptyArea.setBackground(control.getBackground());
        this.switchTopControl();
    }

    private void dispose(Listener listener) {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            activeWorkbenchWindow.removePerspectiveListener((IPerspectiveListener)listener);
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)listener);
        this.parent.removeDisposeListener((DisposeListener)listener);
        this.parent = null;
        this.emptyArea = null;
        this.layout = null;
        this.control = null;
        this.displayArea = null;
        this.projectWizardActions = null;
        this.newProjectAction = null;
        this.importAction = null;
    }

    private void registerListeners() {
        Listener listener = new Listener();
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            activeWorkbenchWindow.addPerspectiveListener((IPerspectiveListener)listener);
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 1);
        JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)listener);
        this.parent.addDisposeListener((DisposeListener)listener);
    }

    private void createEmptyArea(Composite displayAreas) {
        if (this.newProjectAction == null) {
            this.newProjectAction = new NewProjectAction();
        }
        if (this.importAction == null) {
            this.importAction = new ImportAction();
        }
        if (this.projectWizardActions == null) {
            this.projectWizardActions = new ArrayList();
            this.readProjectWizardActions();
        }
        this.emptyArea = new Composite(displayAreas, 0);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.emptyArea);
        this.emptyArea.setBackgroundMode(2);
        GridLayoutFactory.fillDefaults().applyTo(this.emptyArea);
        Composite infoArea = new Composite(this.emptyArea, 0);
        GridDataFactory.swtDefaults().align(16384, 128).grab(true, true).indent(5, 5).applyTo((Control)infoArea);
        GridLayoutFactory.swtDefaults().applyTo(infoArea);
        Link messageLabel = new Link(infoArea, 64);
        Composite optionsArea = null;
        messageLabel.setText(ResourceNavigatorMessages.EmptyWorkspaceHelper_noProjectsAvailable);
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo((Control)messageLabel);
        optionsArea = new Composite(infoArea, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(optionsArea);
        GridDataFactory.swtDefaults().indent(5, 0).grab(true, true).applyTo((Control)optionsArea);
        FormToolkit toolkit = new FormToolkit(this.emptyArea.getDisplay());
        this.emptyArea.addDisposeListener(e -> toolkit.dispose());
        Color linkColor = JFaceColors.getHyperlinkText((Display)this.emptyArea.getDisplay());
        for (IAction action : this.projectWizardActions) {
            String description = action.getDescription();
            if (description == null || description.isEmpty()) {
                description = action.getText();
            }
            this.createOption(optionsArea, toolkit, linkColor, action, action.getImageDescriptor(), description);
        }
        this.createOption(optionsArea, toolkit, linkColor, this.newProjectAction, this.newProjectAction.getImageDescriptor(), ResourceNavigatorMessages.EmptyWorkspaceHelper_createProject);
        this.createOption(optionsArea, toolkit, linkColor, this.importAction, WorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_IMPORT_WIZ"), ResourceNavigatorMessages.EmptyWorkspaceHelper_importProjects);
    }

    private void recreateEmptyArea() {
        this.disposeEmptyArea();
        this.projectWizardActions = null;
        this.createEmptyArea(this.displayArea);
        if (this.control != null && !this.control.isDisposed()) {
            this.emptyArea.setBackground(this.control.getBackground());
        }
    }

    private void disposeEmptyArea() {
        if (this.emptyArea != null) {
            this.emptyArea.dispose();
            this.emptyArea = null;
        }
    }

    private void readProjectWizardActions() {
        if (this.projectWizardActions == null) {
            return;
        }
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        if (win == null) {
            return;
        }
        IWorkbenchPage page = win.getActivePage();
        String[] wizardIds = page.getNewWizardShortcuts();
        this.projectWizardActions.clear();
        String[] stringArray = wizardIds;
        int n = wizardIds.length;
        int n2 = 0;
        while (n2 < n) {
            String wizardId = stringArray[n2];
            IWizardRegistry newWizardRegistry = WorkbenchPlugin.getDefault().getNewWizardRegistry();
            IWizardDescriptor wizardDesc = newWizardRegistry.findWizard(wizardId);
            if (wizardDesc != null) {
                String[] tags;
                String[] stringArray2 = tags = wizardDesc.getTags();
                int n3 = tags.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAction action;
                    String tag = stringArray2[n4];
                    if ("project".equals(tag) && (action = this.getAction(newWizardRegistry, wizardId)) != null) {
                        this.projectWizardActions.add(action);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void createOption(Composite optionsArea, FormToolkit toolkit, Color linkColor, final IAction action, ImageDescriptor imageDesc, String text) {
        Label addLabel = new Label(optionsArea, 0);
        if (imageDesc == null) {
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            imageDesc = images.getImageDescriptor("IMG_TOOL_NEW_WIZARD");
        }
        addLabel.setImage(this.resourceManager.createImage(imageDesc));
        Hyperlink addLink = toolkit.createHyperlink(optionsArea, text, 64);
        addLink.setForeground(linkColor);
        addLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                action.run();
            }
        });
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo((Control)addLink);
    }

    private IAction getAction(IWizardRegistry registry, String id) {
        IWizardDescriptor wizardDesc = registry.findWizard(id);
        WizardShortcutAction action = null;
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        if (wizardDesc != null && win != null) {
            action = new WizardShortcutAction(win, wizardDesc);
        }
        return action;
    }

    private boolean switchTopControl() {
        if (this.control == null || this.control.isDisposed()) {
            return false;
        }
        Control oldTop = this.layout.topControl;
        IProject[] projs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (projs.length > 0) {
            this.layout.topControl = this.control;
            this.disposeEmptyArea();
        } else {
            if (this.emptyArea == null || this.emptyArea.isDisposed()) {
                this.recreateEmptyArea();
            }
            this.layout.topControl = this.emptyArea;
        }
        return oldTop != this.layout.topControl;
    }

    private static class ImportAction
    extends Action {
        private ImportAction() {
        }

        public void run() {
            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWorkbenchWindow == null) {
                return;
            }
            IHandlerService handlerService = (IHandlerService)activeWorkbenchWindow.getService(IHandlerService.class);
            try {
                handlerService.executeCommand("org.eclipse.ui.file.import", null);
            }
            catch (Exception ex) {
                IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), "run", ex);
            }
        }
    }

    private class Listener
    implements IResourceChangeListener,
    IPerspectiveListener,
    IPropertyChangeListener,
    DisposeListener {
        private Listener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta resourceDelta = event.getDelta();
            if (resourceDelta != null) {
                IResourceDelta[] affectedChildren;
                IResourceDelta[] iResourceDeltaArray = affectedChildren = resourceDelta.getAffectedChildren();
                int n = affectedChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta affectedChildResourceDelta = iResourceDeltaArray[n2];
                    IResource resource = affectedChildResourceDelta.getResource();
                    int kind = affectedChildResourceDelta.getKind();
                    if (resource instanceof IProject && (kind == 1 || kind == 2)) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> PlatformUI.getWorkbench().getDisplay().timerExec(200, EmptyWorkspaceHelper.this.switchTopControlRunnable));
                        return;
                    }
                    ++n2;
                }
            }
        }

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            if (EmptyWorkspaceHelper.this.emptyArea != null) {
                EmptyWorkspaceHelper.this.recreateEmptyArea();
                EmptyWorkspaceHelper.this.switchTopControlRunnable.run();
            }
        }

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (EmptyWorkspaceHelper.this.emptyArea != null && "HYPERLINK_COLOR".equals(event.getProperty())) {
                EmptyWorkspaceHelper.this.recreateEmptyArea();
                EmptyWorkspaceHelper.this.switchTopControlRunnable.run();
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            EmptyWorkspaceHelper.this.dispose(this);
        }
    }
}

