/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DefaultLabelProvider;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class LaunchersPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TreeViewer fTreeViewer = null;
    private CheckboxTableViewer fTableViewer = null;
    private Map<ILaunchConfigurationType, Set<DuplicateDelegate>> fDuplicates = null;
    private Map<DuplicateDelegate, ILaunchDelegate> fDupeSelections = null;
    private boolean fDirty = false;
    private Label fDescription = null;

    public LaunchersPreferencePage() {
        this.setTitle(DebugPreferencesMessages.LaunchDelegatesPreferencePage_0);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.debug.ui.launch_delegate_preference_page_context");
    }

    protected Control createContents(Composite parent) {
        boolean enabled;
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 1808);
        SWTFactory.createWrapLabel(comp, DebugPreferencesMessages.LaunchDelegatesPreferencePage_1, 2, 300);
        boolean bl = enabled = this.fDuplicates.size() > 0;
        if (!enabled) {
            SWTFactory.createVerticalSpacer(comp, 1);
            SWTFactory.createWrapLabel(comp, DebugPreferencesMessages.LaunchersPreferencePage_0, 2, 300);
        }
        SWTFactory.createVerticalSpacer(comp, 1);
        Composite comp1 = SWTFactory.createComposite(comp, 1, 1, 1040);
        SWTFactory.createLabel(comp1, DebugPreferencesMessages.LaunchDelegatesPreferencePage_2, 1);
        Tree tree = new Tree(comp1, 2820);
        tree.setEnabled(enabled);
        tree.setFont(parent.getFont());
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = false;
        tree.setLayoutData((Object)gd);
        this.fTreeViewer = new TreeViewer(tree);
        this.fTreeViewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        this.fTreeViewer.setContentProvider((IContentProvider)new TreeProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fTreeViewer.setInput(this.fDuplicates);
        this.fTreeViewer.expandToLevel(2);
        this.fTreeViewer.addSelectionChangedListener(event -> {
            Object obj = event.getStructuredSelection().getFirstElement();
            if (obj instanceof DuplicateDelegate) {
                this.fTableViewer.setAllChecked(false);
                DuplicateDelegate dd = (DuplicateDelegate)obj;
                this.fTableViewer.setInput((Object)dd.getDelegates());
                this.fTableViewer.setSelection(null);
                obj = this.fDupeSelections.get(dd);
                if (obj != null) {
                    this.fTableViewer.setChecked(obj, true);
                    this.fTableViewer.setSelection((ISelection)new StructuredSelection(obj));
                }
            } else {
                this.fTableViewer.setInput(null);
            }
        });
        Composite comp2 = SWTFactory.createComposite(comp, comp.getFont(), 1, 1, 1808);
        SWTFactory.createLabel(comp2, DebugPreferencesMessages.LaunchDelegatesPreferencePage_3, 1);
        Table table = new Table(comp2, 2852);
        table.setEnabled(enabled);
        table.setLayoutData((Object)new GridData(1808));
        table.setFont(parent.getFont());
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fTableViewer.addSelectionChangedListener(event -> {
            IStructuredSelection ss = event.getStructuredSelection();
            if (ss != null && !ss.isEmpty()) {
                ILaunchDelegate delegate = (ILaunchDelegate)ss.getFirstElement();
                this.fDescription.setText(delegate.getDescription());
            } else {
                this.fDescription.setText("");
            }
        });
        this.fTableViewer.addCheckStateListener(event -> {
            this.fDirty = true;
            Object element = event.getElement();
            boolean checked = event.getChecked();
            this.fTableViewer.setCheckedElements(new Object[]{element});
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(element));
            Object obj = this.fTreeViewer.getStructuredSelection().getFirstElement();
            if (obj instanceof DuplicateDelegate) {
                this.fDupeSelections.remove(obj);
                if (checked) {
                    this.fDupeSelections.put((DuplicateDelegate)obj, (ILaunchDelegate)element);
                }
            }
        });
        Group group = SWTFactory.createGroup(comp, DebugPreferencesMessages.LaunchDelegatesPreferencePage_4, 1, 2, 1808);
        this.fDescription = SWTFactory.createWrapLabel((Composite)group, "", 1);
        return comp;
    }

    public boolean performOk() {
        if (this.fDirty && this.fDupeSelections != null && this.fDupeSelections.size() > 0) {
            this.fDirty = false;
            DuplicateDelegate dd2 = null;
            ILaunchDelegate delegate = null;
            for (DuplicateDelegate dd2 : this.fDupeSelections.keySet()) {
                delegate = this.fDupeSelections.get(dd2);
                try {
                    dd2.getType().setPreferredDelegate(dd2.getModeSet(), delegate);
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
        }
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
        try {
            this.setPreferenceStore(DebugUIPlugin.getDefault().getPreferenceStore());
            LaunchManager lm = (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType[] types = lm.getLaunchConfigurationTypes();
            this.fDuplicates = new HashMap<ILaunchConfigurationType, Set<DuplicateDelegate>>();
            this.fDupeSelections = new HashMap<DuplicateDelegate, ILaunchDelegate>();
            ILaunchDelegate[] delegates = null;
            Set modes = null;
            Set modeset2 = null;
            Set<DuplicateDelegate> tmp = null;
            ILaunchDelegate prefdelegate = null;
            DuplicateDelegate dd = null;
            ILaunchConfigurationType[] iLaunchConfigurationTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfigurationType type = iLaunchConfigurationTypeArray[n2];
                modes = type.getSupportedModeCombinations();
                for (Set modeset2 : modes) {
                    delegates = type.getDelegates(modeset2);
                    if (delegates.length <= 1) continue;
                    tmp = this.fDuplicates.get(type);
                    if (tmp == null) {
                        tmp = new HashSet<DuplicateDelegate>();
                    }
                    dd = new DuplicateDelegate(type, delegates, modeset2);
                    tmp.add(dd);
                    this.fDuplicates.put(type, tmp);
                    prefdelegate = type.getPreferredDelegate(modeset2);
                    if (prefdelegate == null) continue;
                    this.fDupeSelections.put(dd, prefdelegate);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
    }

    class DuplicateDelegate {
        private ILaunchConfigurationType fType = null;
        private ILaunchDelegate[] fDelegates = null;
        private Set<String> fModes = null;

        public DuplicateDelegate(ILaunchConfigurationType type, ILaunchDelegate[] delegates, Set<String> modes) {
            this.fModes = modes;
            this.fType = type;
            this.fDelegates = delegates;
        }

        public ILaunchConfigurationType getType() {
            return this.fType;
        }

        public ILaunchDelegate[] getDelegates() {
            return this.fDelegates;
        }

        public Set<String> getModeSet() {
            return this.fModes;
        }
    }

    class LabelProvider
    extends DefaultLabelProvider {
        LabelProvider() {
        }

        @Override
        public String getText(Object element) {
            if (element instanceof ILaunchConfigurationType) {
                return super.getText(element);
            }
            if (element instanceof DuplicateDelegate) {
                DuplicateDelegate dd = (DuplicateDelegate)element;
                return LaunchConfigurationPresentationManager.getDefault().getLaunchModeNames(dd.getModeSet()).toString();
            }
            if (element instanceof ILaunchDelegate) {
                return ((ILaunchDelegate)element).getName();
            }
            return element.toString();
        }
    }

    class TreeProvider
    implements ITreeContentProvider {
        TreeProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ILaunchConfigurationType) {
                ILaunchConfigurationType type = (ILaunchConfigurationType)parentElement;
                Set<DuplicateDelegate> dupes = LaunchersPreferencePage.this.fDuplicates.get(type);
                if (dupes != null) {
                    return dupes.toArray();
                }
                return null;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ILaunchConfigurationType;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                return ((Map)inputElement).keySet().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }
    }
}

