/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.analysis.core.aspects;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxPidAspect;
import org.eclipse.tracecompass.incubator.analysis.core.aspects.ProcessNameAspect;
import org.eclipse.tracecompass.incubator.analysis.core.model.IHostModel;
import org.eclipse.tracecompass.incubator.analysis.core.model.ModelManager;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public final class AnalysisProcessNameAspect
extends ProcessNameAspect {
    private static final AnalysisProcessNameAspect INSTANCE = new AnalysisProcessNameAspect();

    private AnalysisProcessNameAspect() {
    }

    public static AnalysisProcessNameAspect getInstance() {
        return INSTANCE;
    }

    public @Nullable String resolve(@NonNull ITmfEvent event) {
        Object pidObj = TmfTraceUtils.resolveEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxPidAspect.class, (ITmfEvent)event);
        if (pidObj == null) {
            return null;
        }
        String hostId = event.getTrace().getHostId();
        IHostModel model = ModelManager.getModelFor(hostId);
        Integer pid = (Integer)pidObj;
        ITmfTimestamp timestamp = event.getTimestamp();
        String pname = model.getExecName(pid, timestamp.getValue());
        return pname;
    }
}

