/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.core.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IBaseEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IFieldInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.FieldInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.TraceInfo;

public class BaseEventInfo
extends TraceInfo
implements IBaseEventInfo {
    private TraceEventType fEventType = TraceEventType.UNKNOWN;
    private TraceLogLevel fLogLevel = TraceLogLevel.TRACE_DEBUG;
    private final List<IFieldInfo> fFields = new ArrayList<IFieldInfo>();
    private String fFilterExpression;
    private String fExcludedEvents;

    public BaseEventInfo(String name) {
        super(name);
    }

    public BaseEventInfo(BaseEventInfo other) {
        super(other);
        this.fEventType = other.fEventType;
        this.fLogLevel = other.fLogLevel;
        for (IFieldInfo field : other.fFields) {
            if (field instanceof FieldInfo) {
                this.fFields.add(new FieldInfo((FieldInfo)field));
                continue;
            }
            this.fFields.add(field);
        }
        this.fFilterExpression = other.fFilterExpression;
        this.fExcludedEvents = other.fExcludedEvents;
    }

    @Override
    public TraceEventType getEventType() {
        return this.fEventType;
    }

    @Override
    public void setEventType(TraceEventType type) {
        this.fEventType = type;
    }

    @Override
    public void setEventType(String typeName) {
        this.fEventType = TraceEventType.TRACEPOINT.getInName().equalsIgnoreCase(typeName) ? TraceEventType.TRACEPOINT : (TraceEventType.SYSCALL.getInName().equalsIgnoreCase(typeName) ? TraceEventType.SYSCALL : (TraceEventType.PROBE.getInName().equalsIgnoreCase(typeName) ? TraceEventType.PROBE : (TraceEventType.FUNCTION.getInName().equalsIgnoreCase(typeName) ? TraceEventType.FUNCTION : TraceEventType.UNKNOWN)));
    }

    @Override
    public TraceLogLevel getLogLevel() {
        return this.fLogLevel;
    }

    @Override
    public void setLogLevel(TraceLogLevel level) {
        this.fLogLevel = level;
    }

    @Override
    public void setLogLevel(String levelName) {
        this.fLogLevel = TraceLogLevel.valueOfString(levelName);
    }

    @Override
    public IFieldInfo[] getFields() {
        return this.fFields.toArray(new IFieldInfo[this.fFields.size()]);
    }

    @Override
    public void addField(IFieldInfo field) {
        this.fFields.add(field);
    }

    @Override
    public void setFields(List<IFieldInfo> fields) {
        this.fFields.clear();
        for (IFieldInfo fieldInfo : fields) {
            this.fFields.add(fieldInfo);
        }
    }

    @Override
    public String getFilterExpression() {
        return this.fFilterExpression;
    }

    @Override
    public void setFilterExpression(String filter) {
        this.fFilterExpression = filter;
    }

    @Override
    public String getExcludedEvents() {
        return this.fExcludedEvents;
    }

    @Override
    public void setExcludedEvents(String events) {
        this.fExcludedEvents = events;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.fEventType == null ? 0 : this.fEventType.hashCode());
        result = 31 * result + this.fFields.hashCode();
        result = 31 * result + (this.fFilterExpression == null ? 0 : this.fFilterExpression.hashCode());
        result = 31 * result + (this.fLogLevel == null ? 0 : this.fLogLevel.hashCode());
        result = 31 * result + (this.fExcludedEvents == null ? 0 : this.fExcludedEvents.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseEventInfo other = (BaseEventInfo)obj;
        if (this.fEventType != other.fEventType) {
            return false;
        }
        if (!this.fFields.equals(other.fFields)) {
            return false;
        }
        if (this.fFilterExpression == null ? other.fFilterExpression != null : !this.fFilterExpression.equals(other.fFilterExpression)) {
            return false;
        }
        if (this.fLogLevel != other.fLogLevel) {
            return false;
        }
        return !(this.fExcludedEvents == null ? other.fExcludedEvents != null : !this.fExcludedEvents.equals(other.fExcludedEvents));
    }

    @Override
    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("[BaseEventInfo(");
        output.append(super.toString());
        output.append(",type=");
        output.append((Object)this.fEventType);
        output.append(",level=");
        output.append(this.fLogLevel);
        if (!this.fFields.isEmpty()) {
            output.append(",Fields=");
            for (IFieldInfo field : this.fFields) {
                output.append(field.toString());
            }
        }
        if (this.fFilterExpression != null) {
            output.append(",Filter=");
            output.append(this.fFilterExpression);
        }
        if (this.fExcludedEvents != null) {
            output.append(",Exclusion=");
            output.append(this.fExcludedEvents);
        }
        output.append(")]");
        return output.toString();
    }
}

