/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.protocol.pcap;

import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.packet.Packet;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.ethernet2.EthernetIIPacket;
import org.eclipse.tracecompass.internal.pcap.core.protocol.pcap.PcapEndpoint;
import org.eclipse.tracecompass.internal.pcap.core.protocol.unknown.UnknownPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.internal.pcap.core.util.ConversionHelper;
import org.eclipse.tracecompass.internal.pcap.core.util.PcapTimestampScale;

public abstract class PcapPacket
extends Packet {
    private @Nullable Packet fChildPacket;
    private @Nullable ByteBuffer fPayload;
    private long fTimestamp;
    private long fIncludedLength;
    private long fOriginalLength;
    private long fPacketIndex;
    private @Nullable PcapEndpoint fSourceEndpoint;
    private @Nullable PcapEndpoint fDestinationEndpoint;
    private @Nullable Map<String, String> fFields;

    public PcapPacket(PcapFile file) {
        super(file, null, PcapProtocol.PCAP);
    }

    @Override
    public @Nullable Packet getChildPacket() {
        return this.fChildPacket;
    }

    public void setChildPacket(@Nullable Packet childPacket) {
        this.fChildPacket = childPacket;
    }

    @Override
    public @Nullable ByteBuffer getPayload() {
        if (this.fPayload != null) {
            this.fPayload.position(0);
        }
        return this.fPayload;
    }

    public void setPayload(ByteBuffer payLoad) {
        this.fPayload = payLoad;
    }

    public long getTimestamp() {
        return this.fTimestamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.fTimestamp = timeStamp;
    }

    public long getIncludedLength() {
        return this.fIncludedLength;
    }

    public void setIncludedLength(long includedLength) {
        this.fIncludedLength = includedLength;
    }

    public long getOriginalLength() {
        return this.fOriginalLength;
    }

    public void setOriginalLength(long originalLength) {
        this.fOriginalLength = originalLength;
    }

    public boolean isTruncated() {
        return this.fIncludedLength != this.fOriginalLength;
    }

    public long getIndex() {
        return this.fPacketIndex;
    }

    public void setIndex(long packetIndex) {
        this.fPacketIndex = packetIndex;
    }

    public String toString() {
        String string = String.valueOf(this.getProtocol().getName()) + " " + this.fPacketIndex + ": " + this.fOriginalLength + " bytes on wire, " + this.fIncludedLength + " bytes captured.\nArrival time: " + ConversionHelper.toGMTTime(this.fTimestamp, this.getTimestampScale()) + "\n";
        Packet child = this.fChildPacket;
        if (child != null) {
            return String.valueOf(string) + child.toString();
        }
        return string;
    }

    @Override
    protected @Nullable Packet findChildPacket() throws BadPacketException {
        @Nullable ByteBuffer payload = this.fPayload;
        if (payload == null) {
            return null;
        }
        switch ((int)this.getDataLinkType()) {
            case 1: {
                return new EthernetIIPacket(this.getPcapFile(), (Packet)this, payload);
            }
        }
        return new UnknownPacket(this.getPcapFile(), (Packet)this, payload);
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public PcapEndpoint getSourceEndpoint() {
        PcapEndpoint endpoint = this.fSourceEndpoint;
        if (endpoint == null) {
            endpoint = new PcapEndpoint(this, true);
        }
        this.fSourceEndpoint = endpoint;
        return this.fSourceEndpoint;
    }

    @Override
    public PcapEndpoint getDestinationEndpoint() {
        PcapEndpoint endpoint = this.fDestinationEndpoint;
        if (endpoint == null) {
            endpoint = new PcapEndpoint(this, false);
        }
        this.fDestinationEndpoint = endpoint;
        return this.fDestinationEndpoint;
    }

    @Override
    public Map<String, String> getFields() {
        Map<String, String> map = this.fFields;
        if (map == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"Frame", (Object)String.valueOf(this.fPacketIndex));
            builder.put((Object)"Frame Length", (Object)(String.valueOf(String.valueOf(this.fOriginalLength)) + " bytes"));
            builder.put((Object)"Capture Length", (Object)(String.valueOf(String.valueOf(this.fIncludedLength)) + " bytes"));
            builder.put((Object)"Capture Time", (Object)ConversionHelper.toGMTTime(this.fTimestamp, this.getTimestampScale()));
            this.fFields = builder.build();
            return this.fFields;
        }
        return map;
    }

    @Override
    public String getLocalSummaryString() {
        return "Frame " + this.fPacketIndex + ": " + this.fOriginalLength + " bytes on wire, " + this.fIncludedLength + " bytes captured";
    }

    @Override
    protected String getSignificationString() {
        return "New Frame: " + this.fOriginalLength + " bytes on wire";
    }

    @Override
    public int hashCode() {
        int result = 1;
        Packet child = this.fChildPacket;
        result = child == null ? (result *= 31) : 31 * result + child.hashCode();
        result = 31 * result + (int)(this.fIncludedLength ^ this.fIncludedLength >>> 32);
        result = 31 * result + (int)(this.fOriginalLength ^ this.fOriginalLength >>> 32);
        result = 31 * result + (int)(this.fPacketIndex ^ this.fPacketIndex >>> 32);
        if (child == null) {
            result = 31 * result + PcapPacket.payloadHashCode(this.fPayload);
        }
        result = 31 * result + (int)(this.fTimestamp ^ this.fTimestamp >>> 32);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PcapPacket other = (PcapPacket)obj;
        if (!Objects.equals(this.fChildPacket, other.fChildPacket)) {
            return false;
        }
        if (this.fIncludedLength != other.fIncludedLength) {
            return false;
        }
        if (this.fOriginalLength != other.fOriginalLength) {
            return false;
        }
        if (this.fPacketIndex != other.fPacketIndex) {
            return false;
        }
        if (this.fChildPacket == null && !PcapPacket.payloadEquals(this.fPayload, other.fPayload)) {
            return false;
        }
        return this.fTimestamp == other.fTimestamp;
    }

    public PcapTimestampScale getTimestampScale() {
        return this.getPcapFile().getTimestampPrecision();
    }

    public abstract long getDataLinkType();
}

