/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.dialect.description;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.dialect.description.AbstractInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.dialect.description.DefaultInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tree.TreePackage;
import org.eclipse.sirius.tree.business.internal.dialect.description.TreeInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.tree.description.DescriptionPackage;
import org.eclipse.sirius.tree.description.TreeItemContainerDropTool;
import org.eclipse.sirius.tree.description.TreeItemEditionTool;
import org.eclipse.sirius.viewpoint.description.tool.EditMaskVariables;

public class TreeInterpretedExpressionQuery
extends AbstractInterpretedExpressionQuery {
    private static final String TREE_D_TREE_ELEMENT = "tree.DTreeElement";

    public TreeInterpretedExpressionQuery(EObject target, EStructuralFeature feature) {
        super(target, feature);
    }

    protected void initializeTargetSwitch() {
        this.targetSwitch = new TreeGlobalInterpretedTargetSwitch();
    }

    public Collection<EPackage> getPackagesToImport() {
        Collection superResult = super.getPackagesToImport();
        superResult.add(TreePackage.eINSTANCE);
        superResult.add(DescriptionPackage.eINSTANCE);
        return superResult;
    }

    public Map<String, VariableType> getAvailableVariables() {
        Map availableVariables = super.getAvailableVariables();
        if (this.target instanceof TreeItemContainerDropTool) {
            availableVariables.put("element", VariableType.fromString((String)TREE_D_TREE_ELEMENT));
        }
        return availableVariables;
    }

    protected void appendAllLocalVariableDefinitions(Map<String, Collection<VariableType>> definitions, EObject context) {
        super.appendAllLocalVariableDefinitions(definitions, context);
        if (context instanceof TreeItemEditionTool && ((TreeItemEditionTool)context).getMask() != null) {
            EditMaskVariables emv = ((TreeItemEditionTool)context).getMask();
            this.appendEditMaskVariables(emv, definitions);
        }
    }

    private class TreeGlobalInterpretedTargetSwitch
    implements IInterpretedExpressionTargetSwitch {
        private final DefaultInterpretedExpressionTargetSwitch defaultSwitch;
        private final TreeInterpretedExpressionTargetSwitch specificTreeSwitch;

        private TreeGlobalInterpretedTargetSwitch() {
            this.defaultSwitch = new DefaultInterpretedExpressionTargetSwitch(TreeInterpretedExpressionQuery.this.feature, (IInterpretedExpressionTargetSwitch)this);
            this.specificTreeSwitch = new TreeInterpretedExpressionTargetSwitch(TreeInterpretedExpressionQuery.this.feature, this);
        }

        public Option<Collection<String>> doSwitch(EObject target, boolean considerFeature) {
            LinkedHashSet targetTypes = Sets.newLinkedHashSet();
            Option expressionTarget = Options.newSome((Object)targetTypes);
            if (target != null) {
                String packageURI = target.eClass().getEPackage().getNsURI();
                if (DescriptionPackage.eINSTANCE.getNsURI().equals(packageURI)) {
                    this.specificTreeSwitch.setConsiderFeature(considerFeature);
                    expressionTarget = this.specificTreeSwitch.doSwitch(target);
                }
                if (expressionTarget.some() && ((Collection)expressionTarget.get()).isEmpty()) {
                    expressionTarget = this.defaultSwitch.doSwitch(target, considerFeature);
                }
            }
            return expressionTarget;
        }

        public EObject getFirstRelevantContainer(EObject obj) {
            return this.defaultSwitch != null ? this.defaultSwitch.getFirstRelevantContainer(obj) : null;
        }
    }
}

