/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.trace.util;

import java.util.List;
import org.polarsys.time4sys.marte.nfp.Duration;
import org.polarsys.time4sys.marte.nfp.impl.DurationImpl;
import org.polarsys.time4sys.marte.nfp.impl.LongDurationImpl;
import org.polarsys.time4sys.trace.Event;
import org.polarsys.time4sys.trace.SchedulingEvent;
import org.polarsys.time4sys.trace.Slice;

public class SliceDurationStatistics {
    private SliceDurationStatistics() {
    }

    public static Duration computeExecutionTimeDuration(Slice root) {
        DurationImpl accumulator = LongDurationImpl.ZERO;
        accumulator = SliceDurationStatistics.computeExecutionTimeDuration(root.getEvents());
        for (Slice sub : root.getSubSlices()) {
            accumulator = accumulator.add(SliceDurationStatistics.computeExecutionTimeDuration(sub));
        }
        for (Slice sub : root.getOwnedSubSlices()) {
            accumulator = accumulator.add(SliceDurationStatistics.computeExecutionTimeDuration(sub));
        }
        return accumulator;
    }

    public static Duration computeExecutionTimeDuration(List<Event> events) {
        DurationImpl accumulator = LongDurationImpl.ZERO;
        Duration start = null;
        for (Event evt : events) {
            if (!(evt instanceof SchedulingEvent)) continue;
            SchedulingEvent schedEvt = (SchedulingEvent)evt;
            switch (schedEvt.getKind()) {
                case ACTIVATED: 
                case RUNNING: {
                    start = schedEvt.getTimestamp();
                    break;
                }
                case SUSPENDED: 
                case BLOCKED: 
                case TERMINATED: {
                    Duration end = schedEvt.getTimestamp();
                    if (start != null) {
                        assert (start.compareTo(end) <= 0);
                        accumulator = accumulator.add(end.sub(start));
                    }
                    start = null;
                }
            }
        }
        return accumulator;
    }
}

