/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.trace.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EModelElementImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.polarsys.time4sys.marte.nfp.Duration;
import org.polarsys.time4sys.marte.nfp.NfpFactory;
import org.polarsys.time4sys.trace.Event;
import org.polarsys.time4sys.trace.Properties;
import org.polarsys.time4sys.trace.Slice;
import org.polarsys.time4sys.trace.SliceKind;
import org.polarsys.time4sys.trace.TracePackage;
import org.polarsys.time4sys.trace.util.EventTimestampComparator;

public class SliceImpl
extends EModelElementImpl
implements Slice {
    protected EList<Event> events;
    protected EList<Slice> ownedSubSlices;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final SliceKind KIND_EDEFAULT = SliceKind.OTHER;
    protected SliceKind kind = KIND_EDEFAULT;
    protected Properties properties;
    protected EList<Slice> subSlices;
    protected static final String KIND_LABEL_EDEFAULT = null;
    protected String kindLabel = KIND_LABEL_EDEFAULT;

    protected SliceImpl() {
    }

    protected EClass eStaticClass() {
        return TracePackage.Literals.SLICE;
    }

    @Override
    public EList<Event> getEvents() {
        if (this.events == null) {
            this.events = new EObjectResolvingEList(Event.class, (InternalEObject)this, 1);
        }
        return this.events;
    }

    @Override
    public EList<Slice> getOwnedSubSlices() {
        if (this.ownedSubSlices == null) {
            this.ownedSubSlices = new EObjectContainmentWithInverseEList(Slice.class, (InternalEObject)this, 2, 3);
        }
        return this.ownedSubSlices;
    }

    @Override
    public Slice getParent() {
        if (this.eContainerFeatureID() != 3) {
            return null;
        }
        return (Slice)this.eInternalContainer();
    }

    public NotificationChain basicSetParent(Slice newParent, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newParent, 3, msgs);
        return msgs;
    }

    @Override
    public void setParent(Slice newParent) {
        if (newParent != this.eInternalContainer() || this.eContainerFeatureID() != 3 && newParent != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newParent)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newParent != null) {
                msgs = ((InternalEObject)newParent).eInverseAdd((InternalEObject)this, 2, Slice.class, msgs);
            }
            if ((msgs = this.basicSetParent(newParent, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newParent, (Object)newParent));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public SliceKind getKind() {
        return this.kind;
    }

    @Override
    public void setKind(SliceKind newKind) {
        SliceKind oldKind = this.kind;
        SliceKind sliceKind = this.kind = newKind == null ? KIND_EDEFAULT : newKind;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldKind, (Object)this.kind));
        }
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public NotificationChain basicSetProperties(Properties newProperties, NotificationChain msgs) {
        Properties oldProperties = this.properties;
        this.properties = newProperties;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldProperties, (Object)newProperties);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setProperties(Properties newProperties) {
        if (newProperties != this.properties) {
            NotificationChain msgs = null;
            if (this.properties != null) {
                msgs = ((InternalEObject)this.properties).eInverseRemove((InternalEObject)this, -7, null, msgs);
            }
            if (newProperties != null) {
                msgs = ((InternalEObject)newProperties).eInverseAdd((InternalEObject)this, -7, null, msgs);
            }
            if ((msgs = this.basicSetProperties(newProperties, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)newProperties, (Object)newProperties));
        }
    }

    @Override
    public EList<Slice> getSubSlices() {
        if (this.subSlices == null) {
            this.subSlices = new EObjectResolvingEList(Slice.class, (InternalEObject)this, 7);
        }
        return this.subSlices;
    }

    @Override
    public String getKindLabel() {
        if (SliceKind.OTHER.equals((Object)this.kind)) {
            return this.kindLabel;
        }
        return this.kind.toString();
    }

    @Override
    public void setKindLabel(String newKindLabel) {
        String oldKindLabel = this.kindLabel;
        SliceKind newKind = SliceKind.OTHER;
        if (newKindLabel != null) {
            String newUpperKindLabel = newKindLabel.toUpperCase();
            SliceKind[] sliceKindArray = SliceKind.values();
            int n = sliceKindArray.length;
            int n2 = 0;
            while (n2 < n) {
                SliceKind k = sliceKindArray[n2];
                if (newUpperKindLabel.equals(k.toString())) {
                    newKind = k;
                    newKindLabel = null;
                }
                ++n2;
            }
        }
        this.kindLabel = newKindLabel;
        this.setKind(newKind);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldKindLabel, (Object)this.kindLabel));
        }
    }

    @Override
    public String getHierarchicalName(String separator) {
        assert (separator != null);
        if (this.eIsSet((EStructuralFeature)TracePackage.eINSTANCE.getSlice_Parent())) {
            return String.valueOf(this.getParent().getHierarchicalName(separator)) + separator + this.getName();
        }
        return this.getName();
    }

    @Override
    public EList<Event> getAggregatedEvents() {
        LinkedHashSet<Event> events = new LinkedHashSet<Event>();
        events.addAll((Collection<Event>)this.getEvents());
        if (this.subSlices != null) {
            for (Slice sub : this.subSlices) {
                events.addAll((Collection<Event>)sub.getAggregatedEvents());
            }
        }
        if (this.ownedSubSlices != null) {
            for (Slice sub : this.ownedSubSlices) {
                events.addAll((Collection<Event>)sub.getAggregatedEvents());
            }
        }
        LinkedList evts = new LinkedList(events);
        Collections.sort(evts, EventTimestampComparator.INSTANCE);
        return new EcoreEList.UnmodifiableEList((InternalEObject)this, (EStructuralFeature)TracePackage.Literals.SLICE__EVENTS, events.size(), evts.toArray());
    }

    @Override
    public Duration getLatestTimestamp() {
        Duration max = NfpFactory.eINSTANCE.createDurationFromString("0ps");
        for (Event evt : this.getAggregatedEvents()) {
            max = max.max(evt.getTimestamp());
        }
        return max;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getOwnedSubSlices()).basicAdd((Object)otherEnd, msgs);
            }
            case 3: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetParent((Slice)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getOwnedSubSlices()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return this.basicSetParent(null, msgs);
            }
            case 6: {
                return this.basicSetProperties(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 3: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 2, Slice.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getEvents();
            }
            case 2: {
                return this.getOwnedSubSlices();
            }
            case 3: {
                return this.getParent();
            }
            case 4: {
                return this.getName();
            }
            case 5: {
                return this.getKind();
            }
            case 6: {
                return this.getProperties();
            }
            case 7: {
                return this.getSubSlices();
            }
            case 8: {
                return this.getKindLabel();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getEvents().clear();
                this.getEvents().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getOwnedSubSlices().clear();
                this.getOwnedSubSlices().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setParent((Slice)newValue);
                return;
            }
            case 4: {
                this.setName((String)newValue);
                return;
            }
            case 5: {
                this.setKind((SliceKind)((Object)newValue));
                return;
            }
            case 6: {
                this.setProperties((Properties)newValue);
                return;
            }
            case 7: {
                this.getSubSlices().clear();
                this.getSubSlices().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.setKindLabel((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getEvents().clear();
                return;
            }
            case 2: {
                this.getOwnedSubSlices().clear();
                return;
            }
            case 3: {
                this.setParent(null);
                return;
            }
            case 4: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 5: {
                this.setKind(KIND_EDEFAULT);
                return;
            }
            case 6: {
                this.setProperties(null);
                return;
            }
            case 7: {
                this.getSubSlices().clear();
                return;
            }
            case 8: {
                this.setKindLabel(KIND_LABEL_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.events != null && !this.events.isEmpty();
            }
            case 2: {
                return this.ownedSubSlices != null && !this.ownedSubSlices.isEmpty();
            }
            case 3: {
                return this.getParent() != null;
            }
            case 4: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 5: {
                return this.kind != KIND_EDEFAULT;
            }
            case 6: {
                return this.properties != null;
            }
            case 7: {
                return this.subSlices != null && !this.subSlices.isEmpty();
            }
            case 8: {
                return KIND_LABEL_EDEFAULT == null ? this.kindLabel != null : !KIND_LABEL_EDEFAULT.equals(this.kindLabel);
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                return this.getHierarchicalName((String)arguments.get(0));
            }
            case 2: {
                return this.getAggregatedEvents();
            }
            case 3: {
                return this.getLatestTimestamp();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", kind: ");
        result.append((Object)this.kind);
        result.append(", kindLabel: ");
        result.append(this.kindLabel);
        result.append(')');
        return result.toString();
    }

    @Override
    public <T extends Event> List<T> getAggregatedEvents(Class<T> clz) {
        int count = this.getAggregatedEvents().size();
        ArrayList<Event> result = new ArrayList<Event>(count);
        for (Event evt : this.getAggregatedEvents()) {
            if (!clz.isInstance(evt)) continue;
            result.add(evt);
        }
        return result;
    }
}

