/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.mapping.impl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.time4sys.mapping.Context;
import org.polarsys.time4sys.mapping.Link;
import org.polarsys.time4sys.mapping.MappableArtefact;
import org.polarsys.time4sys.mapping.Mapping;
import org.polarsys.time4sys.mapping.MappingFactory;
import org.polarsys.time4sys.mapping.MappingPackage;
import org.polarsys.time4sys.mapping.ResourceArtefact;
import org.polarsys.time4sys.mapping.impl.ContextImpl;
import org.polarsys.time4sys.mapping.impl.LinkImpl;
import org.polarsys.time4sys.mapping.impl.MappableArtefactImpl;
import org.polarsys.time4sys.mapping.impl.MappingImpl;
import org.polarsys.time4sys.mapping.impl.ResourceArtefactImpl;

public class MappingFactoryImpl
extends EFactoryImpl
implements MappingFactory {
    public static MappingFactory init() {
        try {
            MappingFactory theMappingFactory = (MappingFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.polarsys.org/time4sys/mapping/1.0");
            if (theMappingFactory != null) {
                return theMappingFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new MappingFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createLink();
            }
            case 1: {
                return this.createMappableArtefact();
            }
            case 2: {
                return this.createMapping();
            }
            case 3: {
                return this.createContext();
            }
            case 4: {
                return this.createResourceArtefact();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 5: {
                return this.createURIFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 5: {
                return this.convertURIToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Link createLink() {
        LinkImpl link = new LinkImpl();
        return link;
    }

    @Override
    public MappableArtefact createMappableArtefact() {
        MappableArtefactImpl mappableArtefact = new MappableArtefactImpl();
        return mappableArtefact;
    }

    @Override
    public Mapping createMapping() {
        MappingImpl mapping = new MappingImpl();
        return mapping;
    }

    @Override
    public Context createContext() {
        ContextImpl context = new ContextImpl();
        return context;
    }

    @Override
    public Context createContext(String name) {
        Context context = this.createContext();
        context.setName(name);
        return context;
    }

    @Override
    public ResourceArtefact createResourceArtefact() {
        ResourceArtefactImpl resourceArtefact = new ResourceArtefactImpl();
        return resourceArtefact;
    }

    public URI createURIFromString(EDataType eDataType, String initialValue) {
        return URI.createPlatformResourceURI((String)initialValue, (boolean)true);
    }

    public String convertURIToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue instanceof URI) {
            URI emfUri = (URI)instanceValue;
            if (emfUri.isPlatform()) {
                return emfUri.toPlatformString(true);
            }
            return emfUri.toFileString();
        }
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public MappingPackage getMappingPackage() {
        return (MappingPackage)this.getEPackage();
    }

    @Deprecated
    public static MappingPackage getPackage() {
        return MappingPackage.eINSTANCE;
    }

    @Override
    public Link createLink(Context rule, String srcRole, EObject source, String tgtRole, EObject target) {
        Link r = this.createLink();
        r.getSources().add((Object)this.createMappableArtefact(srcRole, source));
        r.getTargets().add((Object)this.createMappableArtefact(tgtRole, target));
        return r;
    }

    @Override
    public MappableArtefact createMappableArtefact(String name, EObject value) {
        MappableArtefact elt = this.createMappableArtefact();
        if (name != null) {
            elt.setName(name);
        }
        elt.setValue(value);
        return elt;
    }

    @Override
    public Mapping createMapping(Resource source, Resource target) {
        Mapping m = this.createMapping();
        ResourceArtefact src = this.createResourceArtefact("source", source);
        m.getSources().add((Object)src);
        ResourceArtefact tgt = this.createResourceArtefact("target", target);
        m.getTargets().add((Object)tgt);
        return m;
    }

    @Override
    public ResourceArtefact createResourceArtefact(String role, Resource value) {
        ResourceArtefact elt = this.createResourceArtefact();
        elt.setName(role);
        if (value != null) {
            elt.setUri(value.getURI());
            elt.setResource(value);
        }
        return elt;
    }
}

