/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.ui;

import java.util.List;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.generator.framework.Generator;
import org.eclipse.swtbot.generator.ui.BotGeneratorEventDispatcher;
import org.eclipse.swtbot.generator.ui.GeneratorExtensionPointManager;
import org.eclipse.swtbot.generator.ui.RecorderDialog;
import org.eclipse.ui.IStartup;

public class StartupRecorder
implements IStartup {
    private static final String ENABLEMENT_PROPERTY = "org.eclipse.swtbot.generator.enable";

    public void earlyStartup() {
        if (!Boolean.parseBoolean(System.getProperty(ENABLEMENT_PROPERTY))) {
            return;
        }
        StartupRecorder.openRecorder();
    }

    public static RecorderDialog openRecorder() {
        Display display = Display.getDefault();
        StartRecorderRunnable recorderStarter = new StartRecorderRunnable(display);
        display.syncExec((Runnable)recorderStarter);
        return recorderStarter.getRecorderDialog();
    }

    private static final class StartRecorderRunnable
    implements Runnable {
        private final Display display;
        private RecorderDialog recorderDialog;

        private StartRecorderRunnable(Display display) {
            this.display = display;
        }

        public void run() {
            List<Generator> availableGenerators = GeneratorExtensionPointManager.loadGenerators();
            Generator generator = availableGenerators.get(0);
            final BotGeneratorEventDispatcher dispatcher = new BotGeneratorEventDispatcher();
            dispatcher.setGenerator(generator);
            this.display.addFilter(26, (Listener)dispatcher);
            this.display.addFilter(21, (Listener)dispatcher);
            this.display.addFilter(13, (Listener)dispatcher);
            this.display.addFilter(17, (Listener)dispatcher);
            this.display.addFilter(24, (Listener)dispatcher);
            this.display.addFilter(3, (Listener)dispatcher);
            this.display.addFilter(8, (Listener)dispatcher);
            Shell recorderShell = new Shell(this.display, 2144);
            recorderShell.setText("SWTBot test recorder");
            dispatcher.ignoreShell(recorderShell);
            this.recorderDialog = new RecorderDialog(recorderShell, dispatcher, availableGenerators);
            this.recorderDialog.open();
            this.recorderDialog.getShell().addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent e) {
                    StartRecorderRunnable.this.display.removeFilter(26, (Listener)dispatcher);
                    StartRecorderRunnable.this.display.removeFilter(21, (Listener)dispatcher);
                    StartRecorderRunnable.this.display.removeFilter(3, (Listener)dispatcher);
                    StartRecorderRunnable.this.display.removeFilter(8, (Listener)dispatcher);
                    StartRecorderRunnable.this.display.removeFilter(4, (Listener)dispatcher);
                    StartRecorderRunnable.this.display.removeFilter(1, (Listener)dispatcher);
                    StartRecorderRunnable.this.display.removeFilter(13, (Listener)dispatcher);
                    StartRecorderRunnable.this.display.removeFilter(17, (Listener)dispatcher);
                    StartRecorderRunnable.this.display.removeFilter(24, (Listener)dispatcher);
                    StartRecorderRunnable.this.display.removeFilter(14, (Listener)dispatcher);
                }
            });
        }

        public RecorderDialog getRecorderDialog() {
            return this.recorderDialog;
        }
    }
}

