/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard.createpatch;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.verifier.AbstractFormattedVerifier;
import org.eclipse.team.svn.ui.wizard.AbstractVerifiedWizardPage;
import org.eclipse.ui.PlatformUI;

public class PatchOptionsPage
extends AbstractVerifiedWizardPage {
    protected boolean recursive;
    protected boolean ignoreDeleted;
    protected boolean processBinary;
    protected boolean processUnversioned;
    protected boolean localMode;
    protected boolean showIgnoreAncestry;
    protected boolean ignoreAncestry;
    protected int rootPoint;
    protected boolean multiSelect;
    protected long diffOutputOptions;
    protected Button rootSelection;
    protected Button rootProject;
    protected Button rootWorkspace;

    public PatchOptionsPage(boolean localMode) {
        this(localMode, false);
    }

    public PatchOptionsPage(boolean localMode, boolean showIgnoreAncestry) {
        super(PatchOptionsPage.class.getName(), SVNUIMessages.PatchOptionsPage_Title, SVNTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.gif"));
        this.setDescription(SVNUIMessages.PatchOptionsPage_Description);
        this.localMode = localMode;
        this.showIgnoreAncestry = showIgnoreAncestry;
        this.ignoreAncestry = true;
    }

    public void setMultiSelect(boolean multiSelect) {
        if (this.localMode && this.multiSelect != multiSelect) {
            this.rootWorkspace.setSelection(multiSelect);
            this.rootProject.setSelection(!multiSelect);
            this.rootProject.setEnabled(!multiSelect);
            this.rootSelection.setSelection(false);
            this.rootSelection.setEnabled(!multiSelect);
        }
        this.rootPoint = multiSelect ? 2 : 1;
        this.multiSelect = multiSelect;
    }

    public int getRootPoint() {
        return this.rootPoint;
    }

    public boolean isIgnoreDeleted() {
        return this.ignoreDeleted;
    }

    public boolean isProcessBinary() {
        return this.processBinary;
    }

    public boolean isProcessUnversioned() {
        return this.processUnversioned;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public boolean isIgnoreAncestry() {
        return this.showIgnoreAncestry ? this.ignoreAncestry : true;
    }

    public long getDiffOutputOptions() {
        return this.diffOutputOptions;
    }

    protected Composite createControlImpl(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginWidth = 4;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Group options = new Group(composite, 0);
        options.setText(SVNUIMessages.PatchOptionsPage_Options);
        layout = new GridLayout();
        options.setLayout((Layout)layout);
        data = new GridData(768);
        options.setLayoutData((Object)data);
        Button recursiveButton = new Button((Composite)options, 32);
        data = new GridData();
        recursiveButton.setLayoutData((Object)data);
        recursiveButton.setText(SVNUIMessages.PatchOptionsPage_Recurse);
        recursiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatchOptionsPage.this.recursive = ((Button)e.widget).getSelection();
            }
        });
        this.recursive = true;
        recursiveButton.setSelection(true);
        Button processBinaryButton = new Button((Composite)options, 32);
        data = new GridData();
        processBinaryButton.setLayoutData((Object)data);
        processBinaryButton.setText(SVNUIMessages.PatchOptionsPage_Binary);
        processBinaryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatchOptionsPage.this.processBinary = ((Button)e.widget).getSelection();
                PatchOptionsPage.this.validateContent();
            }
        });
        this.processBinary = false;
        processBinaryButton.setSelection(false);
        AbstractFormattedVerifier verifier = new AbstractFormattedVerifier(SVNUIMessages.PatchOptionsPage_ProcessBinary_Verifier){

            protected String getErrorMessageImpl(Control input) {
                return null;
            }

            protected String getWarningMessageImpl(Control input) {
                if (((Button)input).getSelection()) {
                    return SVNUIMessages.format((String)SVNUIMessages.PatchOptionsPage_ProcessBinary_Verifier_Warning, (Object[])new String[]{"$FIELD_NAME$"});
                }
                return null;
            }
        };
        this.attachTo((Control)processBinaryButton, verifier);
        Button processDeletedButton = new Button((Composite)options, 32);
        data = new GridData();
        processDeletedButton.setLayoutData((Object)data);
        processDeletedButton.setText(SVNUIMessages.PatchOptionsPage_Deleted);
        processDeletedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatchOptionsPage.this.ignoreDeleted = !((Button)e.widget).getSelection();
            }
        });
        this.ignoreDeleted = false;
        processDeletedButton.setSelection(!false);
        if (this.localMode) {
            Button processUnversionedButton = new Button((Composite)options, 32);
            data = new GridData();
            processUnversionedButton.setLayoutData((Object)data);
            processUnversionedButton.setText(SVNUIMessages.PatchOptionsPage_New);
            processUnversionedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PatchOptionsPage.this.processUnversioned = ((Button)e.widget).getSelection();
                }
            });
            this.processUnversioned = true;
            processUnversionedButton.setSelection(true);
        }
        if (this.showIgnoreAncestry) {
            final Button showIgnoreAncestryButton = new Button((Composite)options, 32);
            data = new GridData();
            showIgnoreAncestryButton.setLayoutData((Object)data);
            showIgnoreAncestryButton.setText(SVNUIMessages.PatchOptionsPage_Ancestry);
            showIgnoreAncestryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PatchOptionsPage.this.ignoreAncestry = showIgnoreAncestryButton.getSelection();
                }
            });
            showIgnoreAncestryButton.setSelection(this.ignoreAncestry);
        }
        if (CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() >= 8) {
            Group outputOptions = new Group(composite, 0);
            outputOptions.setText(SVNUIMessages.PatchOptionsPage_DiffOutputOptions);
            layout = new GridLayout();
            outputOptions.setLayout((Layout)layout);
            data = new GridData(768);
            outputOptions.setLayoutData((Object)data);
            Button ignoreWhitespaceButton = new Button((Composite)outputOptions, 32);
            data = new GridData();
            ignoreWhitespaceButton.setLayoutData((Object)data);
            ignoreWhitespaceButton.setText(SVNUIMessages.PatchOptionsPage_IgnoreWhitespace);
            ignoreWhitespaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PatchOptionsPage.this.diffOutputOptions = ((Button)e.widget).getSelection() ? (PatchOptionsPage.this.diffOutputOptions |= 1L) : (PatchOptionsPage.this.diffOutputOptions &= 0xFFFFFFFFFFFFFFFEL);
                }
            });
            ignoreWhitespaceButton.setSelection((this.diffOutputOptions & 1L) != 0L);
            Button ignoreSpaceChangeButton = new Button((Composite)outputOptions, 32);
            data = new GridData();
            ignoreSpaceChangeButton.setLayoutData((Object)data);
            ignoreSpaceChangeButton.setText(SVNUIMessages.PatchOptionsPage_IgnoreSpaceChange);
            ignoreSpaceChangeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PatchOptionsPage.this.diffOutputOptions = ((Button)e.widget).getSelection() ? (PatchOptionsPage.this.diffOutputOptions |= 2L) : (PatchOptionsPage.this.diffOutputOptions &= 0xFFFFFFFFFFFFFFFDL);
                }
            });
            ignoreSpaceChangeButton.setSelection((this.diffOutputOptions & 2L) != 0L);
            Button ignoreEOLStyleButton = new Button((Composite)outputOptions, 32);
            data = new GridData();
            ignoreEOLStyleButton.setLayoutData((Object)data);
            ignoreEOLStyleButton.setText(SVNUIMessages.PatchOptionsPage_IgnoreEOLStyle);
            ignoreEOLStyleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PatchOptionsPage.this.diffOutputOptions = ((Button)e.widget).getSelection() ? (PatchOptionsPage.this.diffOutputOptions |= 4L) : (PatchOptionsPage.this.diffOutputOptions &= 0xFFFFFFFFFFFFFFFBL);
                }
            });
            ignoreEOLStyleButton.setSelection((this.diffOutputOptions & 4L) != 0L);
            Button showCFunctionButton = new Button((Composite)outputOptions, 32);
            data = new GridData();
            showCFunctionButton.setLayoutData((Object)data);
            showCFunctionButton.setText(SVNUIMessages.PatchOptionsPage_ShowCFunction);
            showCFunctionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PatchOptionsPage.this.diffOutputOptions = ((Button)e.widget).getSelection() ? (PatchOptionsPage.this.diffOutputOptions |= 8L) : (PatchOptionsPage.this.diffOutputOptions &= 0xFFFFFFFFFFFFFFF7L);
                }
            });
            showCFunctionButton.setSelection((this.diffOutputOptions & 8L) != 0L);
            Button useGITFormatButton = new Button((Composite)outputOptions, 32);
            data = new GridData();
            useGITFormatButton.setLayoutData((Object)data);
            useGITFormatButton.setText(SVNUIMessages.PatchOptionsPage_GITFormat);
            useGITFormatButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PatchOptionsPage.this.diffOutputOptions = ((Button)e.widget).getSelection() ? (PatchOptionsPage.this.diffOutputOptions |= 0x10L) : (PatchOptionsPage.this.diffOutputOptions &= 0xFFFFFFFFFFFFFFEFL);
                }
            });
            useGITFormatButton.setSelection((this.diffOutputOptions & 0x10L) != 0L);
        }
        if (this.localMode) {
            Group patchRoot = new Group(composite, 0);
            patchRoot.setText(SVNUIMessages.PatchOptionsPage_PatchRoot);
            layout = new GridLayout();
            patchRoot.setLayout((Layout)layout);
            data = new GridData(768);
            patchRoot.setLayoutData((Object)data);
            this.rootWorkspace = new Button((Composite)patchRoot, 16);
            data = new GridData();
            this.rootWorkspace.setLayoutData((Object)data);
            this.rootWorkspace.setText(SVNUIMessages.PatchOptionsPage_PatchRootWorkspace);
            this.rootWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PatchOptionsPage.this.rootPoint = 2;
                }
            });
            this.rootProject = new Button((Composite)patchRoot, 16);
            data = new GridData();
            this.rootProject.setLayoutData((Object)data);
            this.rootProject.setText(SVNUIMessages.PatchOptionsPage_PatchRootProject);
            this.rootProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PatchOptionsPage.this.rootPoint = 1;
                }
            });
            this.rootSelection = new Button((Composite)patchRoot, 16);
            data = new GridData();
            this.rootSelection.setLayoutData((Object)data);
            this.rootSelection.setText(SVNUIMessages.PatchOptionsPage_PatchRootSelection);
            this.rootSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PatchOptionsPage.this.rootPoint = 0;
                }
            });
            this.rootWorkspace.setSelection(this.multiSelect);
            this.rootProject.setSelection(!this.multiSelect);
            this.rootProject.setEnabled(!this.multiSelect);
            this.rootSelection.setSelection(false);
            this.rootSelection.setEnabled(!this.multiSelect);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.svn.help.patchOptionsContext");
        return composite;
    }
}

