/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.utility;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.utility.InputHistory;

public class UserInputHistory
extends InputHistory {
    protected static final String HISTORY_NAME_BASE = "history.";
    protected static final String ENCODING = "UTF-8";
    protected int depth;
    protected List history;

    public UserInputHistory(String name) {
        this(name, SVNTeamPreferences.getCommentTemplatesInt(SVNTeamUIPlugin.instance().getPreferenceStore(), "savedPathsCount"));
    }

    public UserInputHistory(String name, int depth) {
        super(name, 5, null);
        this.depth = depth;
        this.loadHistoryLines();
        if (this.history.size() > this.depth) {
            ListIterator iter = this.history.listIterator(this.depth);
            while (iter.hasNext()) {
                iter.next();
                iter.remove();
            }
            this.saveHistoryLines();
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public String[] getHistory() {
        return this.history.toArray(new String[this.history.size()]);
    }

    public void addLine(String line) {
        if (line == null || line.trim().length() == 0) {
            return;
        }
        this.history.remove(line);
        this.history.add(0, line);
        if (this.history.size() > this.depth) {
            this.history.remove(this.history.size() - 1);
        }
        this.saveHistoryLines();
    }

    public void clear() {
        this.history.clear();
        super.clear();
    }

    protected void loadHistoryLines() {
        this.history = new ArrayList();
        String historyData = (String)this.value;
        if (historyData != null && historyData.length() > 0) {
            String[] historyArray = historyData.split(";");
            int i = 0;
            while (i < historyArray.length) {
                try {
                    historyArray[i] = new String(Base64.decode((byte[])historyArray[i].getBytes(ENCODING)), ENCODING);
                }
                catch (UnsupportedEncodingException e) {
                    historyArray[i] = new String(Base64.decode((byte[])historyArray[i].getBytes()));
                }
                ++i;
            }
            this.history.addAll(Arrays.asList(historyArray));
        }
    }

    protected void saveHistoryLines() {
        String result = "";
        for (String str : this.history) {
            try {
                str = new String(Base64.encode((byte[])str.getBytes(ENCODING)), ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                str = new String(Base64.encode((byte[])str.getBytes()));
            }
            result = String.valueOf(result) + (result.length() == 0 ? str : ";" + str);
        }
        this.setValue(result);
    }
}

