/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.utility;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;

public abstract class ColumnedViewerComparator
extends ViewerComparator
implements SelectionListener {
    protected int column;
    protected boolean reversed;
    protected Viewer basedOn;
    protected IPropertyChangeListener configurationListener;
    public static boolean CASE_INSENSITIVE = true;

    public ColumnedViewerComparator(Viewer basedOn) {
        this.basedOn = basedOn;
        this.reversed = false;
        this.column = 0;
        final IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        CASE_INSENSITIVE = SVNTeamPreferences.getBehaviourBoolean(store, "sorting.case.insensitive");
        this.configurationListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals(SVNTeamPreferences.fullBehaviourName("sorting.case.insensitive"))) {
                    CASE_INSENSITIVE = SVNTeamPreferences.getBehaviourBoolean(store, "sorting.case.insensitive");
                    if (!ColumnedViewerComparator.this.basedOn.getControl().isDisposed()) {
                        ColumnedViewerComparator.this.basedOn.refresh();
                    } else {
                        store.removePropertyChangeListener((IPropertyChangeListener)this);
                    }
                }
            }
        };
        store.addPropertyChangeListener(this.configurationListener);
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public void setColumnNumber(int column) {
        this.column = column;
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.basedOn instanceof TreeViewer) {
            TreeViewer treeViewer = (TreeViewer)this.basedOn;
            int column = treeViewer.getTree().indexOf((TreeColumn)e.widget);
            ColumnedViewerComparator oldSorter = (ColumnedViewerComparator)treeViewer.getComparator();
            TreeColumn treeColumn = (TreeColumn)e.widget;
            if (oldSorter == null) {
                return;
            }
            if (column == oldSorter.getColumnNumber()) {
                oldSorter.setReversed(!oldSorter.isReversed());
                treeViewer.getTree().setSortColumn(treeColumn);
                treeViewer.getTree().setSortDirection(oldSorter.isReversed() ? 1024 : 128);
                treeViewer.refresh();
            } else {
                oldSorter.setColumnNumber(column);
                oldSorter.setReversed(false);
                treeViewer.getTree().setSortColumn(treeColumn);
                treeViewer.getTree().setSortDirection(128);
                treeViewer.refresh();
            }
        } else if (this.basedOn instanceof TableViewer) {
            TableViewer tableViewer = (TableViewer)this.basedOn;
            int column = tableViewer.getTable().indexOf((TableColumn)e.widget);
            ColumnedViewerComparator oldSorter = (ColumnedViewerComparator)tableViewer.getComparator();
            TableColumn tableColumn = (TableColumn)e.widget;
            if (oldSorter == null) {
                return;
            }
            if (column == oldSorter.getColumnNumber()) {
                oldSorter.setReversed(!oldSorter.isReversed());
                tableViewer.getTable().setSortColumn(tableColumn);
                tableViewer.getTable().setSortDirection(oldSorter.isReversed() ? 1024 : 128);
                tableViewer.refresh();
            } else {
                oldSorter.setColumnNumber(column);
                oldSorter.setReversed(false);
                tableViewer.getTable().setSortColumn(tableColumn);
                tableViewer.getTable().setSortDirection(128);
                tableViewer.refresh();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public final int compare(Viewer viewer, Object row1, Object row2) {
        return this.compareImpl(viewer, this.reversed ? row2 : row1, this.reversed ? row1 : row2);
    }

    public abstract int compareImpl(Viewer var1, Object var2, Object var3);

    public static int compare(String first, String second) {
        first = first == null ? "" : first;
        second = second == null ? "" : second;
        return CASE_INSENSITIVE ? first.compareToIgnoreCase(second) : first.compareTo(second);
    }
}

