/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.action;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.ExtractToOperationLocal;
import org.eclipse.team.svn.core.operation.local.FiniExtractLogOperation;
import org.eclipse.team.svn.core.operation.local.InitExtractLogOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.synchronize.action.AbstractActionHelper;
import org.eclipse.team.svn.ui.synchronize.action.ISyncStateFilter;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class ExtractOutgoingToActionHelper
extends AbstractActionHelper {
    public ExtractOutgoingToActionHelper(IAction action, ISynchronizePageConfiguration configuration) {
        super(action, configuration);
    }

    public FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{4, 12}){

            public boolean select(SyncInfo info) {
                if (super.select(info)) {
                    AbstractSVNSyncInfo syncInfo = (AbstractSVNSyncInfo)info;
                    ILocalResource local = syncInfo.getLocalResource();
                    return IStateFilter.SF_TREE_CONFLICTING.accept(local) ? syncInfo.getLocal().exists() : true;
                }
                return false;
            }
        };
    }

    public IActionOperation getOperation() {
        DirectoryDialog fileDialog = new DirectoryDialog(this.configuration.getSite().getShell());
        fileDialog.setText(SVNUIMessages.ExtractToAction_Select_Title);
        fileDialog.setMessage(SVNUIMessages.ExtractToAction_Select_Description);
        String path = fileDialog.open();
        if (path == null) {
            return null;
        }
        IResource[] selectedOutgoingResources = this.getSyncInfoSelector().getSelectedResources(new ISyncStateFilter.StateFilterWrapper(IStateFilter.SF_ANY_CHANGE, true));
        HashSet<IResource> outgoingResources = new HashSet<IResource>(Arrays.asList(selectedOutgoingResources));
        IResource[] iResourceArray = selectedOutgoingResources;
        int n = selectedOutgoingResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource current = iResourceArray[n2];
            outgoingResources.add((IResource)current.getProject());
            ++n2;
        }
        InitExtractLogOperation logger = new InitExtractLogOperation(path);
        ExtractToOperationLocal mainOp = new ExtractToOperationLocal(outgoingResources.toArray(new IResource[outgoingResources.size()]), path, true, logger);
        CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
        op.add((IActionOperation)logger);
        op.add((IActionOperation)mainOp);
        op.add((IActionOperation)new FiniExtractLogOperation(logger));
        return op;
    }
}

