/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.remote.GetFileContentOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObtainProjectNameOperation
extends AbstractActionOperation {
    protected IRepositoryResourceProvider resourceProvider;
    protected IRepositoryResource[] resources;
    protected HashMap<String, IRepositoryResource> names2Resources;

    public ObtainProjectNameOperation(IRepositoryResource[] resources) {
        super("Operation_ObtainProjectName", SVNUIMessages.class);
        this.resources = resources;
        this.names2Resources = new HashMap();
    }

    public ObtainProjectNameOperation(IRepositoryResourceProvider resourceProvider) {
        this((IRepositoryResource[])null);
        this.resourceProvider = resourceProvider;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        final boolean doObtainFromDotProject = SVNTeamPreferences.getCheckoutBoolean(store, "useDotProject");
        final HashSet lowerCaseNames = new HashSet();
        final boolean caseInsensitiveOS = FileUtility.isCaseInsensitiveOS();
        if (this.resourceProvider != null) {
            this.resources = this.resourceProvider.getRepositoryResources();
        }
        int i = 0;
        while (i < this.resources.length && !monitor.isCanceled()) {
            ProgressMonitorUtility.setTaskInfo((IProgressMonitor)monitor, (IActionOperation)this, (String)BaseMessages.format((String)this.getOperationResource("Scanning"), (Object[])new Object[]{this.resources[i].getName()}));
            final int j = i++;
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    String name = null;
                    String newName = null;
                    try {
                        name = doObtainFromDotProject ? ObtainProjectNameOperation.this.obtainProjectName(ObtainProjectNameOperation.this.resources[j], monitor) : null;
                    }
                    catch (SVNConnectorException sVNConnectorException) {
                        // empty catch block
                    }
                    if (name == null) {
                        IRepositoryResource resource = ObtainProjectNameOperation.this.resources[j];
                        IRepositoryLocation location = resource.getRepositoryLocation();
                        if (location.isStructureEnabled() && location.getTrunkLocation().equals(resource.getName())) {
                            name = resource.getParent() != null ? resource.getParent().getName() : SVNUtility.createPathForSVNUrl((String)location.getUrl()).lastSegment();
                            name = FileUtility.formatResourceName((String)name);
                        } else {
                            name = resource.getName();
                        }
                    }
                    if (!(ObtainProjectNameOperation.this.names2Resources.containsKey(name) || caseInsensitiveOS && lowerCaseNames.contains(name.toLowerCase()))) {
                        ObtainProjectNameOperation.this.names2Resources.put(name, ObtainProjectNameOperation.this.resources[j]);
                        if (caseInsensitiveOS) {
                            lowerCaseNames.add(name.toLowerCase());
                        }
                    } else {
                        int k = 1;
                        while (true) {
                            if (!(ObtainProjectNameOperation.this.names2Resources.containsKey(newName = String.valueOf(name) + " (" + k + ")") || caseInsensitiveOS && lowerCaseNames.contains(newName.toLowerCase()))) {
                                ObtainProjectNameOperation.this.names2Resources.put(newName, ObtainProjectNameOperation.this.resources[j]);
                                if (!caseInsensitiveOS) break;
                                lowerCaseNames.add(newName.toLowerCase());
                                break;
                            }
                            ++k;
                        }
                    }
                }
            }, monitor, this.resources.length);
        }
    }

    protected String obtainProjectName(IRepositoryResource resource, IProgressMonitor monitor) throws Exception {
        String projFileUrl = String.valueOf(resource.getUrl()) + "/.project";
        IRepositoryFile projFile = resource.getRepositoryLocation().asRepositoryFile(projFileUrl, false);
        if (projFile.exists()) {
            GetFileContentOperation op = new GetFileContentOperation((IRepositoryResource)projFile);
            ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)monitor);
            InputStream is = op.getContent();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                NameReceiver receiver = new NameReceiver();
                XMLReader parser = XMLReaderFactory.createXMLReader();
                parser.setContentHandler(receiver);
                parser.parse(new InputSource(reader));
                String string = receiver.getName();
                return string;
            }
            catch (Exception receiver) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            is = op.getContent();
            try {
                String currentString;
                reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((currentString = reader.readLine()) != null) {
                    int last;
                    int first = currentString.indexOf("<name>");
                    if (first < 0 || (last = currentString.indexOf("</name>")) < 0) continue;
                    String name = currentString.substring(first + "<name>".length(), last);
                    String string = name.length() > 0 ? name : null;
                    return string;
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public HashMap<String, IRepositoryResource> getNames2Resources() {
        return this.names2Resources;
    }

    private static class NameReceiver
    implements ContentHandler {
        private int state = 0;
        private String name = "";
        private int level = 0;

        private NameReceiver() {
        }

        public String getName() {
            return this.name;
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            ++this.level;
            if (localName.equals("name") && this.level == 2) {
                this.state = 1;
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals("name") && this.level == 2) {
                this.state = 0;
            }
            --this.level;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.state == 1) {
                this.name = String.valueOf(this.name) + new String(ch, start, length);
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }
    }
}

