/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.AbstractDynamicComposite;
import org.eclipse.team.svn.ui.composite.IPropertiesPanel;
import org.eclipse.team.svn.ui.utility.UserInputHistory;
import org.eclipse.team.svn.ui.verifier.IValidationManager;

public class ProxyComposite
extends AbstractDynamicComposite
implements IPropertiesPanel {
    protected static final String USER_HISTORY_NAME = "proxyUser";
    protected String username;
    protected String password;
    protected String host;
    protected boolean callback;
    protected Combo usernameText;
    protected Text passwordText;
    protected IValidationManager validationManager;
    protected UserInputHistory userHistory;

    public ProxyComposite(Composite parent, int style, IValidationManager validationManager) {
        this(parent, style, validationManager, false);
    }

    public ProxyComposite(Composite parent, int style, IValidationManager validationManager, boolean callback) {
        super(parent, style);
        this.validationManager = validationManager;
        this.callback = callback;
    }

    public void setProxySettingsDirect(String username, String password) {
        this.usernameText.setText(username);
        this.passwordText.setText(password);
        if (this.callback) {
            if (this.username != null && this.username.trim().length() > 0) {
                this.passwordText.setFocus();
                this.passwordText.selectAll();
            } else {
                this.usernameText.setFocus();
            }
        }
    }

    public void saveChanges() {
        this.userHistory.addLine(this.usernameText.getText());
        this.username = this.usernameText.getText();
        this.password = this.passwordText.getText();
    }

    public void resetChanges() {
        this.usernameText.setText(this.username != null ? this.username : "");
        this.passwordText.setText(this.password != null ? this.password : "");
        if (this.callback) {
            if (this.username != null && this.username.trim().length() > 0) {
                this.passwordText.setFocus();
                this.passwordText.selectAll();
            } else {
                this.usernameText.setFocus();
            }
        }
    }

    public void cancelChanges() {
    }

    public void initialize() {
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.verticalSpacing = 12;
        layout.marginHeight = 7;
        this.setLayout((Layout)layout);
        data = new GridData(1808);
        this.setLayoutData(data);
        Label description = new Label((Composite)this, 64);
        data = new GridData(768);
        description.setLayoutData((Object)data);
        description.setText(SVNUIMessages.format((String)SVNUIMessages.ProxyComposite_Description, (Object[])new String[]{this.host}));
        Group authGroup = new Group((Composite)this, 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        authGroup.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 12;
        authGroup.setLayout((Layout)layout);
        authGroup.setText(SVNUIMessages.ProxyComposite_Authentication);
        Composite inner = new Composite((Composite)authGroup, 4);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        inner.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        inner.setLayoutData((Object)data);
        description = new Label(inner, 0);
        data = new GridData(32);
        description.setLayoutData((Object)data);
        description.setText(SVNUIMessages.ProxyComposite_Username);
        this.userHistory = new UserInputHistory(USER_HISTORY_NAME);
        this.usernameText = new Combo(inner, 4);
        data = new GridData(768);
        data.widthHint = 200;
        this.usernameText.setLayoutData((Object)data);
        this.usernameText.setVisibleItemCount(this.userHistory.getDepth());
        this.usernameText.setItems(this.userHistory.getHistory());
        this.usernameText.setText(this.getUsername());
        description = new Label(inner, 0);
        description.setText(SVNUIMessages.ProxyComposite_Password);
        data = new GridData(32);
        description.setLayoutData((Object)data);
        this.passwordText = new Text(inner, 0x400800);
        data = new GridData(768);
        data.widthHint = 200;
        this.passwordText.setLayoutData((Object)data);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void revalidateContent() {
        this.validationManager.validateContent();
    }

    public void restoreAppearance() {
    }

    public void saveAppearance() {
    }
}

