/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryBase;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.RevisionComposite;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.operation.GetBranchesTagsOperation;
import org.eclipse.team.svn.ui.panel.common.RepositoryTreePanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.svn.ui.utility.UserInputHistory;
import org.eclipse.team.svn.ui.verifier.AbstractVerifier;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.IValidationManager;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.team.svn.ui.verifier.URLVerifier;

public class BranchTagSelectionComposite
extends Composite {
    public static final int BRANCH_OPERATED = 0;
    public static final int TAG_OPERATED = 1;
    protected Combo urlText;
    protected Button browse;
    protected UserInputHistory inputHistory;
    protected RevisionComposite revisionComposite;
    protected RevisionComposite secondRevisionComposite;
    protected IValidationManager validationManager;
    protected IRepositoryResource baseResource;
    protected boolean considerStructure;
    protected int type;
    protected String url;
    protected CompositeVerifier verifier;
    protected String selectionTitle;
    protected String selectionDescription;
    protected IRepositoryRoot root;
    protected IRepositoryResource[] branchTagResources;

    public BranchTagSelectionComposite(Composite parent, int style, IRepositoryResource baseResource, String historyKey, IValidationManager validationManager, int type, IRepositoryResource[] branchTagResources) {
        super(parent, style);
        this.baseResource = baseResource;
        this.inputHistory = new UserInputHistory(historyKey);
        this.validationManager = validationManager;
        this.type = type;
        this.branchTagResources = branchTagResources;
        this.considerStructure = BranchTagSelectionComposite.considerStructure(this.baseResource);
        this.root = BranchTagSelectionComposite.getRepositoryRoot(this.type, this.baseResource);
        this.createControls(parent);
    }

    protected void createControls(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        Label resourceLabel = new Label((Composite)this, 0);
        resourceLabel.setLayoutData((Object)new GridData());
        if (this.type == 0) {
            resourceLabel.setText(SVNUIMessages.Select_Branch_Label);
        } else {
            resourceLabel.setText(SVNUIMessages.Select_Tag_Label);
        }
        Composite select = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = this.considerStructure ? 1 : 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        select.setLayout((Layout)layout);
        data = new GridData(768);
        select.setLayoutData((Object)data);
        final IRepositoryLocation location = this.baseResource.getRepositoryLocation();
        this.urlText = new Combo(select, this.considerStructure ? 8 : 0);
        data = new GridData(768);
        data.widthHint = 200;
        this.urlText.setLayoutData((Object)data);
        if (!this.considerStructure) {
            this.urlText.setVisibleItemCount(this.inputHistory.getDepth() * 2);
            this.urlText.setItems(this.inputHistory.getHistory());
            this.validationManager.attachTo((Control)this.urlText, new NonEmptyFieldVerifier(resourceLabel.getText()));
            this.validationManager.attachTo((Control)this.urlText, new URLVerifier(resourceLabel.getText()));
        } else {
            IRepositoryResource[] iRepositoryResourceArray = this.branchTagResources;
            int n = this.branchTagResources.length;
            int n2 = 0;
            while (n2 < n) {
                IRepositoryResource branchTagResource = iRepositoryResourceArray[n2];
                this.urlText.add(branchTagResource.getName());
                ++n2;
            }
            if (this.branchTagResources.length > 0) {
                this.urlText.select(0);
                this.url = this.urlText.getText();
            }
        }
        Listener urlTextListener = new Listener(){

            public void handleEvent(Event e) {
                BranchTagSelectionComposite.this.url = ((Combo)e.widget).getText();
                BranchTagSelectionComposite.this.revisionComposite.setSelectedResource(BranchTagSelectionComposite.this.getSelectedResource());
            }
        };
        this.urlText.addListener(13, urlTextListener);
        if (!this.considerStructure) {
            this.urlText.addListener(24, urlTextListener);
        } else {
            this.validationManager.attachTo((Control)this.urlText, new AbstractVerifier(){

                protected String getErrorMessage(Control input) {
                    if (BranchTagSelectionComposite.this.branchTagResources.length == 0) {
                        return BranchTagSelectionComposite.this.type == 0 ? SVNUIMessages.BranchTagSelectionComposite_NoBranches : SVNUIMessages.BranchTagSelectionComposite_NoTags;
                    }
                    return null;
                }

                protected String getWarningMessage(Control input) {
                    return null;
                }
            });
        }
        if (!this.considerStructure) {
            this.browse = new Button(select, 8);
            this.browse.setText(SVNUIMessages.Button_Browse);
            data = new GridData();
            data.widthHint = DefaultDialog.computeButtonWidth(this.browse);
            this.browse.setLayoutData((Object)data);
            this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String part = BranchTagSelectionComposite.this.type == 0 ? SVNUIMessages.Select_Branch_Title : SVNUIMessages.Select_Tag_Title;
                    RepositoryTreePanel panel = new RepositoryTreePanel(part, SVNUIMessages.RepositoryBrowsingPanel_Description, SVNUIMessages.RepositoryBrowsingPanel_Message, null, true, (IRepositoryBase)location, false);
                    DefaultDialog browser = new DefaultDialog(BranchTagSelectionComposite.this.getShell(), panel);
                    if (browser.open() == 0) {
                        IRepositoryResource selectedResource = panel.getSelectedResource();
                        boolean samePeg = selectedResource.getPegRevision().equals((Object)BranchTagSelectionComposite.this.baseResource.getPegRevision());
                        BranchTagSelectionComposite.this.urlText.setText(samePeg ? selectedResource.getUrl() : SVNUtility.getEntryReference((IRepositoryResource)selectedResource).toString());
                        BranchTagSelectionComposite.this.revisionComposite.setSelectedResource(selectedResource);
                        BranchTagSelectionComposite.this.validationManager.validateContent();
                    }
                }
            });
        }
        Composite revisions = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        revisions.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        revisions.setLayoutData((Object)data);
        this.revisionComposite = new RevisionComposite(revisions, this.validationManager, true, new String[]{SVNUIMessages.RevisionComposite_Revision, SVNUIMessages.RepositoryResourceSelectionComposite_HeadRevision}, SVNRevision.HEAD, false){

            public void additionalValidation() {
                BranchTagSelectionComposite.this.validationManager.validateContent();
            }
        };
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.revisionComposite.setLayoutData(data);
        this.revisionComposite.setSelectedResource(this.baseResource);
    }

    public void addUrlModifyListener(Listener listener) {
        this.urlText.addListener(13, listener);
        if (!this.considerStructure) {
            this.urlText.addListener(24, listener);
        }
    }

    public void addUrlVerifier(AbstractVerifier verifier) {
        this.validationManager.attachTo((Control)this.urlText, verifier);
    }

    public void saveChanges() {
        if (!this.considerStructure) {
            this.inputHistory.addLine(this.url);
        }
    }

    public void setCurrentRevision(long currentRevision) {
        this.revisionComposite.setCurrentRevision(currentRevision);
    }

    public IRepositoryResource getSelectedResource() {
        if (this.considerStructure && this.branchTagResources.length == 0) {
            return null;
        }
        String url = this.considerStructure ? String.valueOf(this.root.getUrl()) + "/" + this.url : this.url;
        IRepositoryResource resource = this.getDestination(SVNUtility.asEntryReference((String)url), false);
        resource.setSelectedRevision(this.revisionComposite.getSelectedRevision());
        return resource;
    }

    protected IRepositoryResource getDestination(SVNEntryReference ref, boolean allowsNull) {
        if (ref == null) {
            return SVNUtility.copyOf((IRepositoryResource)this.baseResource);
        }
        String url = SVNUtility.normalizeURL((String)ref.path);
        try {
            IRepositoryContainer resource;
            Object object = resource = this.baseResource instanceof IRepositoryContainer ? this.baseResource.asRepositoryContainer(url, false) : this.baseResource.asRepositoryFile(url, false);
            if (ref.pegRevision != null) {
                resource.setPegRevision(ref.pegRevision);
            }
            return resource;
        }
        catch (IllegalArgumentException ex) {
            return allowsNull ? null : SVNUtility.copyOf((IRepositoryResource)this.baseResource);
        }
    }

    public static IRepositoryResource[] calculateBranchTagResources(IRepositoryResource resource, int type) {
        IRepositoryRoot root = BranchTagSelectionComposite.getRepositoryRoot(type, resource);
        GetBranchesTagsOperation op = new GetBranchesTagsOperation((IRepositoryContainer)root, type == 0);
        UIMonitorUtility.doTaskNowDefault((IActionOperation)op, false);
        return op.getChildren();
    }

    protected static IRepositoryRoot getRepositoryRoot(int type, IRepositoryResource resource) {
        IRepositoryRoot root = type == 0 ? SVNUtility.getBranchesLocation((IRepositoryResource)resource) : SVNUtility.getTagsLocation((IRepositoryResource)resource);
        return root;
    }

    public static boolean considerStructure(IRepositoryResource resource) {
        boolean considerStructure = resource.getRepositoryLocation().isStructureEnabled() && SVNTeamPreferences.getRepositoryBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "tagConsideringProjectStructure");
        return considerStructure;
    }

    public static IRepositoryResource getResourceToCompareWith(IRepositoryResource resource, IRepositoryResource brunchTagResource) {
        IRepositoryFile res = null;
        IPath fromPath = SVNUtility.createPathForSVNUrl((String)resource.getUrl());
        IPath brunchPath = SVNUtility.createPathForSVNUrl((String)brunchTagResource.getUrl());
        if (brunchPath.segmentCount() > 2) {
            int matchedSegments = fromPath.matchingFirstSegments(brunchPath);
            if (fromPath.segmentCount() >= matchedSegments + 1) {
                IPath relativePath = fromPath.removeFirstSegments(matchedSegments + 1);
                String[] segments = relativePath.segments();
                String relativeUrl = "";
                int i = 0;
                while (i < segments.length) {
                    relativeUrl = String.valueOf(relativeUrl) + segments[i];
                    if (i < segments.length - 1) {
                        relativeUrl = String.valueOf(relativeUrl) + "/";
                    }
                    ++i;
                }
                String compareUrl = String.valueOf(brunchTagResource.getUrl()) + "/" + relativeUrl;
                res = resource instanceof IRepositoryFile ? brunchTagResource.asRepositoryFile(compareUrl, false) : brunchTagResource.asRepositoryContainer(compareUrl, false);
            }
        }
        return res;
    }
}

