/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.DiffViewerSettings;
import org.eclipse.team.svn.core.operation.local.IExecutable;
import org.eclipse.team.svn.core.operation.local.RunExternalCompareOperation;
import org.eclipse.team.svn.core.operation.remote.GetFileContentOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;

public class RunExternalRepositoryCompareOperation
extends CompositeOperation
implements IExecutable {
    protected ExternalCompareRepositoryOperation externalCompareOperation;

    public RunExternalRepositoryCompareOperation(IRepositoryResourceProvider provider, DiffViewerSettings diffSettings) {
        super("Operation_ExternalRepositoryCompare", SVNMessages.class);
        RunExternalCompareOperation.DetectExternalCompareOperation detectOperation = new RunExternalCompareOperation.DetectExternalCompareOperation(provider, diffSettings);
        this.add(detectOperation);
        this.externalCompareOperation = new ExternalCompareRepositoryOperation(provider, detectOperation);
        this.add(this.externalCompareOperation, new IActionOperation[]{detectOperation});
    }

    public boolean isExecuted() {
        return this.externalCompareOperation.isExecuted();
    }

    public static class ExternalCompareRepositoryOperation
    extends CompositeOperation {
        protected RunExternalCompareOperation.IExternalProgramParametersProvider parametersProvider;
        protected DiffViewerSettings.ExternalProgramParameters externalProgramParams;
        protected boolean isExecuted;

        public ExternalCompareRepositoryOperation(IRepositoryResource left, IRepositoryResource right, RunExternalCompareOperation.IExternalProgramParametersProvider parametersProvider) {
            this(new IRepositoryResourceProvider.DefaultRepositoryResourceProvider(new IRepositoryResource[]{right, left}), parametersProvider);
        }

        public ExternalCompareRepositoryOperation(final IRepositoryResourceProvider resourcesProvider, RunExternalCompareOperation.IExternalProgramParametersProvider parametersProvider) {
            super("Operation_ExternalRepositoryCompare", SVNMessages.class);
            this.parametersProvider = parametersProvider;
            final GetFileContentOperation nextFileGetOp = new GetFileContentOperation(new IRepositoryResourceProvider(){

                public IRepositoryResource[] getRepositoryResources() {
                    return new IRepositoryResource[]{resourcesProvider.getRepositoryResources()[1]};
                }
            });
            this.add(nextFileGetOp);
            final GetFileContentOperation prevFileGetOp = new GetFileContentOperation(new IRepositoryResourceProvider(){

                public IRepositoryResource[] getRepositoryResources() {
                    return new IRepositoryResource[]{resourcesProvider.getRepositoryResources()[0]};
                }
            });
            this.add(prevFileGetOp, new IActionOperation[]{nextFileGetOp});
            this.add(new AbstractActionOperation("Operation_ExternalRepositoryCompare", SVNMessages.class){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    RunExternalCompareOperation.ExternalCompareOperationHelper externalRunHelper = new RunExternalCompareOperation.ExternalCompareOperationHelper(prevFileGetOp.getTemporaryPath(), nextFileGetOp.getTemporaryPath(), null, null, ExternalCompareRepositoryOperation.this.externalProgramParams);
                    externalRunHelper.execute(monitor);
                }
            }, new IActionOperation[]{nextFileGetOp, prevFileGetOp});
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            this.externalProgramParams = this.parametersProvider.getExternalProgramParameters();
            if (this.externalProgramParams != null) {
                this.isExecuted = true;
                super.runImpl(monitor);
            } else {
                this.isExecuted = false;
            }
        }

        public boolean isExecuted() {
            return this.isExecuted;
        }
    }
}

