/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.discovery.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.discovery.model.AbstractDiscoverySource;
import org.eclipse.team.svn.core.discovery.model.AbstractDiscoveryStrategy;
import org.eclipse.team.svn.core.discovery.model.BundleDiscoverySource;
import org.eclipse.team.svn.core.discovery.model.ConnectorDiscoveryExtensionReader;
import org.eclipse.team.svn.core.discovery.model.DiscoveryCategory;
import org.eclipse.team.svn.core.discovery.model.DiscoveryConnector;
import org.eclipse.team.svn.core.discovery.model.ValidationException;
import org.eclipse.team.svn.core.operation.LoggedOperation;

public class BundleDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    public void performDiscovery(IProgressMonitor monitor) throws CoreException {
        if (this.connectors == null || this.categories == null) {
            throw new IllegalStateException();
        }
        IExtensionPoint extensionPoint = this.getExtensionRegistry().getExtensionPoint("org.eclipse.team.svn.core.connectorDiscovery");
        IExtension[] extensions = extensionPoint.getExtensions();
        monitor.beginTask(SVNMessages.BundleDiscoveryStrategy_task_loading_local_extensions, extensions.length == 0 ? 1 : extensions.length);
        try {
            if (extensions.length > 0) {
                this.processExtensions((IProgressMonitor)new SubProgressMonitor(monitor, extensions.length), extensions);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void processExtensions(IProgressMonitor monitor, IExtension[] extensions) {
        monitor.beginTask(SVNMessages.BundleDiscoveryStrategy_task_processing_extensions, extensions.length == 0 ? 1 : extensions.length);
        try {
            ConnectorDiscoveryExtensionReader extensionReader = new ConnectorDiscoveryExtensionReader();
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                AbstractDiscoverySource discoverySource = this.computeDiscoverySource(extension.getContributor());
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    block11: {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        if (monitor.isCanceled()) {
                            return;
                        }
                        try {
                            if ("connectorDescriptor".equals(element.getName())) {
                                DiscoveryConnector descriptor = extensionReader.readConnectorDescriptor(element, DiscoveryConnector.class);
                                descriptor.setSource(discoverySource);
                                this.connectors.add(descriptor);
                                break block11;
                            }
                            if ("connectorCategory".equals(element.getName())) {
                                DiscoveryCategory category = extensionReader.readConnectorCategory(element, DiscoveryCategory.class);
                                category.setSource(discoverySource);
                                this.categories.add(category);
                                break block11;
                            }
                            throw new ValidationException(SVNMessages.format(SVNMessages.BundleDiscoveryStrategy_unexpected_element, element.getName()));
                        }
                        catch (ValidationException e) {
                            LoggedOperation.reportError(this.getClass().getName(), (Throwable)((Object)e));
                        }
                    }
                    ++n4;
                }
                monitor.worked(1);
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected AbstractDiscoverySource computeDiscoverySource(IContributor contributor) {
        BundleDiscoverySource bundleDiscoverySource = new BundleDiscoverySource(Platform.getBundle((String)contributor.getName()));
        return bundleDiscoverySource;
    }

    protected IExtensionRegistry getExtensionRegistry() {
        return Platform.getExtensionRegistry();
    }
}

