/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.util;

import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.GridUtil;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.DiagramToolTip;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.NGC;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.SDWidget;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.SDMessages;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.SDPrintDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SDPrintDialogUI {
    protected Button setHPagesNumber;
    protected Button setVPagesNumber;
    protected Button useCurrentZoom;
    protected Button allPages;
    protected Button currentPage;
    protected Button pageList;
    protected Button pageRange;
    protected Text fromPage;
    protected Text toPage;
    protected SDWidget view;
    protected Text hPagesNum;
    protected Text vPagesNum;
    protected Text totalPages;
    protected ModifyListener modifyListener;
    protected SelectionListener selectionListener;
    protected LocalSD overviewCanvas;
    protected int nbPages = 0;
    protected int pageNum = -1;
    protected int firstPage = -1;
    protected int[] pagesList;
    protected float stepX;
    protected float stepY;
    protected float sTX;
    protected float sTY;
    protected int from;
    protected int to;
    protected boolean multiSelection = false;
    protected boolean areaSelection = false;
    protected boolean printAll;
    protected boolean printCurrent;
    protected boolean printSelection;
    protected boolean printRange;
    protected int nbRows;
    protected int nbLines;
    protected float zoomFactor;
    protected PrinterData printerData;
    protected DiagramToolTip toolTip = null;
    protected Label currentSelection;
    protected Shell shell;
    protected Button printerDialog;
    protected boolean showPrintButton;
    int test = 3;
    protected WizardPage parentWizardPage = null;
    protected SDPrintDialog parentDialog = null;

    public SDPrintDialogUI(Shell s, SDWidget v) {
        this(s, v, false);
    }

    public SDPrintDialogUI(Shell s, SDWidget v, boolean showPrintBtn) {
        this.setShell(s);
        this.view = v;
        this.showPrintButton = showPrintBtn;
        this.printerData = Printer.getDefaultPrinterData();
        if (this.printerData != null) {
            this.printerData.scope = 2;
        }
        this.pagesList = new int[0];
        this.selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SDPrintDialogUI.this.useCurrentZoom.getSelection()) {
                    SDPrintDialogUI.this.hPagesNum.setEnabled(false);
                    SDPrintDialogUI.this.vPagesNum.setEnabled(false);
                }
                if (SDPrintDialogUI.this.setHPagesNumber.getSelection()) {
                    SDPrintDialogUI.this.hPagesNum.setEnabled(true);
                    SDPrintDialogUI.this.vPagesNum.setEnabled(false);
                    if (SDPrintDialogUI.this.currentPage.getSelection()) {
                        SDPrintDialogUI.this.currentPage.setSelection(false);
                        SDPrintDialogUI.this.allPages.setSelection(true);
                    }
                    if (SDPrintDialogUI.this.hPagesNum.getText() == "") {
                        SDPrintDialogUI.this.hPagesNum.setText("1");
                    }
                }
                if (SDPrintDialogUI.this.setVPagesNumber.getSelection()) {
                    SDPrintDialogUI.this.hPagesNum.setEnabled(false);
                    SDPrintDialogUI.this.vPagesNum.setEnabled(true);
                    if (SDPrintDialogUI.this.currentPage.getSelection()) {
                        SDPrintDialogUI.this.currentPage.setSelection(false);
                        SDPrintDialogUI.this.allPages.setSelection(true);
                    }
                    if (SDPrintDialogUI.this.vPagesNum.getText() == "") {
                        SDPrintDialogUI.this.vPagesNum.setText("1");
                    }
                }
                if (SDPrintDialogUI.this.currentPage.getSelection() || SDPrintDialogUI.this.allPages.getSelection() || SDPrintDialogUI.this.pageList.getSelection()) {
                    SDPrintDialogUI.this.fromPage.setEnabled(false);
                    SDPrintDialogUI.this.toPage.setEnabled(false);
                } else {
                    SDPrintDialogUI.this.fromPage.setEnabled(true);
                    SDPrintDialogUI.this.toPage.setEnabled(true);
                }
                SDPrintDialogUI.this.currentPage.setEnabled(SDPrintDialogUI.this.useCurrentZoom.getSelection());
                SDPrintDialogUI.this.overviewCanvas.setEnabled(SDPrintDialogUI.this.pageList.getSelection());
                if (SDPrintDialogUI.this.overviewCanvas.isEnabled() && (e.widget == SDPrintDialogUI.this.useCurrentZoom || e.widget == SDPrintDialogUI.this.setHPagesNumber || e.widget == SDPrintDialogUI.this.setVPagesNumber)) {
                    SDPrintDialogUI.this.pagesList = new int[1];
                    SDPrintDialogUI.this.pagesList[0] = 1;
                    SDPrintDialogUI.this.pageNum = 1;
                    SDPrintDialogUI.this.firstPage = 1;
                } else if (SDPrintDialogUI.this.overviewCanvas.isEnabled() && e.widget == SDPrintDialogUI.this.pageList && (SDPrintDialogUI.this.pagesList == null || SDPrintDialogUI.this.pagesList.length <= 0)) {
                    SDPrintDialogUI.this.pagesList = new int[1];
                    SDPrintDialogUI.this.pagesList[0] = 1;
                    SDPrintDialogUI.this.pageNum = 1;
                    SDPrintDialogUI.this.firstPage = 1;
                }
                SDPrintDialogUI.this.computeStepXY();
                SDPrintDialogUI.this.totalPages.setText(Integer.valueOf(SDPrintDialogUI.this.maxNumOfPages()).toString());
                SDPrintDialogUI.this.overviewCanvas.redraw();
                SDPrintDialogUI.this.overviewCanvas.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SDPrintDialogUI.this.pagesList = new int[0];
                SDPrintDialogUI.this.computeStepXY();
                SDPrintDialogUI.this.overviewCanvas.redraw();
            }
        };
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SDPrintDialogUI.this.pagesList = new int[0];
                SDPrintDialogUI.this.computeStepXY();
                SDPrintDialogUI.this.totalPages.setText(Integer.valueOf(SDPrintDialogUI.this.maxNumOfPages()).toString());
                SDPrintDialogUI.this.overviewCanvas.redraw();
            }
        };
    }

    protected GridData newGridData(int span) {
        GridData data = new GridData(1808);
        data.horizontalSpan = span;
        return data;
    }

    public Control createDialogArea(Composite parent) {
        GridLayout parentLayout = new GridLayout();
        parentLayout.numColumns = 6;
        parent.setLayout((Layout)parentLayout);
        Group g1 = new Group(parent, 32);
        g1.setText(SDMessages._113);
        g1.setLayoutData((Object)this.newGridData(3));
        GridLayout g1layout = new GridLayout();
        g1layout.numColumns = 2;
        g1.setLayout((Layout)g1layout);
        this.useCurrentZoom = new Button((Composite)g1, 16);
        this.useCurrentZoom.setText(SDMessages._112);
        this.useCurrentZoom.setLayoutData((Object)this.newGridData(2));
        this.useCurrentZoom.addSelectionListener(this.selectionListener);
        this.setHPagesNumber = new Button((Composite)g1, 16);
        this.setHPagesNumber.setText(SDMessages._110);
        this.setHPagesNumber.setLayoutData((Object)this.newGridData(1));
        this.setHPagesNumber.addSelectionListener(this.selectionListener);
        this.hPagesNum = new Text((Composite)g1, 2052);
        this.hPagesNum.addModifyListener(this.modifyListener);
        this.setVPagesNumber = new Button((Composite)g1, 16);
        this.setVPagesNumber.setText(SDMessages._111);
        this.setVPagesNumber.setLayoutData((Object)this.newGridData(1));
        this.setVPagesNumber.addSelectionListener(this.selectionListener);
        this.vPagesNum = new Text((Composite)g1, 2052);
        this.vPagesNum.addModifyListener(this.modifyListener);
        Label nbTotal = new Label((Composite)g1, 131104);
        nbTotal.setText(SDMessages._109);
        this.totalPages = new Text((Composite)g1, 2060);
        Group g2 = new Group(parent, 32);
        g2.setText(SDMessages._119);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.verticalSpan = 2;
        g2.setLayoutData((Object)data);
        GridLayout g2layout = new GridLayout();
        g2layout.numColumns = 1;
        g2.setLayout((Layout)g2layout);
        GridData data2 = new GridData(1808);
        data2.horizontalSpan = 1;
        data2.verticalSpan = 1;
        this.overviewCanvas = new LocalSD((Composite)g2, 262144);
        GridData seqDiagLayoutData = new GridData(272);
        this.overviewCanvas.setLayoutData(seqDiagLayoutData);
        this.test = this.view.getContentsWidth() < this.view.getVisibleWidth() && this.view.getContentsHeight() < this.view.getVisibleHeight() ? 3 : 10;
        this.overviewCanvas.setFrame(this.view.getFrame(), true);
        this.overviewCanvas.zoomValue = 1.0f / (float)this.test;
        this.overviewCanvas.setCornerControl(null);
        seqDiagLayoutData.widthHint = this.overviewCanvas.getContentsWidth() / this.test;
        seqDiagLayoutData.widthHint = this.overviewCanvas.getFrame().getWidth() / this.test + 15;
        if (this.view.getVisibleWidth() < this.view.getContentsWidth()) {
            seqDiagLayoutData.widthHint = this.overviewCanvas.getContentsWidth() / this.test;
            if (seqDiagLayoutData.widthHint > Display.getDefault().getClientArea().width / 4) {
                seqDiagLayoutData.widthHint = Display.getDefault().getClientArea().width / 4;
            }
        } else {
            seqDiagLayoutData.widthHint = this.overviewCanvas.getFrame().getWidth() / this.test + 15;
        }
        if (this.view.getVisibleHeight() < this.view.getContentsHeight()) {
            seqDiagLayoutData.heightHint = this.overviewCanvas.getContentsHeight() / this.test;
            if (seqDiagLayoutData.heightHint > Display.getDefault().getClientArea().width / 4) {
                seqDiagLayoutData.heightHint = Display.getDefault().getClientArea().width / 4;
            }
        } else {
            seqDiagLayoutData.heightHint = this.overviewCanvas.getFrame().getHeight() / this.test;
        }
        this.overviewCanvas.setEnabled(false);
        this.currentSelection = new Label((Composite)g2, 16416);
        this.currentSelection.setLayoutData((Object)this.newGridData(1));
        Group g3 = new Group(parent, 32);
        g3.setText(SDMessages._118);
        g3.setLayoutData((Object)this.newGridData(3));
        GridLayout g3layout = new GridLayout();
        g3layout.numColumns = 4;
        g3.setLayout((Layout)g3layout);
        this.allPages = new Button((Composite)g3, 16);
        this.allPages.setText(SDMessages._108);
        this.allPages.setLayoutData((Object)this.newGridData(4));
        this.allPages.addSelectionListener(this.selectionListener);
        this.currentPage = new Button((Composite)g3, 16);
        this.currentPage.setText(SDMessages._107);
        this.currentPage.setLayoutData((Object)this.newGridData(4));
        this.currentPage.setEnabled(true);
        this.currentPage.setSelection(true);
        this.currentPage.addSelectionListener(this.selectionListener);
        this.pageList = new Button((Composite)g3, 16);
        this.pageList.setText(SDMessages._106);
        this.pageList.setLayoutData((Object)this.newGridData(4));
        this.pageList.addSelectionListener(this.selectionListener);
        this.pageRange = new Button((Composite)g3, 16);
        this.pageRange.setText(SDMessages._103);
        this.pageRange.setLayoutData((Object)this.newGridData(1));
        this.pageRange.addSelectionListener(this.selectionListener);
        this.fromPage = new Text((Composite)g3, 2052);
        Label labelTo = new Label((Composite)g3, 0x1000000);
        labelTo.setText(SDMessages._105);
        this.toPage = new Text((Composite)g3, 2052);
        this.toolTip = new DiagramToolTip((Control)this.overviewCanvas);
        this.overviewCanvas.getViewControl().addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                SDPrintDialogUI.this.toolTip.hideToolTip();
            }

            public void mouseExit(MouseEvent e) {
                SDPrintDialogUI.this.toolTip.hideToolTip();
            }

            public void mouseHover(MouseEvent e) {
                int x2;
                int x1 = (int)((float)SDPrintDialogUI.this.overviewCanvas.viewToContentsX(e.x) / SDPrintDialogUI.this.overviewCanvas.zoomValue / SDPrintDialogUI.this.stepX);
                int num = x1 + (x2 = (int)((float)SDPrintDialogUI.this.overviewCanvas.viewToContentsY(e.y) / SDPrintDialogUI.this.overviewCanvas.zoomValue / SDPrintDialogUI.this.stepY)) * SDPrintDialogUI.this.getNbRow() + 1;
                if (num > SDPrintDialogUI.this.maxNumOfPages()) {
                    return;
                }
                if (num > 0) {
                    SDPrintDialogUI.this.toolTip.showToolTip(String.valueOf(num));
                    SDPrintDialogUI.this.displayPageNum();
                } else {
                    SDPrintDialogUI.this.currentSelection.setText("");
                    SDPrintDialogUI.this.toolTip.hideToolTip();
                }
            }
        });
        this.overviewCanvas.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        });
        this.overviewCanvas.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                SDPrintDialogUI.this.overviewCanvas.redraw();
            }

            public void focusLost(FocusEvent e) {
                SDPrintDialogUI.this.overviewCanvas.redraw();
            }
        });
        if (this.showPrintButton) {
            Composite printerDlg = new Composite(parent, 0);
            data = GridUtil.createHorizontalFill();
            data.horizontalSpan = 6;
            parentLayout = new GridLayout();
            parentLayout.numColumns = 2;
            printerDlg.setLayout((Layout)parentLayout);
            printerDlg.setLayoutData((Object)data);
            Label label = new Label(printerDlg, 0);
            label.setLayoutData((Object)GridUtil.createHorizontalFill());
            this.printerDialog = new Button(printerDlg, 8);
            this.printerDialog.setText(SDMessages._115);
            this.printerDialog.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SDPrintDialogUI.this.printButtonSelected();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.updatePrinterStatus();
        return parent;
    }

    public int getPagesForSelection() {
        return this.nbPages;
    }

    public boolean okPressed() {
        block9: {
            block8: {
                block7: {
                    this.printAll = this.allPages.getSelection();
                    this.printCurrent = this.currentPage.getSelection();
                    this.printSelection = this.pageList.getSelection();
                    this.printRange = this.pageRange.getSelection();
                    try {
                        if (!this.printRange) break block7;
                        this.from = Integer.valueOf(this.fromPage.getText());
                        this.to = Integer.valueOf(this.toPage.getText());
                        if (this.from > this.maxNumOfPages() || this.to > this.maxNumOfPages() || this.from <= 0 || this.to <= 0) {
                            MessageDialog.openError((Shell)this.getShell(), (String)SDMessages._98, (String)SDMessages._99);
                            return false;
                        }
                    }
                    catch (Exception exception) {
                        MessageDialog.openError((Shell)this.getShell(), (String)SDMessages._98, (String)SDMessages._99);
                        this.from = 0;
                        this.to = 0;
                        return false;
                    }
                }
                if (!this.setHPagesNumber.getSelection() || this.nbPages > 0) break block8;
                MessageDialog.openError((Shell)this.getShell(), (String)SDMessages._98, (String)SDMessages._101);
                return false;
            }
            if (!this.setVPagesNumber.getSelection() || this.nbPages > 0) break block9;
            MessageDialog.openError((Shell)this.getShell(), (String)SDMessages._98, (String)SDMessages._100);
            return false;
        }
        if (this.printSelection && this.getPageList().length <= 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)SDMessages._98, (String)SDMessages._102);
            return false;
        }
        return true;
    }

    public ImageData drawRegionSelected(Image img, Rectangle r, RGB color) {
        ImageData id = img.getImageData();
        int a = 0;
        while (a < r.width && r.x + a < id.width) {
            int b = 0;
            while (b < r.height && r.y + b < id.height) {
                int index = id.getPixel(r.x + a, r.y + b);
                RGB rgb = id.palette.getRGB(index);
                rgb = SDPrintDialogUI.combine(color, rgb);
                id.setPixel(r.x + a, r.y + b, id.palette.getPixel(rgb));
                ++b;
            }
            ++a;
        }
        return id;
    }

    public static RGB combine(RGB front, RGB back) {
        int _af = 128;
        if (_af == 1) {
            return front;
        }
        if (_af == 0) {
            return back;
        }
        int _ab = 200;
        if (_ab == 0) {
            return front;
        }
        double af = (double)_af / 255.0;
        double rf = front.red;
        double gf = front.green;
        double bf = front.blue;
        double ab = (double)_ab / 255.0;
        double rb = back.red;
        double gb = back.green;
        double bb = back.blue;
        double k = (1.0 - af) * ab;
        int r = (int)(af * rf + k * rb);
        int g = (int)(af * gf + k * gb);
        int b = (int)(af * bf + k * bb);
        return new RGB(r, g, b);
    }

    protected void computeStepXY() {
        float cw = (float)this.overviewCanvas.getContentsWidth() / this.overviewCanvas.zoomValue;
        float ch = (float)this.overviewCanvas.getContentsHeight() / this.overviewCanvas.zoomValue;
        try {
            if (this.printerData == null) {
                this.stepX = 0.0f;
                this.stepY = 0.0f;
                this.nbPages = 0;
                this.zoomFactor = 0.0f;
            } else {
                Printer printer = new Printer(this.printerData);
                if (this.setHPagesNumber.getSelection()) {
                    this.nbPages = Integer.valueOf(this.hPagesNum.getText());
                    float z1 = (float)this.view.getContentsWidth() / cw;
                    float z2 = (float)printer.getClientArea().width / ((float)this.view.getContentsWidth() / (float)this.nbPages);
                    this.stepY = (float)printer.getClientArea().height / z1 / z2;
                    this.stepX = cw / (float)this.nbPages;
                } else if (this.setVPagesNumber.getSelection()) {
                    this.nbPages = Integer.valueOf(this.vPagesNum.getText());
                    float z1 = (float)this.view.getContentsHeight() / ch;
                    float z2 = (float)printer.getClientArea().height / ((float)this.view.getContentsHeight() / (float)this.nbPages);
                    this.stepX = (float)printer.getClientArea().width / z1 / z2;
                    this.stepY = ch / (float)this.nbPages;
                } else {
                    float z1 = (float)this.view.getContentsWidth() / cw;
                    this.stepX = (float)this.view.getVisibleWidth() / z1;
                    this.nbPages = Math.round(cw / this.stepX);
                    if (this.nbPages == 0) {
                        this.nbPages = 1;
                    }
                    int pw = printer.getClientArea().width;
                    int ph = printer.getClientArea().height;
                    float z2 = (float)pw / ((float)this.view.getContentsWidth() / (float)this.nbPages);
                    this.stepY = (float)ph / z1 / z2;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.nbPages = 0;
            this.stepX = this.stepY = (float)0;
            this.zoomFactor = 0.0f;
        }
        this.sTX = this.stepX * ((float)this.view.getContentsWidth() / cw);
        this.sTY = this.stepY * ((float)this.view.getContentsHeight() / ch);
        float rat = 1.0f;
        if (this.view.getVisibleWidth() > this.view.getContentsWidth() && (this.setVPagesNumber.getSelection() || this.setHPagesNumber.getSelection())) {
            rat = (float)this.view.getVisibleWidth() / (float)this.view.getContentsWidth();
        }
        this.zoomFactor = (float)this.overviewCanvas.getContentsWidth() / cw / this.overviewCanvas.getZoomFactor() * rat;
    }

    public int[] getPageList() {
        return Arrays.copyOf(this.pagesList, this.pagesList.length);
    }

    public void addToPagesList(int num) {
        int[] temp = new int[this.pagesList.length + 1];
        System.arraycopy(this.pagesList, 0, temp, 0, this.pagesList.length);
        temp[temp.length - 1] = num;
        this.pagesList = new int[temp.length];
        System.arraycopy(temp, 0, this.pagesList, 0, temp.length);
    }

    public void removeFromPagesList(int num) {
        int pos = Arrays.binarySearch(this.pagesList, num);
        int[] temp = new int[this.pagesList.length - 1];
        System.arraycopy(this.pagesList, 0, temp, 0, pos);
        System.arraycopy(this.pagesList, pos + 1, temp, pos, this.pagesList.length - pos - 1);
        this.pagesList = new int[temp.length];
        System.arraycopy(temp, 0, this.pagesList, 0, temp.length);
    }

    public int maxNumOfPages() {
        int max = this.getNbRow() * this.getNbLines();
        return max;
    }

    public int getNbRow() {
        if (!this.setHPagesNumber.isDisposed()) {
            int cw = (int)((float)this.overviewCanvas.getContentsWidth() / this.overviewCanvas.zoomValue);
            int row = 1;
            if (this.stepX != 0.0f) {
                row = (int)((float)cw / this.stepX);
                if (this.setHPagesNumber.getSelection()) {
                    row = Math.round((float)cw / this.stepX);
                } else if ((float)cw % this.stepX != 0.0f) {
                    ++row;
                }
            }
            this.nbRows = row;
        }
        return this.nbRows;
    }

    public int getNbLines() {
        if (!this.setVPagesNumber.isDisposed()) {
            int ch = (int)((float)this.overviewCanvas.getContentsHeight() / this.overviewCanvas.zoomValue);
            int line = 1;
            if (this.stepY != 0.0f) {
                line = (int)((float)ch / this.stepY);
                if (this.setVPagesNumber.getSelection()) {
                    line = Math.round((float)ch / this.stepY);
                } else if ((float)ch % this.stepY != 0.0f) {
                    ++line;
                }
            }
            this.nbLines = line;
        }
        return this.nbLines;
    }

    public boolean printAll() {
        return this.printAll;
    }

    public boolean printCurrent() {
        return this.printCurrent;
    }

    public boolean printSelection() {
        return this.printSelection;
    }

    public boolean printRange() {
        return this.printRange;
    }

    public float getStepX() {
        return this.sTX;
    }

    public float getStepY() {
        return this.sTY;
    }

    public float getZoomFactor() {
        return this.zoomFactor;
    }

    public PrinterData getPrinterData() {
        return this.printerData;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    protected void displayPageNum() {
        if (this.pageNum > 0) {
            String message = MessageFormat.format(SDMessages._117, this.pageNum);
            this.currentSelection.setText(message);
            this.currentSelection.getParent().layout();
        }
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public void printButtonSelected() {
        PrinterData newPrinterData;
        PrintDialog printer = new PrintDialog(this.getShell());
        if (this.allPages.getSelection()) {
            printer.setScope(0);
        }
        if (this.currentPage.getSelection()) {
            printer.setScope(2);
        }
        if (this.pageList.getSelection()) {
            printer.setScope(2);
        }
        if (this.pageRange.getSelection()) {
            printer.setScope(1);
            this.from = Integer.valueOf(this.fromPage.getText());
            this.to = Integer.valueOf(this.toPage.getText());
            printer.setStartPage(this.from);
            printer.setEndPage(this.to);
        }
        if ((newPrinterData = printer.open()) != null) {
            this.printerData = newPrinterData;
        }
        this.updatePrinterStatus();
        if (printer.getScope() == 0) {
            this.allPages.setSelection(true);
            this.currentPage.setSelection(false);
            this.pageList.setSelection(false);
            this.pageRange.setSelection(false);
            this.hPagesNum.setEnabled(false);
            this.vPagesNum.setEnabled(false);
        }
        if (printer.getScope() == 1) {
            this.allPages.setSelection(false);
            this.currentPage.setSelection(false);
            this.pageList.setSelection(false);
            this.pageRange.setSelection(true);
            this.fromPage.setEnabled(true);
            this.toPage.setEnabled(true);
            this.fromPage.setText(Integer.valueOf(printer.getStartPage()).toString());
            this.toPage.setText(Integer.valueOf(printer.getEndPage()).toString());
        }
        this.computeStepXY();
        this.overviewCanvas.redraw();
    }

    public void setParentWizardPage(WizardPage parent) {
        this.parentWizardPage = parent;
    }

    public void setParentDialog(SDPrintDialog parent) {
        this.parentDialog = parent;
    }

    protected void updatePrinterStatus() {
        if (this.parentWizardPage != null) {
            if (this.printerData == null) {
                this.parentWizardPage.setErrorMessage(SDMessages._135);
                this.parentWizardPage.setPageComplete(false);
            } else {
                this.parentWizardPage.setErrorMessage(null);
                this.parentWizardPage.setPageComplete(true);
            }
        } else if (this.parentDialog != null) {
            if (this.printerData == null) {
                this.parentDialog.setErrorMessage(SDMessages._135);
                this.parentDialog.setPageComplete(false);
            } else {
                this.parentDialog.setErrorMessage(null);
                this.parentDialog.setPageComplete(true);
            }
        }
    }

    protected class LocalSD
    extends SDWidget {
        @Override
        public int getContentsHeight() {
            if (SDPrintDialogUI.this.view.getContentsHeight() > SDPrintDialogUI.this.view.getContentsHeight()) {
                return (int)((float)SDPrintDialogUI.this.view.getVisibleHeight() / (float)SDPrintDialogUI.this.test / SDPrintDialogUI.this.view.zoomValue);
            }
            return super.getContentsHeight();
        }

        @Override
        public int getContentsWidth() {
            if (SDPrintDialogUI.this.view.getVisibleWidth() > SDPrintDialogUI.this.view.getContentsWidth()) {
                return (int)((float)SDPrintDialogUI.this.view.getVisibleWidth() / (float)SDPrintDialogUI.this.test / SDPrintDialogUI.this.view.zoomValue);
            }
            return super.getContentsWidth();
        }

        public LocalSD(Composite c, int s) {
            super(c, s);
        }

        @Override
        protected void contentsMouseHover(MouseEvent event) {
        }

        protected Image createPagesSelectionImages(Image img, int width, float stepX, int height, float stepY) {
            Image over = new Image((Device)super.getShell().getDisplay(), img.getImageData());
            int pageIndex = 0;
            while (pageIndex < SDPrintDialogUI.this.pagesList.length) {
                int pageNum = SDPrintDialogUI.this.pagesList[pageIndex];
                if (SDPrintDialogUI.this.getPagesForSelection() > 0 && pageNum > 0) {
                    int line = pageNum / SDPrintDialogUI.this.getNbRow();
                    int row = pageNum % SDPrintDialogUI.this.getNbRow();
                    if (row != 0) {
                        ++line;
                    } else {
                        row = SDPrintDialogUI.this.getNbRow();
                    }
                    Image toDel = over;
                    over = SDPrintDialogUI.this.overviewCanvas.isFocusControl() ? new Image((Device)super.getShell().getDisplay(), SDPrintDialogUI.this.drawRegionSelected(toDel, new Rectangle(this.contentsToViewX((int)((float)row * stepX * SDPrintDialogUI.this.overviewCanvas.zoomValue)), this.contentsToViewY((int)((float)line * stepY * SDPrintDialogUI.this.overviewCanvas.zoomValue)), (int)(stepX * SDPrintDialogUI.this.overviewCanvas.zoomValue), (int)(stepY * SDPrintDialogUI.this.overviewCanvas.zoomValue)), new RGB(0, 0, 128))) : new Image((Device)super.getShell().getDisplay(), SDPrintDialogUI.this.drawRegionSelected(toDel, new Rectangle(this.contentsToViewX((int)((float)(--row) * stepX * SDPrintDialogUI.this.overviewCanvas.zoomValue)), this.contentsToViewY((int)((float)(--line) * stepY * SDPrintDialogUI.this.overviewCanvas.zoomValue)), (int)(stepX * SDPrintDialogUI.this.overviewCanvas.zoomValue), (int)(stepY * SDPrintDialogUI.this.overviewCanvas.zoomValue)), new RGB(221, 208, 200)));
                    toDel.dispose();
                }
                ++pageIndex;
            }
            Arrays.sort(SDPrintDialogUI.this.pagesList);
            int pos = Arrays.binarySearch(SDPrintDialogUI.this.pagesList, SDPrintDialogUI.this.pageNum);
            if (pos < 0 && SDPrintDialogUI.this.getPagesForSelection() > 0 && SDPrintDialogUI.this.pageNum > 0) {
                int line = SDPrintDialogUI.this.pageNum / SDPrintDialogUI.this.getNbRow();
                int row = SDPrintDialogUI.this.pageNum % SDPrintDialogUI.this.getNbRow();
                if (row != 0) {
                    ++line;
                } else {
                    row = SDPrintDialogUI.this.getNbRow();
                }
                Image toDel = over;
                over = new Image((Device)super.getShell().getDisplay(), SDPrintDialogUI.this.drawRegionSelected(toDel, new Rectangle(this.contentsToViewX((int)((float)(--row) * stepX * SDPrintDialogUI.this.overviewCanvas.zoomValue)), this.contentsToViewY((int)((float)(--line) * stepY * SDPrintDialogUI.this.overviewCanvas.zoomValue)), (int)(stepX * SDPrintDialogUI.this.overviewCanvas.zoomValue), (int)(stepY * SDPrintDialogUI.this.overviewCanvas.zoomValue)), new RGB(221, 208, 200)));
                toDel.dispose();
            }
            GC imGC2 = new GC((Drawable)over);
            imGC2.setBackground(Display.getDefault().getSystemColor(2));
            NGC imGC = new NGC(SDPrintDialogUI.this.overviewCanvas, imGC2);
            int i = 0;
            int x = 0;
            while (x <= width && stepX > 0.0f) {
                imGC.drawLine(x, 0, x, height);
                x = (int)((float)(++i) * stepX);
            }
            int j = 0;
            int y = 0;
            while (y <= height && stepY > 0.0f) {
                imGC.drawLine(0, y, width, y);
                y = (int)((float)(++j) * stepY);
            }
            imGC2.dispose();
            imGC.dispose();
            return over;
        }

        @Override
        protected void drawContents(GC gc, int clipx, int clipy, int clipw, int cliph) {
            Image dbuffer = this.getDrawBuffer(gc);
            SDPrintDialogUI.this.computeStepXY();
            int lw = (int)((float)this.getContentsWidth() / this.zoomValue);
            if (this.getContentsWidth() < this.getVisibleWidth()) {
                lw = (int)((float)this.getVisibleWidth() / this.zoomValue);
            }
            int lh = (int)((float)this.getContentsHeight() / this.zoomValue);
            if (this.getContentsHeight() < this.getVisibleHeight()) {
                lh = (int)((float)this.getVisibleHeight() / this.zoomValue);
            }
            Image d = this.createPagesSelectionImages(dbuffer, lw, SDPrintDialogUI.this.stepX, lh, SDPrintDialogUI.this.stepY);
            if (!this.isEnabled()) {
                Image toDel = d;
                d = new Image((Device)super.getShell().getDisplay(), SDPrintDialogUI.this.drawRegionSelected(d, new Rectangle(0, 0, lw, lh), new RGB(221, 208, 200)));
                toDel.dispose();
            }
            Rectangle area = this.getClientArea();
            int w = d.getBounds().width;
            int h = d.getBounds().height;
            gc.drawImage(d, 0, 0, w, h, 0, 0, area.width, area.height);
            SDPrintDialogUI.this.totalPages.setText(Integer.valueOf(SDPrintDialogUI.this.maxNumOfPages()).toString());
            SDPrintDialogUI.this.displayPageNum();
            dbuffer.dispose();
            d.dispose();
            gc.dispose();
        }

        @Override
        protected void keyPressedEvent(KeyEvent e) {
            int row;
            int row2;
            int line;
            if (e.keyCode == 262144) {
                SDPrintDialogUI.this.multiSelection = true;
            }
            if (e.keyCode == 131072) {
                SDPrintDialogUI.this.areaSelection = true;
            }
            if (e.keyCode == 0x1000002) {
                if (SDPrintDialogUI.this.pageNum + SDPrintDialogUI.this.getNbRow() <= SDPrintDialogUI.this.maxNumOfPages()) {
                    SDPrintDialogUI.this.pageNum += SDPrintDialogUI.this.getNbRow();
                }
                line = SDPrintDialogUI.this.pageNum / SDPrintDialogUI.this.getNbRow();
                row2 = SDPrintDialogUI.this.pageNum % SDPrintDialogUI.this.getNbRow();
                if (row2 == 0) {
                    --line;
                }
                if ((float)(line + 1) * SDPrintDialogUI.this.stepY > (float)(SDPrintDialogUI.this.overviewCanvas.getContentsY() + SDPrintDialogUI.this.overviewCanvas.getVisibleHeight()) / SDPrintDialogUI.this.overviewCanvas.zoomValue) {
                    SDPrintDialogUI.this.overviewCanvas.scrollBy(0, (int)(SDPrintDialogUI.this.stepY * SDPrintDialogUI.this.overviewCanvas.zoomValue));
                }
            }
            if (e.keyCode == 0x1000001) {
                if (SDPrintDialogUI.this.pageNum - SDPrintDialogUI.this.getNbRow() > 0) {
                    SDPrintDialogUI.this.pageNum -= SDPrintDialogUI.this.getNbRow();
                }
                line = SDPrintDialogUI.this.pageNum / SDPrintDialogUI.this.getNbRow();
                row2 = SDPrintDialogUI.this.pageNum % SDPrintDialogUI.this.getNbRow();
                if (row2 == 0) {
                    --line;
                }
                if ((float)line * SDPrintDialogUI.this.stepY <= (float)SDPrintDialogUI.this.overviewCanvas.getContentsY() / SDPrintDialogUI.this.overviewCanvas.zoomValue) {
                    SDPrintDialogUI.this.overviewCanvas.scrollBy(0, -((int)(SDPrintDialogUI.this.stepY * SDPrintDialogUI.this.overviewCanvas.zoomValue)));
                }
            }
            if (e.keyCode == 0x1000003) {
                if ((SDPrintDialogUI.this.pageNum - 2) / SDPrintDialogUI.this.getNbRow() == (SDPrintDialogUI.this.pageNum - 1) / SDPrintDialogUI.this.getNbRow() && SDPrintDialogUI.this.pageNum > 1) {
                    --SDPrintDialogUI.this.pageNum;
                }
                if ((float)((row = SDPrintDialogUI.this.pageNum % SDPrintDialogUI.this.getNbRow()) - 1) * SDPrintDialogUI.this.stepX < (float)SDPrintDialogUI.this.overviewCanvas.getContentsX() / SDPrintDialogUI.this.overviewCanvas.zoomValue) {
                    SDPrintDialogUI.this.overviewCanvas.scrollBy(-((int)(SDPrintDialogUI.this.stepX * SDPrintDialogUI.this.overviewCanvas.zoomValue)), 0);
                }
            }
            if (e.keyCode == 0x1000004) {
                if ((SDPrintDialogUI.this.pageNum - 1) / SDPrintDialogUI.this.getNbRow() == SDPrintDialogUI.this.pageNum / SDPrintDialogUI.this.getNbRow()) {
                    ++SDPrintDialogUI.this.pageNum;
                }
                if ((row = SDPrintDialogUI.this.pageNum % SDPrintDialogUI.this.getNbRow()) == 0) {
                    row = SDPrintDialogUI.this.getNbRow();
                }
                if ((float)row * SDPrintDialogUI.this.stepX > (float)(SDPrintDialogUI.this.overviewCanvas.getContentsX() + SDPrintDialogUI.this.overviewCanvas.getVisibleWidth()) / SDPrintDialogUI.this.overviewCanvas.zoomValue) {
                    SDPrintDialogUI.this.overviewCanvas.scrollBy((int)(SDPrintDialogUI.this.stepX * SDPrintDialogUI.this.overviewCanvas.zoomValue), 0);
                }
            }
            if (e.keyCode == 32 && SDPrintDialogUI.this.pageNum > -1) {
                Arrays.sort(SDPrintDialogUI.this.pagesList);
                int pos = Arrays.binarySearch(SDPrintDialogUI.this.pagesList, SDPrintDialogUI.this.pageNum);
                if (pos < 0) {
                    SDPrintDialogUI.this.addToPagesList(SDPrintDialogUI.this.pageNum);
                } else {
                    SDPrintDialogUI.this.removeFromPagesList(SDPrintDialogUI.this.pageNum);
                }
            }
            if (!SDPrintDialogUI.this.areaSelection && !SDPrintDialogUI.this.multiSelection) {
                SDPrintDialogUI.this.firstPage = SDPrintDialogUI.this.pageNum;
                SDPrintDialogUI.this.pagesList = new int[1];
                SDPrintDialogUI.this.pagesList[0] = SDPrintDialogUI.this.pageNum;
            } else if (SDPrintDialogUI.this.pageNum != -1 && SDPrintDialogUI.this.areaSelection && SDPrintDialogUI.this.firstPage != -1) {
                int temp;
                SDPrintDialogUI.this.pagesList = new int[0];
                int line1 = SDPrintDialogUI.this.firstPage / SDPrintDialogUI.this.getNbRow();
                int row1 = SDPrintDialogUI.this.firstPage % SDPrintDialogUI.this.getNbRow();
                if (row1 != 0) {
                    ++line1;
                } else {
                    row1 = SDPrintDialogUI.this.getNbRow();
                }
                int line2 = SDPrintDialogUI.this.pageNum / SDPrintDialogUI.this.getNbRow();
                int row22 = SDPrintDialogUI.this.pageNum % SDPrintDialogUI.this.getNbRow();
                if (row22 != 0) {
                    ++line2;
                } else {
                    row22 = SDPrintDialogUI.this.getNbRow();
                }
                if (line1 > line2) {
                    temp = line2;
                    line2 = line1;
                    line1 = temp;
                }
                if (row1 > row22) {
                    temp = row22;
                    row22 = row1;
                    row1 = temp;
                }
                int i = row1 - 1;
                while (i < row22) {
                    int j = line1 - 1;
                    while (j < line2) {
                        SDPrintDialogUI.this.addToPagesList(i + j * SDPrintDialogUI.this.getNbRow() + 1);
                        ++j;
                    }
                    ++i;
                }
            }
            SDPrintDialogUI.this.displayPageNum();
            SDPrintDialogUI.this.overviewCanvas.redraw();
        }

        @Override
        protected void keyReleasedEvent(KeyEvent e) {
            if (e.keyCode == 262144) {
                SDPrintDialogUI.this.multiSelection = false;
            }
            if (e.keyCode == 131072) {
                SDPrintDialogUI.this.areaSelection = false;
            }
        }

        @Override
        protected void contentsMouseDownEvent(MouseEvent event) {
            SDPrintDialogUI.this.computeStepXY();
            int x1 = (int)((float)event.x / SDPrintDialogUI.this.overviewCanvas.zoomValue / SDPrintDialogUI.this.stepX);
            int x2 = (int)((float)event.y / SDPrintDialogUI.this.overviewCanvas.zoomValue / SDPrintDialogUI.this.stepY);
            int oldPage = SDPrintDialogUI.this.pageNum;
            SDPrintDialogUI.this.pageNum = x1 + x2 * SDPrintDialogUI.this.getNbRow() + 1;
            if (SDPrintDialogUI.this.pageNum > SDPrintDialogUI.this.maxNumOfPages()) {
                SDPrintDialogUI.this.pageNum = oldPage;
                return;
            }
            if (!SDPrintDialogUI.this.areaSelection) {
                SDPrintDialogUI.this.firstPage = SDPrintDialogUI.this.pageNum;
            }
            if (SDPrintDialogUI.this.pageNum != -1 && SDPrintDialogUI.this.multiSelection) {
                Arrays.sort(SDPrintDialogUI.this.pagesList);
                int pos = Arrays.binarySearch(SDPrintDialogUI.this.pagesList, SDPrintDialogUI.this.pageNum);
                if (pos < 0) {
                    SDPrintDialogUI.this.addToPagesList(SDPrintDialogUI.this.pageNum);
                } else {
                    SDPrintDialogUI.this.removeFromPagesList(SDPrintDialogUI.this.pageNum);
                }
            } else if (SDPrintDialogUI.this.pageNum != -1 && SDPrintDialogUI.this.areaSelection && SDPrintDialogUI.this.firstPage != -1) {
                int temp;
                SDPrintDialogUI.this.pagesList = new int[0];
                int line1 = SDPrintDialogUI.this.firstPage / SDPrintDialogUI.this.getNbRow();
                int row1 = SDPrintDialogUI.this.firstPage % SDPrintDialogUI.this.getNbRow();
                if (row1 != 0) {
                    ++line1;
                } else {
                    row1 = SDPrintDialogUI.this.getNbRow();
                }
                int line2 = SDPrintDialogUI.this.pageNum / SDPrintDialogUI.this.getNbRow();
                int row2 = SDPrintDialogUI.this.pageNum % SDPrintDialogUI.this.getNbRow();
                if (row2 != 0) {
                    ++line2;
                } else {
                    row2 = SDPrintDialogUI.this.getNbRow();
                }
                if (line1 > line2) {
                    temp = line2;
                    line2 = line1;
                    line1 = temp;
                }
                if (row1 > row2) {
                    temp = row2;
                    row2 = row1;
                    row1 = temp;
                }
                int i = row1 - 1;
                while (i < row2) {
                    int j = line1 - 1;
                    while (j < line2) {
                        SDPrintDialogUI.this.addToPagesList(i + j * SDPrintDialogUI.this.getNbRow() + 1);
                        ++j;
                    }
                    ++i;
                }
            } else {
                SDPrintDialogUI.this.pagesList = new int[1];
                SDPrintDialogUI.this.pagesList[0] = SDPrintDialogUI.this.pageNum;
            }
            if ((event.stateMask & 0x40000) != 0) {
                SDPrintDialogUI.this.multiSelection = true;
            }
            SDPrintDialogUI.this.displayPageNum();
            this.redraw();
        }

        @Override
        protected void contentsMouseMoveEvent(MouseEvent e) {
            this.toolTip.hideToolTip();
        }

        @Override
        public void resizeContents(int _w, int _h) {
            super.resizeContents(_w, _h);
        }
    }
}

