/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.filter;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterAndNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterCompareNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterContainsNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterEqualsNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterEventTypeNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterMatchesNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterOrNode;
import org.eclipse.swt.graphics.Image;

public class FilterTreeLabelProvider
implements ILabelProvider {
    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        String label = null;
        if (element instanceof TmfFilterNode) {
            TmfFilterNode node = (TmfFilterNode)element;
            label = String.valueOf(node.getNodeName()) + " " + node.getFilterName();
        } else if (element instanceof TmfFilterEventTypeNode) {
            TmfFilterEventTypeNode node = (TmfFilterEventTypeNode)element;
            label = "WITH " + node.getNodeName() + (node.getName() != null ? " " + node.getName() : "");
        } else if (element instanceof TmfFilterAndNode) {
            TmfFilterAndNode node = (TmfFilterAndNode)element;
            label = String.valueOf(node.isNot() ? "NOT " : "") + node.getNodeName();
        } else if (element instanceof TmfFilterOrNode) {
            TmfFilterOrNode node = (TmfFilterOrNode)element;
            label = String.valueOf(node.isNot() ? "NOT " : "") + node.getNodeName();
        } else if (element instanceof TmfFilterContainsNode) {
            TmfFilterContainsNode node = (TmfFilterContainsNode)element;
            label = String.valueOf(node.isNot() ? "NOT " : "") + (node.getField() != null ? String.valueOf(node.getField()) + " " : "") + node.getNodeName() + (node.getValue() != null && node.getValue().length() > 0 ? " \"" + node.getValue() + "\"" : "");
        } else if (element instanceof TmfFilterEqualsNode) {
            TmfFilterEqualsNode node = (TmfFilterEqualsNode)element;
            label = String.valueOf(node.isNot() ? "NOT " : "") + (node.getField() != null ? String.valueOf(node.getField()) + " " : "") + node.getNodeName() + (node.getValue() != null && node.getValue().length() > 0 ? " \"" + node.getValue() + "\"" : "");
        } else if (element instanceof TmfFilterMatchesNode) {
            TmfFilterMatchesNode node = (TmfFilterMatchesNode)element;
            label = String.valueOf(node.isNot() ? "NOT " : "") + (node.getField() != null ? String.valueOf(node.getField()) + " " : "") + node.getNodeName() + (node.getRegex() != null && node.getRegex().length() > 0 ? " \"" + node.getRegex() + "\"" : "");
        } else if (element instanceof TmfFilterCompareNode) {
            TmfFilterCompareNode node = (TmfFilterCompareNode)element;
            label = String.valueOf(node.isNot() ? "NOT " : "") + (node.getField() != null ? String.valueOf(node.getField()) + " " : "") + (node.getResult() < 0 ? "<" : (node.getResult() > 0 ? ">" : "=")) + (node.getValue() != null && node.getValue().length() > 0 ? (node.getType() == TmfFilterCompareNode.Type.ALPHA ? " \"" + node.getValue() + "\"" : (node.getType() == TmfFilterCompareNode.Type.TIMESTAMP ? " [" + node.getValue() + "]" : " " + node.getValue())) : "");
        }
        return label;
    }
}

