/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.logging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.linuxtools.systemtap.ui.logging.internal.LogDaemon;
import org.eclipse.linuxtools.systemtap.ui.logging.internal.LogEntry;
import org.eclipse.linuxtools.systemtap.ui.logging.internal.LoggingPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogManager
implements IPropertyChangeListener {
    private static LogManager instance = new LogManager();
    private LinkedList<LogEntry> entries = new LinkedList();
    public static final int DEBUG = 3;
    public static final int INFO = 2;
    public static final int CRITICAL = 1;
    public static final int FATAL = 0;
    public static final int CONSOLE = 0;
    public static final int FILE = 1;

    private LogManager() {
    }

    private void disable() {
        LogManager.logDebug("disabling", this);
    }

    public void begin() {
        LoggingPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.init();
    }

    private void init() {
        BufferedWriter writer = null;
        IPreferenceStore store = LoggingPlugin.getDefault().getPreferenceStore();
        boolean enabled = store.getBoolean("STapLoggingEnabled");
        int level = Integer.parseInt(store.getString("STapLoggingLevel"));
        int type = Integer.parseInt(store.getString("STapLoggingType"));
        String filename = store.getString("STapLoggingFile");
        if (enabled) {
            if (type == 0) {
                writer = new BufferedWriter(new OutputStreamWriter(System.out));
            }
            if (1 == type) {
                try {
                    File file = new File(filename);
                    if (!file.exists()) {
                        file.getParentFile().mkdirs();
                        file.createNewFile();
                    }
                    writer = new BufferedWriter(new FileWriter(file));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (writer != null) {
                this.log(2, "Initialized - Stream " + writer.toString());
                new LogDaemon(writer, level);
            }
        } else {
            this.disable();
        }
    }

    public static LogManager getInstance() {
        return instance;
    }

    private synchronized void log(int level, String input) {
        this.entries.add(new LogEntry(level, input));
    }

    protected void finalize() throws Throwable {
        IPreferenceStore store;
        LoggingPlugin plugin = LoggingPlugin.getDefault();
        if (plugin != null && (store = plugin.getPreferenceStore()) != null) {
            store.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        super.finalize();
    }

    private String stamp(String input, Object o) {
        Class<?> cs = o.getClass();
        String className = cs.getName();
        return "[" + className + "@" + Integer.toHexString(o.hashCode()) + "] " + input;
    }

    public static synchronized void logInfo(String input, Object o) {
        instance.log(2, instance.stamp(input, o));
    }

    public static synchronized void logDebug(String input, Object o) {
        instance.log(3, instance.stamp(input, o));
    }

    public static synchronized void logCritical(String input, Object o) {
        instance.log(1, instance.stamp(input, o));
    }

    public static synchronized void logFatal(String input, Object o) {
        instance.log(0, instance.stamp(input, o));
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("STapLoggingEnabled") || property.equals("STapLoggingFile") || property.equals("STapLoggingLevel") || property.equals("STapLoggingType")) {
            LogManager.logInfo("LogManager reinitialization in progress", this);
            this.init();
        }
    }

    public LinkedList<LogEntry> getEntries() {
        return this.entries;
    }
}

