/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.ide.actions.hidden;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.systemtap.ui.editor.PathEditorInput;
import org.eclipse.linuxtools.systemtap.ui.ide.IDESessionSettings;
import org.eclipse.linuxtools.systemtap.ui.ide.actions.hidden.TreeExpandCollapseAction;
import org.eclipse.linuxtools.systemtap.ui.ide.editors.stp.STPEditor;
import org.eclipse.linuxtools.systemtap.ui.ide.internal.Localization;
import org.eclipse.linuxtools.systemtap.ui.ide.views.KernelBrowserView;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class KernelSourceAction
extends Action
implements ISelectionListener,
ActionFactory.IWorkbenchAction {
    private final IWorkbenchWindow window;
    public static final String ID = "org.eclipse.linuxtools.systemtap.ui.ide.KBAction";
    private KernelBrowserView viewer;
    private IStructuredSelection selection;
    private TreeExpandCollapseAction expandAction;

    public KernelSourceAction(IWorkbenchWindow window, KernelBrowserView browser) {
        LogManager.logDebug((String)("Start KernelSourceAction: window-" + window + ", browser-" + (Object)((Object)browser)), (Object)((Object)this));
        LogManager.logInfo((String)"Initializing", (Object)((Object)this));
        this.window = window;
        this.setId(ID);
        this.setActionDefinitionId(ID);
        this.setText(Localization.getString("KernelSourceAction.Insert"));
        this.setToolTipText(Localization.getString("KernelSourceAction.InsertSelectedFunction"));
        window.getSelectionService().addSelectionListener((ISelectionListener)this);
        this.viewer = browser;
        this.expandAction = new TreeExpandCollapseAction(KernelBrowserView.class);
        LogManager.logDebug((String)"End KernelSourceAction:", (Object)((Object)this));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection incoming) {
        if (incoming instanceof IStructuredSelection) {
            LogManager.logDebug((String)"Changing selection", (Object)((Object)this));
            this.selection = (IStructuredSelection)incoming;
            this.setEnabled(this.selection.size() == 1);
        } else {
            LogManager.logDebug((String)"Disabling, selection not IStructuredSelection", (Object)((Object)this));
            this.setEnabled(false);
        }
    }

    public void dispose() {
        LogManager.logInfo((String)"Disposing", (Object)((Object)this));
        this.window.getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    private IEditorInput createEditorInput(File file) {
        Path location = new Path(file.getAbsolutePath());
        PathEditorInput input = new PathEditorInput((IPath)location, this.window);
        LogManager.logDebug((String)("createEditorInput: returnVal-" + input), (Object)((Object)this));
        return input;
    }

    private String getEditorId(File file) {
        IEditorDescriptor[] descriptors;
        IWorkbench workbench = this.window.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor[] iEditorDescriptorArray = descriptors = editorRegistry.getEditors(file.getName());
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorDescriptor d = iEditorDescriptorArray[n2];
            if (d.getId().startsWith("org.eclipse.linuxtools.systemtap.ui.ide.editors")) {
                LogManager.logDebug((String)("getEditorId: returnVal-" + d.getId()), (Object)((Object)this));
                return d.getId();
            }
            ++n2;
        }
        LogManager.logDebug((String)"getEditorId: returnVal-...SimpleEditor", (Object)((Object)this));
        return "org.eclipse.linuxtools.systemtap.ui.editor.SimpleEditor";
    }

    public void run() {
        LogManager.logDebug((String)"Start run", (Object)((Object)this));
        IWorkbench wb = PlatformUI.getWorkbench();
        ISelection incoming = this.viewer.getViewer().getSelection();
        IStructuredSelection selection = (IStructuredSelection)incoming;
        Object o = selection.getFirstElement();
        if (o instanceof TreeNode) {
            TreeNode t = (TreeNode)o;
            if (t.isClickable()) {
                File file = (File)t.getData();
                if (file != null) {
                    IEditorInput input = this.createEditorInput(file);
                    String editorId = this.getEditorId(file);
                    try {
                        IEditorPart editor = wb.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                        if (editor instanceof STPEditor) {
                            IDESessionSettings.activeSTPEditor = (STPEditor)editor;
                        }
                        wb.getActiveWorkbenchWindow().getActivePage().openEditor(input, editorId);
                        LogManager.logDebug((String)"Editor opened", (Object)((Object)this));
                    }
                    catch (PartInitException e) {
                        LogManager.logCritical((String)("PartInitException run: " + e.getMessage()), (Object)((Object)this));
                    }
                }
            } else {
                this.expandAction.run();
            }
        }
        LogManager.logDebug((String)"End run", (Object)((Object)this));
    }
}

