/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.adapters.IAdapter;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.IUpdateListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractChartBuilder
extends Canvas
implements IUpdateListener {
    protected static final String FONT_NAME = "MS Sans Serif";
    protected IAdapter adapter = null;
    protected int xseries;
    protected int[] yseries;
    protected Chart chart = null;
    protected String title = null;

    public AbstractChartBuilder(IAdapter adapter, Composite parent, int style) {
        super(parent, style);
        this.adapter = adapter;
    }

    public void build() {
        this.createChart();
        this.buildPlot();
        this.buildLegend();
        this.buildTitle();
        this.buildXAxis();
        this.buildYAxis();
        this.buildXSeries();
        this.buildYSeries();
        this.updateDataSet();
    }

    protected abstract void createChart();

    protected void buildPlot() {
    }

    protected void buildXAxis() {
    }

    protected void buildYAxis() {
    }

    protected void buildXSeries() {
    }

    protected void buildYSeries() {
    }

    protected void buildLegend() {
    }

    protected void buildTitle() {
    }

    public Chart getChart() {
        return this.chart;
    }

    public void updateDataSet() {
    }

    public void setScale(double scale) {
    }
}

