/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.chart.widget;

import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.AbstractChartBuilder;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class ChartCanvas
extends Canvas {
    protected IDeviceRenderer render = null;
    protected Chart chart = null;
    protected AbstractChartBuilder builder = null;
    protected GeneratedChartState state = null;

    public ChartCanvas(Composite parent, int style) {
        super(parent, style | 0x200 | 0x100);
        try {
            PlatformConfig pf = new PlatformConfig();
            ChartEngine ce = ChartEngine.instance((PlatformConfig)pf);
            try {
                this.render = ce.getRenderer("dv.SWT");
            }
            catch (ChartException ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent pe) {
                if (ChartCanvas.this.chart == null) {
                    return;
                }
                try {
                    ChartCanvas.this.render.setProperty("device.output.context", (Object)pe.gc);
                    Composite co = (Composite)pe.getSource();
                    Rectangle re = co.getClientArea();
                    Bounds bo = BoundsImpl.create((double)re.x, (double)re.y, (double)re.width, (double)re.height);
                    bo.scale(72.0 / (double)ChartCanvas.this.render.getDisplayServer().getDpiResolution());
                    Generator gr = Generator.instance();
                    ChartCanvas.this.state = gr.build(ChartCanvas.this.render.getDisplayServer(), ChartCanvas.this.chart, bo, null, null, null);
                    gr.render(ChartCanvas.this.render, ChartCanvas.this.state);
                }
                catch (ChartException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(AbstractChartBuilder builder) {
        this.chart = builder.getChart();
        this.builder = builder;
        this.redraw();
    }

    public void handleUpdateEvent() {
        this.builder.updateDataSet();
        this.chart = this.builder.getChart();
        this.chart = null;
        this.redraw();
        this.update();
    }

    public synchronized void repaint() {
        this.getDisplay().syncExec(new Runnable(){
            boolean stop = false;

            public void run() {
                if (this.stop) {
                    return;
                }
                try {
                    ChartCanvas.this.redraw();
                }
                catch (Exception exception) {
                    this.stop = true;
                }
            }
        });
    }
}

