/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.dashboard.views;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.DashboardModuleLocator;
import org.eclipse.linuxtools.systemtap.ui.dashboard.views.ModuleView;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class DashboardModuleBrowserView
extends ModuleView {
    public static final String ID = "org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardModuleBrowserView";
    private IDoubleClickListener dblClickListener;

    public DashboardModuleBrowserView() {
        LogManager.logInfo((String)"Initializing", (Object)((Object)this));
    }

    protected void generateModuleTree() {
        TreeNode modules = DashboardModuleLocator.getModules();
        if (modules != null) {
            this.viewer.setInput((Object)modules);
        } else {
            this.viewer.setInput((Object)new TreeNode((Object)"", false));
        }
    }

    protected void makeActions() {
        this.dblClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
            }
        };
        this.viewer.addDoubleClickListener(this.dblClickListener);
        MenuManager manager = new MenuManager("modulePopup");
        Control control = this.viewer.getControl();
        manager.add((IContributionItem)new Separator("file.ext"));
        manager.add((IContributionItem)new Separator("build.ext"));
        manager.add((IContributionItem)new Separator("additions"));
        Menu menu = manager.createContextMenu(control);
        control.setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.viewer);
        super.makeActions();
    }

    public void dispose() {
        LogManager.logInfo((String)"disposing", (Object)((Object)this));
        this.viewer.removeDoubleClickListener(this.dblClickListener);
        super.dispose();
    }
}

