/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.latency;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.linuxtools.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.lttng.ui.views.latency.GraphViewer;
import org.eclipse.linuxtools.lttng.ui.views.latency.HistogramViewer;
import org.eclipse.linuxtools.lttng.ui.views.latency.Messages;
import org.eclipse.linuxtools.lttng.ui.views.latency.dialogs.AddDialog;
import org.eclipse.linuxtools.lttng.ui.views.latency.dialogs.DeleteDialog;
import org.eclipse.linuxtools.lttng.ui.views.latency.dialogs.ListDialog;
import org.eclipse.linuxtools.lttng.ui.views.latency.model.IGraphModelListener;
import org.eclipse.linuxtools.lttng.ui.views.latency.model.LatencyController;
import org.eclipse.linuxtools.lttng.ui.views.latency.model.LatencyGraphModel;
import org.eclipse.linuxtools.tmf.core.component.TmfEventProvider;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentDisposedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfRangeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.linuxtools.tmf.ui.views.distribution.model.IBaseDistributionModel;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LatencyView
extends TmfView
implements IGraphModelListener {
    public static final long INITIAL_WINDOW_SPAN = 100000000L;
    public static final String ID = "org.eclipse.linuxtools.lttng.ui.views.latency.LatencyView";
    protected TmfExperiment<LttngEvent> fExperiment = null;
    protected Composite fParent;
    protected GraphViewer fGraphViewer;
    protected HistogramViewer fHistogramViewer;
    protected Action fListMatchingEvents;
    protected Action fAddMatchingEvents;
    protected Action fDeleteMatchingEvents;
    protected Action fIncreaseBarWidth;
    protected Action fDecreaseBarWidth;
    protected TmfTimeRange fTimeRange = null;
    private final LatencyController fController = LatencyController.getInstance();
    private boolean fSyncSignalReceived = false;

    public LatencyView() {
        super(Messages.LatencyView_ViewName);
    }

    public void createPartControl(Composite parent) {
        TmfTimeRange experimentTRange;
        this.fParent = parent;
        this.makeActions();
        this.contributeToActionBars();
        this.fParent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent event) {
                LatencyView.this.fHistogramViewer.clearBackground();
                LatencyView.this.fGraphViewer.clearBackground();
                LatencyView.this.fController.handleCompleted();
            }

            public void controlResized(ControlEvent event) {
                LatencyView.this.fHistogramViewer.clearBackground();
                LatencyView.this.fGraphViewer.clearBackground();
                LatencyView.this.fController.handleCompleted();
            }
        });
        Composite layoutFullView = new Composite(this.fParent, 4);
        FillLayout gridFullView = new FillLayout();
        gridFullView.marginHeight = 0;
        gridFullView.marginWidth = 0;
        layoutFullView.setLayout((Layout)gridFullView);
        this.fGraphViewer = new GraphViewer(layoutFullView, 0x20000000);
        this.fGraphViewer.setDrawLabelEachNTicks(2);
        this.fGraphViewer.setGraphTitle(Messages.LatencyView_Graphs_Graph_Title);
        this.fGraphViewer.setXAxisLabel(Messages.LatencyView_Graphs_Graph_XAxisLabel, 40);
        this.fGraphViewer.setYAxisLabel(Messages.LatencyView_Graphs_Graph_YAxisLabel);
        this.fHistogramViewer = new HistogramViewer(layoutFullView, 0x20000000);
        this.fHistogramViewer.setDrawLabelEachNTicks(2);
        this.fHistogramViewer.setGraphTitle(Messages.LatencyView_Graphs_Histogram_Title);
        this.fHistogramViewer.setXAxisLabel(Messages.LatencyView_Graphs_Histogram_XAxisLabel, 55);
        this.fHistogramViewer.setYAxisLabel(Messages.LatencyView_Graphs_Histogram_YAxisLabel);
        this.fController.registerModel(this.fGraphViewer.getModel());
        this.fController.registerModel((IBaseDistributionModel)this.fHistogramViewer.getModel());
        ((LatencyGraphModel)this.fGraphViewer.getModel()).addGraphModelListener(this);
        TmfExperiment experiment = TmfExperiment.getCurrentExperiment();
        if (experiment != null && (experimentTRange = experiment.getTimeRange()) != TmfTimeRange.NULL_RANGE) {
            TmfExperimentSelectedSignal signal = new TmfExperimentSelectedSignal((Object)this, experiment);
            this.experimentSelected((TmfExperimentSelectedSignal<TmfEvent>)signal);
        }
    }

    public String toString() {
        return "[" + Messages.LatencyView_ViewName + "]";
    }

    @TmfSignalHandler
    public void experimentSelected(TmfExperimentSelectedSignal<TmfEvent> signal) {
        this.fGraphViewer.clear();
        this.fHistogramViewer.clear();
        if (this.fParent != null) {
            this.fExperiment = signal.getExperiment();
            this.fTimeRange = TmfTimeRange.NULL_RANGE;
            TmfTimeRange experimentTRange = this.fExperiment.getTimeRange();
            if (!experimentTRange.equals((Object)TmfTimeRange.NULL_RANGE)) {
                this.fTimeRange = new TmfTimeRange(experimentTRange.getStartTime(), (ITmfTimestamp)new TmfTimestamp(experimentTRange.getStartTime().getValue() + 100000000L, experimentTRange.getStartTime().getScale(), experimentTRange.getStartTime().getPrecision()));
                this.fController.refreshModels((TmfEventProvider<?>)this.fExperiment, this.fTimeRange);
            }
        }
    }

    @TmfSignalHandler
    public void experimentRangeUpdated(TmfExperimentRangeUpdatedSignal signal) {
        TmfTimeRange experimentTRange;
        if (this.fTimeRange == TmfTimeRange.NULL_RANGE && signal.getExperiment().equals(this.fExperiment) && (experimentTRange = signal.getRange()) != TmfTimeRange.NULL_RANGE) {
            this.fTimeRange = new TmfTimeRange(experimentTRange.getStartTime(), (ITmfTimestamp)new TmfTimestamp(experimentTRange.getStartTime().getValue() + 100000000L, experimentTRange.getStartTime().getScale(), experimentTRange.getStartTime().getPrecision()));
            this.fController.refreshModels((TmfEventProvider<?>)this.fExperiment, this.fTimeRange);
        }
    }

    @TmfSignalHandler
    public void experimentDisposed(TmfExperimentDisposedSignal<TmfEvent> signal) {
        if (signal.getExperiment() != this.fExperiment) {
            return;
        }
        this.fTimeRange = TmfTimeRange.NULL_RANGE;
        this.fExperiment = null;
        this.fController.clear();
    }

    public void dispose() {
        this.fController.dispose();
        this.fController.deregisterModel(this.fGraphViewer.getModel());
        this.fController.deregisterModel((IBaseDistributionModel)this.fHistogramViewer.getModel());
        ((LatencyGraphModel)this.fGraphViewer.getModel()).removeGraphModelListener(this);
        this.fGraphViewer.dispose();
        this.fHistogramViewer.dispose();
        super.dispose();
    }

    @TmfSignalHandler
    public void currentTimeUpdated(TmfTimeSynchSignal signal) {
        if (signal.getSource() != this) {
            this.fSyncSignalReceived = true;
            this.fController.setCurrentEventTime(signal.getCurrentTime().getValue());
            this.fSyncSignalReceived = false;
        }
    }

    @TmfSignalHandler
    public void synchToTimeRange(TmfRangeSynchSignal signal) {
        if (signal.getSource() != this) {
            this.fGraphViewer.clear();
            this.fHistogramViewer.clear();
            ITmfTimestamp startTime = signal.getCurrentRange().getStartTime();
            ITmfTimestamp endTime = signal.getCurrentRange().getEndTime();
            this.fTimeRange = new TmfTimeRange(startTime, endTime);
            this.fController.refreshModels((TmfEventProvider<?>)this.fExperiment, this.fTimeRange);
        }
    }

    @Override
    public void graphModelUpdated() {
    }

    @Override
    public void currentEventUpdated(final long currentEventTime) {
        if (this.fExperiment != null && !this.fSyncSignalReceived && currentEventTime != -1L) {
            TmfTimeRange timeRange = new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(currentEventTime, -9), TmfTimestamp.BIG_CRUNCH);
            TmfEventRequest<LttngEvent> request = new TmfEventRequest<LttngEvent>(LttngEvent.class, timeRange, 0, 1, ITmfDataRequest.ExecutionType.FOREGROUND){

                public void handleCompleted() {
                    LatencyView.this.broadcast((TmfSignal)new TmfTimeSynchSignal((Object)this, (ITmfTimestamp)new TmfTimestamp(currentEventTime, -9)));
                }
            };
            this.fExperiment.sendRequest((ITmfDataRequest)request);
        }
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fIncreaseBarWidth);
        manager.add((IAction)this.fDecreaseBarWidth);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fListMatchingEvents);
        manager.add((IAction)this.fAddMatchingEvents);
        manager.add((IAction)this.fDeleteMatchingEvents);
        manager.add((IContributionItem)new Separator());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fIncreaseBarWidth);
        manager.add((IAction)this.fDecreaseBarWidth);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fListMatchingEvents);
        manager.add((IAction)this.fAddMatchingEvents);
        manager.add((IAction)this.fDeleteMatchingEvents);
        manager.add((IContributionItem)new Separator());
    }

    private void makeActions() {
        this.fIncreaseBarWidth = new Action(){

            public void run() {
                LatencyView.this.fHistogramViewer.increaseBarWidth();
                LatencyView.this.fGraphViewer.increaseBarWidth();
            }
        };
        String tooltipText = Messages.LatencyView_Action_IncreaseBarWidth_Tooltip;
        this.fIncreaseBarWidth.setText(tooltipText);
        this.fIncreaseBarWidth.setToolTipText(tooltipText);
        this.fIncreaseBarWidth.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.LatencyView_tmf_UI, (String)"icons/elcl16/increasebar_button.gif"));
        this.fDecreaseBarWidth = new Action(){

            public void run() {
                LatencyView.this.fHistogramViewer.decreaseBarWidth();
                LatencyView.this.fGraphViewer.decreaseBarWidth();
            }
        };
        tooltipText = Messages.LatencyView_Action_DecreaseBarWidth_Tooltip;
        this.fDecreaseBarWidth.setText(tooltipText);
        this.fDecreaseBarWidth.setToolTipText(tooltipText);
        this.fDecreaseBarWidth.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.LatencyView_tmf_UI, (String)"icons/elcl16/decreasebar_button.gif"));
        this.fListMatchingEvents = new Action(){

            public void run() {
                ListDialog listDialog = new ListDialog(LatencyView.this.fParent.getShell(), Messages.LatencyView_Dialogs_ListEvents_Title, Messages.LatencyView_Dialogs_ListEvents_Message);
                listDialog.create();
                listDialog.open();
            }
        };
        tooltipText = Messages.LatencyView_Action_ListEvents_Tooltip;
        this.fListMatchingEvents.setText(tooltipText);
        this.fListMatchingEvents.setToolTipText(tooltipText);
        this.fListMatchingEvents.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.LatencyView_tmf_UI, (String)"icons/eview16/events_view.gif"));
        this.fAddMatchingEvents = new Action(){

            public void run() {
                AddDialog addDialog = new AddDialog(LatencyView.this.fParent.getShell(), Messages.LatencyView_Dialogs_AddEvents_Title, Messages.LatencyView_Dialogs_AddEvents_Message);
                addDialog.create();
                addDialog.open();
            }
        };
        tooltipText = Messages.LatencyView_Action_AddEvents_Tooltip;
        this.fAddMatchingEvents.setText(tooltipText);
        this.fAddMatchingEvents.setToolTipText(tooltipText);
        this.fAddMatchingEvents.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.LatencyView_tmf_UI, (String)"icons/elcl16/add_button.gif"));
        this.fDeleteMatchingEvents = new Action(){

            public void run() {
                DeleteDialog deleteDialog = new DeleteDialog(LatencyView.this.fParent.getShell(), Messages.LatencyView_Dialogs_DeleteEvents_Title, Messages.LatencyView_Dialogs_DeleteEvents_Message);
                deleteDialog.create();
                deleteDialog.open();
            }
        };
        tooltipText = Messages.LatencyView_Action_DeleteEvents_Tooltip;
        this.fDeleteMatchingEvents.setText(tooltipText);
        this.fDeleteMatchingEvents.setToolTipText(tooltipText);
        this.fDeleteMatchingEvents.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.LatencyView_tmf_UI, (String)"icons/elcl16/delete_button.gif"));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }
}

