/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.common;

import org.eclipse.linuxtools.lttng.core.event.LttngTimestamp;
import org.eclipse.linuxtools.lttng.ui.TraceDebug;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.TmfTimeScaleSelectionEvent;

public class ParamsUpdater {
    private long startTime = 0L;
    private long endTime = Long.MAX_VALUE;
    private static Long selectedTime = null;
    private final int DEFAULT_WIDTH = 2000;
    private int width = 2000;
    private double pixelsPerNs = 0.0;
    private int eventsDiscarded = 0;
    private int eventsDiscardedOutOfView = 0;
    private int eventsDiscardedNotVisible = 0;
    private int eventsDiscardedWrongOrder = 0;
    private TmfTimeRange trange = null;
    public static final int OUT_OF_VIEWRANGE = 0;
    public static final int NOT_VISIBLE = 1;

    public synchronized boolean processTimeScaleEvent(TmfTimeScaleSelectionEvent event) {
        boolean updated = false;
        if (event != null) {
            long time0 = event.getTime0();
            long time1 = event.getTime1();
            int dwidth = event.getWidth();
            updated = this.update(time0, time1, dwidth);
            if (selectedTime == null) {
                this.setSelectedTime(event.getSelectedTime());
            }
        }
        return updated;
    }

    public void setSelectedTime(long selTime) {
        TraceDebug.debug("Selected time changed from: \n\t" + selectedTime + " to: \n\t" + selTime);
        selectedTime = selTime;
    }

    public Long getSelectedTime() {
        return selectedTime;
    }

    public boolean update(long time0, long time1) {
        return this.update(time0, time1, this.width);
    }

    public boolean update(long time0, long time1, int dwidth) {
        boolean updated = false;
        if (time0 == this.startTime && time1 == this.endTime && dwidth == this.width) {
            return updated;
        }
        time0 = time0 > 0L ? time0 : 0L;
        time1 = time1 > 0L ? time1 : 0L;
        int n = dwidth = dwidth > 0 ? dwidth : 0;
        if (time1 > time0) {
            this.startTime = time0;
            this.endTime = time1;
            this.width = dwidth;
            this.pixelsPerNs = (double)this.width / (double)(this.endTime - this.startTime);
            LttngTimestamp fTimeStart = new LttngTimestamp(this.startTime);
            LttngTimestamp fTimeEnd = new LttngTimestamp(this.endTime);
            this.trange = new TmfTimeRange((ITmfTimestamp)fTimeStart, (ITmfTimestamp)fTimeEnd);
            if (selectedTime != null) {
                this.setSelectedTime(selectedTime);
            }
            updated = true;
            TraceDebug.debug("Configuration updated to: StartTime: " + fTimeStart + "-" + fTimeEnd + " width: " + this.width + " k: " + this.pixelsPerNs);
        } else {
            TraceDebug.debug("End time is not greater than start time, start time: " + time0 + " end time: " + time1);
        }
        return updated;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int getWidth() {
        if (this.width == 0) {
            TraceDebug.debug("Unexpected width value of 0 pixels, returning default");
            return 2000;
        }
        return this.width;
    }

    public double getPixelsPerNs() {
        return this.pixelsPerNs;
    }

    public void setPixelsPerNs(double pixperNsec) {
        if (pixperNsec > 0.0) {
            this.pixelsPerNs = pixperNsec;
        }
    }

    public void setEventsDiscarded(int value) {
        this.eventsDiscarded = value;
        if (value == 0) {
            this.eventsDiscardedWrongOrder = 0;
            this.eventsDiscardedNotVisible = 0;
            this.eventsDiscardedOutOfView = 0;
        }
    }

    public void incrementEventsDiscarded(int reason) {
        if (reason == 0) {
            ++this.eventsDiscardedOutOfView;
        }
        if (reason == 1) {
            ++this.eventsDiscardedNotVisible;
        }
        ++this.eventsDiscarded;
    }

    public int getEventsDiscarded() {
        return this.eventsDiscarded;
    }

    public void incrementEventsDiscardedWrongOrder() {
        ++this.eventsDiscarded;
        ++this.eventsDiscardedWrongOrder;
    }

    public int getEventsDiscardedWrongOrder() {
        return this.eventsDiscardedWrongOrder;
    }

    public int getEventsDiscardedNotVisible() {
        return this.eventsDiscardedNotVisible;
    }

    public int getEventsDiscardedOutOfViewRange() {
        return this.eventsDiscardedOutOfView;
    }

    public TmfTimeRange getTrange() {
        return this.trange;
    }
}

