/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.utils;

import java.io.File;
import java.io.IOException;
import java.util.WeakHashMap;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.binutils.utils.STNMFactory;
import org.eclipse.linuxtools.binutils.utils.STNMSymbolsHandler;
import org.eclipse.linuxtools.binutils.utils.STSymbolManager;

public class GprofProgramChecker
implements STNMSymbolsHandler {
    private boolean mcountFound = false;
    private boolean mcleanupFound = false;
    private long timestamp;
    private static final WeakHashMap<File, GprofProgramChecker> map = new WeakHashMap();

    private GprofProgramChecker(long timestamp) {
        this.timestamp = timestamp;
    }

    private static GprofProgramChecker getProgramChecker(IBinaryParser.IBinaryObject object, IProject project) throws IOException {
        File program = object.getPath().toFile();
        GprofProgramChecker pg = map.get(program);
        if (pg == null) {
            pg = new GprofProgramChecker(program.lastModified());
            STNMFactory.getNM((String)object.getCPU(), (String)object.getPath().toOSString(), (STNMSymbolsHandler)pg, (IProject)project);
            map.put(program, pg);
        } else {
            long fileTime = program.lastModified();
            if (fileTime > pg.timestamp) {
                pg.timestamp = fileTime;
                pg.mcleanupFound = false;
                pg.mcountFound = false;
                STNMFactory.getNM((String)object.getCPU(), (String)object.getPath().toOSString(), (STNMSymbolsHandler)pg, (IProject)project);
            }
        }
        return pg;
    }

    public static boolean isGProfCompatible(String s, IProject project) throws IOException {
        IBinaryParser.IBinaryObject object = STSymbolManager.sharedInstance.getBinaryObject((IPath)new Path(s));
        if (object == null) {
            return false;
        }
        return GprofProgramChecker.isGProfCompatible(object, project);
    }

    public static boolean isGProfCompatible(IBinaryParser.IBinaryObject object, IProject project) throws IOException {
        GprofProgramChecker pg = GprofProgramChecker.getProgramChecker(object, project);
        return pg.mcleanupFound && pg.mcountFound;
    }

    public void foundBssSymbol(String symbol, String address) {
    }

    public void foundDataSymbol(String symbol, String address) {
    }

    public void foundTextSymbol(String symbol, String address) {
        if ("mcount".equals(symbol) || "_mcount".equals(symbol) || "__mcount".equals(symbol)) {
            this.mcountFound = true;
        } else if ("mcleanup".equals(symbol) || "_mcleanup".equals(symbol) || "__mcleanup".equals(symbol)) {
            this.mcleanupFound = true;
        }
    }

    public void foundUndefSymbol(String symbol) {
        if (symbol.startsWith("mcount@@GLIBC") || symbol.startsWith("_mcount@@GLIBC") || symbol.startsWith("__mcount@@GLIBC")) {
            this.mcountFound = true;
        } else if (symbol.startsWith("_mcleanup@@GLIBC") || symbol.startsWith("mcleanup@@GLIBC") || symbol.startsWith("__mcleanup@@GLIBC")) {
            this.mcleanupFound = true;
        }
    }
}

