/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.actions;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.AbstractSTAnnotatedSourceEditorInput;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.STAnnotatedSourceEditorActivator;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.actions.AbstractOpenSourceFileAction;

public abstract class OpenWksRelFilePathAction
extends AbstractOpenSourceFileAction {
    private String filepath;

    public OpenWksRelFilePathAction(String filepath, long ts) {
        super(filepath, ts);
        this.filepath = filepath;
    }

    @Override
    public abstract AbstractSTAnnotatedSourceEditorInput getInput(IFileStore var1);

    @Override
    public IFileStore getFileStore() {
        File file = new File(this.filepath);
        IFile f = null;
        if (!file.isAbsolute()) {
            IWorkspaceRoot wrkRoot;
            IPath p;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            if (workspace != null && (p = (f = (wrkRoot = workspace.getRoot()).getFile((IPath)new Path(this.filepath))).getLocation()) != null) {
                file = p.toFile();
            }
            try {
                IFileStore fs = EFS.getStore((URI)file.toURI());
                return fs;
            }
            catch (CoreException e) {
                STAnnotatedSourceEditorActivator.getDefault().getLog().log(e.getStatus());
            }
        }
        return null;
    }
}

