/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.changelog.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.changelog.core.ChangelogPlugin;
import org.eclipse.linuxtools.changelog.core.IFormatterChangeLogContrib;
import org.eclipse.linuxtools.changelog.core.Messages;
import org.eclipse.ui.IEditorPart;

public class ChangeLogWriter {
    private String defaultContent = "";
    private String entryFilePath = null;
    private String guessedFName = null;
    private IFormatterChangeLogContrib formatter = null;
    private IEditorPart changelog = null;
    private String dateLine = null;
    private String changelogLocation = null;

    public IEditorPart getChangelog() {
        return this.changelog;
    }

    public void setChangelog(IEditorPart changelog) {
        this.changelog = changelog;
    }

    public String getChangelogLocation() {
        return this.changelogLocation;
    }

    public void setChangelogLocation(String changelogLocation) {
        this.changelogLocation = changelogLocation;
    }

    public String getDateLine() {
        return this.dateLine;
    }

    public void setDateLine(String dateLine) {
        this.dateLine = dateLine;
    }

    public String getEntryFilePath() {
        return this.entryFilePath;
    }

    public void setEntryFilePath(String entryFilePath) {
        String resolvedPath = entryFilePath.replace("(", "\\(");
        resolvedPath = resolvedPath.replace(")", "\\)");
        resolvedPath = resolvedPath.replace(":", "\\:");
        this.entryFilePath = resolvedPath = resolvedPath.replace(" ", "\\ ");
    }

    public IFormatterChangeLogContrib getFormatter() {
        return this.formatter;
    }

    public void setFormatter(IFormatterChangeLogContrib formatter) {
        this.formatter = formatter;
    }

    public String getGuessedFName() {
        return this.guessedFName;
    }

    public void setGuessedFName(String guessedFName) {
        this.guessedFName = guessedFName;
    }

    public void writeChangeLog() {
        if (this.entryFilePath == null || this.guessedFName == null || this.formatter == null || this.changelog == null || this.dateLine == null || this.changelogLocation == null) {
            ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, Messages.getString("ChangeLogWriter.ErrUninitialized"), null));
            return;
        }
        this.formatter.mergeChangelog(this.dateLine, this.guessedFName, this.defaultContent, this.changelog, this.changelogLocation, this.entryFilePath);
    }

    public String getDefaultContent() {
        return this.defaultContent;
    }

    public void setDefaultContent(String defaultContent) {
        this.defaultContent = defaultContent;
    }
}

