/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.SDWidget;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.dialogs.SDPrintDialogUI;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.SDMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class SDPrintDialog
extends Dialog {
    protected SDWidget fSdView;
    protected SDPrintDialogUI fDialogUI;
    protected String fErrorMessage = null;
    protected Label fMessageLabel = null;
    protected boolean fIsPageComplete = true;

    public SDPrintDialog(Shell shell, SDWidget viewer) {
        super(shell);
        this.fSdView = viewer;
        this.fDialogUI = new SDPrintDialogUI(shell, this.fSdView);
        this.fDialogUI.setParentDialog(this);
    }

    protected Control createDialogArea(Composite p) {
        p.getShell().setText(SDMessages._114);
        Composite parent = (Composite)super.createDialogArea(p);
        this.fDialogUI.createDialogArea(parent);
        this.fMessageLabel = new Label(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 6;
        this.fMessageLabel.setLayoutData((Object)gridData);
        this.setErrorMessage(this.fErrorMessage);
        return parent;
    }

    protected void okPressed() {
        if (this.fDialogUI.okPressed()) {
            super.okPressed();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 1024, SDMessages._115, false);
        this.getButton(1024).addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SDPrintDialog.this.fDialogUI.printButtonSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.updateButtons();
    }

    public SDPrintDialogUI getDialogUI() {
        return this.fDialogUI;
    }

    public void setErrorMessage(String message) {
        this.fErrorMessage = message;
        if (this.fMessageLabel != null) {
            if (this.fErrorMessage == null) {
                this.fMessageLabel.setText("");
            } else {
                this.fMessageLabel.setText(this.fErrorMessage);
            }
        }
    }

    public void setPageComplete(boolean complete) {
        this.fIsPageComplete = complete;
        this.updateButtons();
    }

    public void updateButtons() {
        Button okButton = this.getButton(0);
        if (this.fIsPageComplete) {
            if (okButton != null) {
                okButton.setEnabled(true);
            }
        } else if (okButton != null) {
            okButton.setEnabled(false);
        }
    }
}

