/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.SDWidget;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.TimeCompressionBar;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.BaseMessage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Frame;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.SyncMessage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.SyncMessageReturn;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ConfigureMinMax;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.FirstPage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.KeyBindingsManager;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.LastPage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.MoveToMessage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.NextPage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.OpenSDFiltersDialog;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.OpenSDFindDialog;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.OpenSDPagesDialog;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.PrevPage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.Print;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ShowNodeEnd;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ShowNodeStart;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.Zoom;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.IExtendedFilterProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.IExtendedFindProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDAdvancedPagingProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDCollapseProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDExtendedActionBarProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDFilterProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDFindProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDPagingProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDPropertiesProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.load.IUml2SDLoader;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.load.LoadersManager;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.SDMessages;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class SDView
extends ViewPart {
    protected SDWidget fSdWidget = null;
    protected TimeCompressionBar fTimeCompressionBar = null;
    protected ISDFindProvider fSdFindProvider = null;
    protected ISDPagingProvider fSdPagingProvider = null;
    protected ISDFilterProvider fSdFilterProvider = null;
    protected IExtendedFilterProvider fSdExFilterProvider = null;
    protected IExtendedFindProvider fSdExFindProvider = null;
    protected ISDExtendedActionBarProvider fSdExtendedActionBarProvider = null;
    protected ISDPropertiesProvider fSdPropertiesProvider = null;
    protected NextPage fNextPageButton = null;
    protected PrevPage fPrevPageButton = null;
    protected FirstPage fFirstPageButton = null;
    protected LastPage fLastPageButton = null;
    protected MenuManager fMenuMgr = null;
    protected boolean fNeedInit = true;
    protected Cursor fWaitCursor;

    public void createPartControl(Composite c) {
        Composite parent = new Composite(c, 0);
        GridLayout parentLayout = new GridLayout();
        parentLayout.numColumns = 2;
        parentLayout.marginWidth = 0;
        parentLayout.marginHeight = 0;
        parent.setLayout((Layout)parentLayout);
        GridData timeLayoutdata = new GridData(1040);
        timeLayoutdata.widthHint = 10;
        GridData seqDiagLayoutData = new GridData(1808);
        this.fTimeCompressionBar = new TimeCompressionBar(parent, 0);
        this.fTimeCompressionBar.setLayoutData(timeLayoutdata);
        this.fSdWidget = new SDWidget(parent, 0);
        this.fSdWidget.setLayoutData(seqDiagLayoutData);
        this.fSdWidget.setSite(this);
        this.fSdWidget.setTimeBar(this.fTimeCompressionBar);
        KeyBindingsManager.getInstance().add(this.getSite().getId());
        this.createCoolbarContent();
        this.hookContextMenu();
        this.fTimeCompressionBar.setVisible(false);
        parent.layout(true);
        Print print = new Print(this);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)print);
        this.fNeedInit = this.restoreLoader();
    }

    protected void loadBlank() {
        BlankUml2SdLoader loader = new BlankUml2SdLoader();
        loader.setViewer(this);
        this.setContentDescription(loader.getTitleString());
    }

    public void setFocus() {
        if (this.fSdWidget != null) {
            KeyBindingsManager.getInstance().setSdView(this);
            this.fSdWidget.setFocus();
        }
        if (this.isViewReady() && this.fNeedInit) {
            this.fNeedInit = this.restoreLoader();
        }
    }

    public void dispose() {
        KeyBindingsManager.getInstance().remove(this.getSite().getId());
        super.dispose();
    }

    public SDWidget getSDWidget() {
        return this.fSdWidget;
    }

    public void setSDFindProvider(ISDFindProvider provider) {
        this.fSdFindProvider = provider;
        this.fSdExFindProvider = null;
        this.createCoolbarContent();
        if (provider != null) {
            KeyBindingsManager.getInstance().setFindEnabled(true);
        } else {
            KeyBindingsManager.getInstance().setFindEnabled(false);
        }
    }

    public void setExtendedFindProvider(IExtendedFindProvider provider) {
        this.fSdExFindProvider = provider;
        this.fSdFindProvider = null;
        this.createCoolbarContent();
        if (provider != null) {
            KeyBindingsManager.getInstance().setFindEnabled(true);
        } else {
            KeyBindingsManager.getInstance().setFindEnabled(false);
        }
    }

    public IExtendedFindProvider getExtendedFindProvider() {
        return this.fSdExFindProvider;
    }

    public void resetProviders() {
        KeyBindingsManager.getInstance().setFindEnabled(false);
        this.fSdFindProvider = null;
        this.fSdExFindProvider = null;
        this.fSdFilterProvider = null;
        this.fSdExFilterProvider = null;
        this.fSdPagingProvider = null;
        this.fSdExtendedActionBarProvider = null;
        this.fSdPropertiesProvider = null;
        if (this.fSdWidget != null && !this.fSdWidget.isDisposed()) {
            this.fSdWidget.setCollapseProvider(null);
        }
    }

    public void setSDFilterProvider(ISDFilterProvider provider) {
        this.fSdFilterProvider = provider;
        this.createCoolbarContent();
    }

    public void setExtendedFilterProvider(IExtendedFilterProvider provider) {
        this.fSdExFilterProvider = provider;
        this.createCoolbarContent();
    }

    public IExtendedFilterProvider getExtendedFilterProvider() {
        return this.fSdExFilterProvider;
    }

    public void setCollapsingProvider(ISDCollapseProvider provider) {
        if (this.fSdWidget != null && !this.fSdWidget.isDisposed()) {
            this.fSdWidget.setCollapseProvider(provider);
        }
    }

    public void setSDPagingProvider(ISDPagingProvider provider) {
        this.fSdPagingProvider = provider;
        this.createCoolbarContent();
    }

    public ISDPagingProvider getSDPagingProvider() {
        return this.fSdPagingProvider;
    }

    public ISDFindProvider getSDFindProvider() {
        return this.fSdFindProvider;
    }

    public ISDFilterProvider getSDFilterProvider() {
        return this.fSdFilterProvider;
    }

    public void setSDExtendedActionBarProvider(ISDExtendedActionBarProvider provider) {
        this.fSdExtendedActionBarProvider = provider;
        this.createCoolbarContent();
    }

    public ISDExtendedActionBarProvider getSDExtendedActionBarProvider() {
        return this.fSdExtendedActionBarProvider;
    }

    public void setSDPropertiesProvider(ISDPropertiesProvider provider) {
        this.fSdPropertiesProvider = provider;
    }

    public ISDPropertiesProvider getSDPropertiesProvider() {
        return this.fSdPropertiesProvider;
    }

    protected void hookContextMenu() {
        this.fMenuMgr = new MenuManager("#PopupMenu");
        this.fMenuMgr.setRemoveAllWhenShown(true);
        this.fMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SDView.this.fillContextMenu(manager);
            }
        });
        Menu menu = this.fMenuMgr.createContextMenu(this.fSdWidget.getViewControl());
        this.fSdWidget.getViewControl().setMenu(menu);
        this.getSite().registerContextMenu(this.fMenuMgr, this.fSdWidget.getSelectionProvider());
    }

    public MenuManager getMenuManager() {
        return this.fMenuMgr;
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("Additions"));
        if (this.getSDWidget() != null && this.getSDWidget().fCurrentGraphNode != null) {
            MoveToMessage goToMessage;
            Object node2;
            ISelectionProvider selProvider = this.fSdWidget.getSelectionProvider();
            ISelection sel = selProvider.getSelection();
            int nbMessage = 0;
            for (Object node2 : (StructuredSelection)sel) {
                if (!(node2 instanceof BaseMessage)) continue;
                ++nbMessage;
            }
            if (nbMessage != 1) {
                return;
            }
            node2 = this.getSDWidget().fCurrentGraphNode;
            if (node2 instanceof SyncMessageReturn && ((SyncMessageReturn)node2).getMessage() != null) {
                goToMessage = new MoveToMessage(this);
                goToMessage.setText(SDMessages._39);
                manager.add((IAction)goToMessage);
            }
            if (node2 instanceof SyncMessage && ((SyncMessage)node2).getMessageReturn() != null) {
                goToMessage = new MoveToMessage(this);
                goToMessage.setText(SDMessages._40);
                manager.add((IAction)goToMessage);
            }
        }
        manager.add((IContributionItem)new Separator("MultiSelectAdditions"));
    }

    public void setEnableAction(String actionName, boolean state) {
        IContributionItem item;
        IActionBars bar = this.getViewSite().getActionBars();
        if (bar != null && (item = bar.getMenuManager().find(actionName)) != null && item instanceof ActionContributionItem) {
            IAction action = ((ActionContributionItem)item).getAction();
            if (action != null) {
                action.setEnabled(state);
            }
            item.setVisible(state);
            bar.updateActionBars();
        }
    }

    protected void createCoolbarContent() {
        Action action;
        IActionBars bar = this.getViewSite().getActionBars();
        bar.getMenuManager().removeAll();
        bar.getToolBarManager().removeAll();
        this.createMenuGroup();
        Zoom resetZoom = new Zoom(this, Zoom.ZoomType.ZOOM_RESET);
        bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)resetZoom);
        bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)resetZoom);
        Zoom noZoom = new Zoom(this, Zoom.ZoomType.ZOOM_NONE);
        noZoom.setChecked(true);
        bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)noZoom);
        bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)noZoom);
        Zoom zoomIn = new Zoom(this, Zoom.ZoomType.ZOOM_IN);
        bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)zoomIn);
        bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)zoomIn);
        Zoom zoomOut = new Zoom(this, Zoom.ZoomType.ZOOM_OUT);
        bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)zoomOut);
        bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)zoomOut);
        MenuManager navigation = new MenuManager(SDMessages._77);
        ShowNodeStart showNodeStart = new ShowNodeStart((IViewPart)this);
        showNodeStart.setText(SDMessages.uml_25);
        showNodeStart.setId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ShowNodeStart");
        showNodeStart.setActionDefinitionId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ShowNodeStart");
        navigation.add((IAction)showNodeStart);
        ShowNodeEnd showNodeEnd = new ShowNodeEnd((IViewPart)this);
        showNodeEnd.setText(SDMessages.uml_23);
        showNodeEnd.setId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ShowNodeEnd");
        showNodeEnd.setActionDefinitionId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ShowNodeEnd");
        navigation.add((IAction)showNodeEnd);
        bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IContributionItem)navigation);
        ConfigureMinMax minMax = new ConfigureMinMax((IViewPart)this);
        minMax.setText(SDMessages.uml_45);
        minMax.setId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ConfigureMinMax");
        bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)minMax);
        if (this.fSdWidget.getFrame() != null && this.fSdWidget.getFrame().hasTimeInfo()) {
            minMax.setEnabled(true);
        } else {
            minMax.setEnabled(false);
        }
        if (this.fSdPagingProvider != null) {
            this.fNextPageButton = new NextPage(this);
            bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)this.fNextPageButton);
            this.fNextPageButton.setEnabled(this.fSdPagingProvider.hasNextPage());
            bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)this.fNextPageButton);
            this.fPrevPageButton = new PrevPage(this);
            bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)this.fPrevPageButton);
            this.fPrevPageButton.setEnabled(this.fSdPagingProvider.hasPrevPage());
            bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)this.fPrevPageButton);
            this.fFirstPageButton = new FirstPage(this);
            bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)this.fFirstPageButton);
            this.fFirstPageButton.setEnabled(this.fSdPagingProvider.hasPrevPage());
            bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)this.fFirstPageButton);
            this.fLastPageButton = new LastPage(this);
            bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)this.fLastPageButton);
            this.fLastPageButton.setEnabled(this.fSdPagingProvider.hasNextPage());
            bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)this.fLastPageButton);
        }
        if (this.fSdExFilterProvider != null && (action = this.fSdExFilterProvider.getFilterAction()) != null) {
            if (action.getId() == null) {
                action.setId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.extendedFilter");
            }
            if (action.getImageDescriptor() == null) {
                action.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/filter_items.gif"));
            }
            if (action.getText() == null || action.getText().length() == 0) {
                action.setText(SDMessages._42);
            }
            bar.getMenuManager().prependToGroup("UML2SD_FILTERING", (IAction)action);
            bar.getToolBarManager().prependToGroup("UML2SD_FILTERING", (IAction)action);
        }
        if (this.fSdFilterProvider != null) {
            bar.getMenuManager().appendToGroup("UML2SD_FILTERING", (IAction)new OpenSDFiltersDialog(this, this.fSdFilterProvider));
        }
        if (this.fSdPagingProvider instanceof ISDAdvancedPagingProvider) {
            IContributionItem sdPaging = bar.getMenuManager().find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.sdPaging");
            if (sdPaging != null) {
                bar.getMenuManager().remove(sdPaging);
                sdPaging = null;
            }
            bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)new OpenSDPagesDialog(this, (ISDAdvancedPagingProvider)this.fSdPagingProvider));
            this.updatePagesMenuItem(bar);
        }
        if (this.fSdExFindProvider != null) {
            action = this.fSdExFindProvider.getFindAction();
            if (action != null) {
                if (action.getId() == null) {
                    action.setId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.extendedFind");
                }
                if (action.getImageDescriptor() == null) {
                    action.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/search_seqdiag_menu.gif"));
                }
                if (action.getText() == null) {
                    action.setText(SDMessages._41);
                }
                bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)action);
                bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)action);
            }
        } else if (this.fSdFindProvider != null) {
            bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)new OpenSDFindDialog(this));
            bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)new OpenSDFindDialog(this));
        }
        if (this.fSdExtendedActionBarProvider != null) {
            this.fSdExtendedActionBarProvider.supplementCoolbarContent(bar);
        }
        bar.updateActionBars();
    }

    public void updateCoolBar() {
        if (this.fSdPagingProvider != null) {
            IAction lastPageAction;
            IContributionItem lastPage;
            IAction firstPageAction;
            IContributionItem firstPage;
            IAction prevPageAction;
            IContributionItem prevPage;
            IAction nextPageAction;
            IActionBars bar = this.getViewSite().getActionBars();
            if (bar == null) {
                return;
            }
            IToolBarManager barManager = bar.getToolBarManager();
            if (barManager == null) {
                return;
            }
            IContributionItem nextPage = barManager.find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.nextpage");
            if (nextPage instanceof ActionContributionItem && (nextPageAction = ((ActionContributionItem)nextPage).getAction()) instanceof NextPage) {
                ((NextPage)nextPageAction).setEnabled(this.fSdPagingProvider.hasNextPage());
            }
            if ((prevPage = barManager.find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.prevpage")) instanceof ActionContributionItem && (prevPageAction = ((ActionContributionItem)prevPage).getAction()) instanceof PrevPage) {
                ((PrevPage)prevPageAction).setEnabled(this.fSdPagingProvider.hasPrevPage());
            }
            if ((firstPage = barManager.find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.firstpage")) instanceof ActionContributionItem && (firstPageAction = ((ActionContributionItem)firstPage).getAction()) instanceof FirstPage) {
                ((FirstPage)firstPageAction).setEnabled(this.fSdPagingProvider.hasPrevPage());
            }
            if ((lastPage = barManager.find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.lastpage")) instanceof ActionContributionItem && (lastPageAction = ((ActionContributionItem)lastPage).getAction()) instanceof LastPage) {
                ((LastPage)lastPageAction).setEnabled(this.fSdPagingProvider.hasNextPage());
            }
            this.updatePagesMenuItem(bar);
        }
    }

    protected void updatePagesMenuItem(IActionBars bar) {
        if (this.fSdPagingProvider instanceof ISDAdvancedPagingProvider) {
            IMenuManager menuManager = bar.getMenuManager();
            ActionContributionItem contributionItem = (ActionContributionItem)menuManager.find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.sdPaging");
            IAction openSDPagesDialog = null;
            if (contributionItem != null) {
                openSDPagesDialog = contributionItem.getAction();
            }
            if (openSDPagesDialog instanceof OpenSDPagesDialog) {
                openSDPagesDialog.setEnabled(((ISDAdvancedPagingProvider)this.fSdPagingProvider).pagesCount() > 1);
            }
        }
    }

    public void setFrame(Frame frame) {
        this.setFrame(frame, true);
    }

    protected void setFrame(Frame frame, boolean resetPosition) {
        Composite parent;
        if (this.fSdWidget == null) {
            return;
        }
        if (frame == null) {
            this.loadBlank();
            return;
        }
        IUml2SDLoader loader = LoadersManager.getInstance().getCurrentLoader(this.getViewSite().getId(), this);
        if (loader != null && loader.getTitleString() != null) {
            this.setContentDescription(loader.getTitleString());
        }
        if (this.getSDWidget() != null) {
            this.getSDWidget().setFrame(frame, resetPosition);
        }
        if (this.fTimeCompressionBar != null) {
            this.fTimeCompressionBar.setFrame(frame);
        }
        this.updateCoolBar();
        if (!frame.hasTimeInfo()) {
            parent = this.fTimeCompressionBar.getParent();
            this.fTimeCompressionBar.setVisible(false);
            parent.layout(true);
        } else {
            parent = this.fTimeCompressionBar.getParent();
            this.fTimeCompressionBar.setVisible(true);
            parent.layout(true);
        }
        IContributionItem shortKeysMenu = this.getViewSite().getActionBars().getMenuManager().find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers");
        MenuManager shortKeys = (MenuManager)shortKeysMenu;
        if (shortKeys != null) {
            IContributionItem[] items = shortKeys.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                if (items[i] instanceof ActionContributionItem && (action = ((ActionContributionItem)items[i]).getAction()) != null) {
                    action.setEnabled(true);
                }
                ++i;
            }
        }
        this.createCoolbarContent();
    }

    public void setEnableCommand(String id, boolean value) {
        IAction action;
        IContributionItem shortKeysMenu = this.getViewSite().getActionBars().getMenuManager().find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers");
        MenuManager shortKeys = (MenuManager)shortKeysMenu;
        if (shortKeys == null) {
            return;
        }
        IContributionItem item = shortKeys.find(id);
        if (item != null && item instanceof ActionContributionItem && (action = ((ActionContributionItem)item).getAction()) != null) {
            action.setEnabled(value);
        }
    }

    public void setFrameSync(final Frame frame) {
        if (this.getSDWidget() == null || this.getSDWidget().isDisposed()) {
            return;
        }
        this.getSDWidget().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (SDView.this.getSDWidget() == null || SDView.this.getSDWidget().isDisposed()) {
                    return;
                }
                SDView.this.setFrame(frame);
            }
        });
    }

    public void ensureVisibleSync(final GraphNode sm) {
        this.getSDWidget().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (SDView.this.getSDWidget() == null || SDView.this.getSDWidget().isDisposed()) {
                    return;
                }
                SDView.this.getSDWidget().ensureVisible(sm);
            }
        });
    }

    public void setFrameAndEnsureVisibleSync(final Frame frame, final GraphNode sm) {
        if (this.getSDWidget() == null || this.getSDWidget().isDisposed()) {
            return;
        }
        this.getSDWidget().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (SDView.this.getSDWidget() == null || SDView.this.getSDWidget().isDisposed()) {
                    return;
                }
                SDView.this.setFrameAndEnsureVisible(frame, sm);
            }
        });
    }

    public void setFrameAndEnsureVisible(Frame frame, GraphNode sm) {
        this.getSDWidget().clearSelection();
        this.setFrame(frame, false);
        this.getSDWidget().ensureVisible(sm);
    }

    public void setFrameAndEnsureVisibleSync(final Frame frame, final int x, final int y) {
        if (this.getSDWidget() == null || this.getSDWidget().isDisposed()) {
            return;
        }
        this.getSDWidget().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                SDView.this.setFrameAndEnsureVisible(frame, x, y);
            }
        });
    }

    public void setFrameAndEnsureVisible(Frame frame, int x, int y) {
        this.getSDWidget().clearSelection();
        this.setFrame(frame, false);
        this.getSDWidget().ensureVisible(x, y);
        this.getSDWidget().redraw();
    }

    public void toggleWaitCursorAsync(final boolean wait) {
        if (this.getSDWidget() == null || this.getSDWidget().isDisposed()) {
            return;
        }
        this.getSDWidget().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SDView.this.getSDWidget() == null || SDView.this.getSDWidget().isDisposed()) {
                    return;
                }
                if (wait) {
                    if (SDView.this.fWaitCursor != null && !SDView.this.fWaitCursor.isDisposed()) {
                        SDView.this.fWaitCursor.dispose();
                    }
                    SDView.this.fWaitCursor = new Cursor((Device)SDView.this.getSDWidget().getDisplay(), 1);
                    SDView.this.getSDWidget().setCursor(SDView.this.fWaitCursor);
                    SDView.this.getSDWidget().getDisplay().update();
                } else {
                    if (SDView.this.fWaitCursor != null && !SDView.this.fWaitCursor.isDisposed()) {
                        SDView.this.fWaitCursor.dispose();
                    }
                    SDView.this.fWaitCursor = null;
                    SDView.this.getSDWidget().setCursor(null);
                    SDView.this.getSDWidget().getDisplay().update();
                }
            }
        });
    }

    public TimeCompressionBar getTimeCompressionBar() {
        return this.fTimeCompressionBar;
    }

    public Frame getFrame() {
        if (this.getSDWidget() != null) {
            return this.getSDWidget().getFrame();
        }
        return null;
    }

    protected boolean restoreLoader() {
        String id = this.getViewSite().getId();
        if (id == null) {
            return true;
        }
        IUml2SDLoader loader = LoadersManager.getInstance().getCurrentLoader(id, this);
        if (loader != null) {
            loader.setViewer(this);
            return false;
        }
        this.loadBlank();
        return true;
    }

    protected boolean isViewReady() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page == null) {
            return false;
        }
        IViewReference[] ref = page.getViewReferences();
        int i = 0;
        while (i < ref.length) {
            if (ref[i].getView(false) == this) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void createMenuGroup() {
        IActionBars bar = this.getViewSite().getActionBars();
        if (bar == null) {
            return;
        }
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_VIEW_MODES"));
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_WORKING_SET"));
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_SORTING"));
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_FILTERING"));
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_VIEW_LAYOUT"));
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_LINK_EDITOR"));
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_OTHER_COMMANDS"));
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_OTHER_PLUGINS_COMMANDS"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_VIEW_MODES"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_WORKING_SET"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_SORTING"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_FILTERING"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_VIEW_LAYOUT"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_LINK_EDITOR"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_OTHER_COMMANDS"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_OTHER_PLUGINS_COMMANDS"));
    }

    public Object getAdapter(Class adapter) {
        Object obj = super.getAdapter(adapter);
        if (this.fSdPropertiesProvider != null && adapter.equals(IPropertySheetPage.class)) {
            return this.fSdPropertiesProvider.getPropertySheetEntry();
        }
        return obj;
    }

    public static class BlankUml2SdLoader
    implements IUml2SDLoader {
        @Override
        public void setViewer(SDView viewer) {
            Frame f = new Frame();
            f.setName("");
            viewer.setFrame(f);
        }

        @Override
        public String getTitleString() {
            return "";
        }

        @Override
        public void dispose() {
        }
    }
}

