/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.histogram;

import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;

public abstract class HistogramUtils {
    public static String nanosecondsToString(long ns) {
        ns = Math.abs(ns);
        String time = Long.toString(ns);
        int length = time.length();
        if (time.length() > 9) {
            time = String.valueOf(time.substring(0, length - 9)) + "." + time.substring(length - 9);
            return time;
        }
        int i = length;
        while (i < 9) {
            time = "0" + time;
            ++i;
        }
        time = "0." + time;
        return time;
    }

    public static long stringToNanoseconds(String time) {
        long result = 0L;
        StringBuffer buffer = new StringBuffer(time);
        try {
            int dot = buffer.indexOf(".");
            if (dot == -1) {
                buffer.insert(0, ".");
                dot = 0;
            }
            int i = buffer.length() - dot - 1;
            while (i < 9) {
                buffer.append("0");
                ++i;
            }
            int nbDecimals = buffer.substring(dot + 1).length();
            if (nbDecimals > 9) {
                buffer.delete(buffer.substring(0, dot + 1 + 9).length(), buffer.length());
            }
            long seconds = dot > 0 ? Long.parseLong(buffer.substring(0, dot)) : 0L;
            seconds = Math.abs(seconds);
            long nanosecs = Long.parseLong(buffer.substring(dot + 1));
            result = seconds * 1000000000L + nanosecs;
        }
        catch (NumberFormatException numberFormatException) {}
        return result;
    }

    public static int getTextSizeInControl(Composite parent, String text) {
        GC controlGC = new GC((Drawable)parent);
        int textSize = 0;
        int pos = 0;
        while (pos < text.length()) {
            textSize += controlGC.getAdvanceWidth(text.charAt(pos));
            ++pos;
        }
        controlGC.dispose();
        return textSize += controlGC.getAdvanceWidth(' ');
    }
}

