/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.ide.actions;

import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.FunctionBrowserView;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.ProbeAliasBrowserView;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class ImportTapsetAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;

    public ImportTapsetAction() {
        this.setEnabled(true);
    }

    public void dispose() {
        LogManager.logInfo((String)"Disposing", (Object)((Object)this));
        this.fWindow = null;
    }

    public void init(IWorkbenchWindow window) {
        LogManager.logInfo((String)("Initializing fWindow: " + window), (Object)((Object)this));
        this.fWindow = window;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private File queryFile() {
        DirectoryDialog dialog = new DirectoryDialog(this.fWindow.getShell(), 4096);
        dialog.setText("Import Tapsets");
        String path = dialog.open();
        if (path != null && path.length() > 0) {
            LogManager.logDebug((String)("queryFile: returnVal-" + path), (Object)((Object)this));
            return new File(path);
        }
        LogManager.logDebug((String)"queryFile: returnVal-null", (Object)((Object)this));
        return null;
    }

    public void run() {
        LogManager.logDebug((String)"Start run:", (Object)((Object)this));
        File file = this.queryFile();
        if (file != null) {
            IPreferenceStore p = IDEPlugin.getDefault().getPreferenceStore();
            String tapsets = p.getString("TapsetPreference");
            p.setValue("TapsetPreference", String.valueOf(tapsets) + File.pathSeparator + file.getAbsolutePath());
            IViewPart ivp = this.fWindow.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.internal.systemtap.ui.ide.views.FunctionBrowserView");
            ((FunctionBrowserView)ivp).refresh();
            ivp = this.fWindow.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.internal.systemtap.ui.ide.views.ProbeAliasBrowserView");
            ((ProbeAliasBrowserView)ivp).refresh();
        }
        LogManager.logDebug((String)"End run:", (Object)((Object)this));
    }
}

