/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.property;

import java.util.ArrayList;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TraceLogLevel;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceEventComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.property.BasePropertySource;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class TraceEventPropertySource
extends BasePropertySource {
    public static final String TRACE_EVENT_NAME_PROPERTY_ID = "trace.event.name";
    public static final String TRACE_EVENT_TYPE_PROPERTY_ID = "trace.event.type";
    public static final String TRACE_EVENT_LOGLEVEL_PROPERTY_ID = "trace.event.loglevel";
    public static final String TRACE_EVENT_STATE_PROPERTY_ID = "trace.event.state";
    public static final String TRACE_EVENT_NAME_PROPERTY_NAME = Messages.TraceControl_EventNamePropertyName;
    public static final String TRACE_EVENT_TYPE_PROPERTY_NAME = Messages.TraceControl_EventTypePropertyName;
    public static final String TRACE_EVENT_LOGLEVEL_PROPERTY_NAME = Messages.TraceControl_LogLevelPropertyName;
    public static final String TRACE_EVENT_STATE_PROPERTY_NAME = Messages.TraceControl_StatePropertyName;
    protected final TraceEventComponent fEvent;

    public TraceEventPropertySource(TraceEventComponent component) {
        this.fEvent = component;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<TextPropertyDescriptor> list = new ArrayList<TextPropertyDescriptor>();
        list.add(new TextPropertyDescriptor((Object)TRACE_EVENT_NAME_PROPERTY_ID, TRACE_EVENT_NAME_PROPERTY_NAME));
        list.add(new TextPropertyDescriptor((Object)TRACE_EVENT_TYPE_PROPERTY_ID, TRACE_EVENT_TYPE_PROPERTY_NAME));
        list.add(new TextPropertyDescriptor((Object)TRACE_EVENT_STATE_PROPERTY_ID, TRACE_EVENT_STATE_PROPERTY_NAME));
        if (this.fEvent.getLogLevel() != TraceLogLevel.LEVEL_UNKNOWN) {
            list.add(new TextPropertyDescriptor((Object)TRACE_EVENT_LOGLEVEL_PROPERTY_ID, TRACE_EVENT_LOGLEVEL_PROPERTY_NAME));
        }
        return list.toArray(new IPropertyDescriptor[list.size()]);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (TRACE_EVENT_NAME_PROPERTY_ID.equals(id)) {
            return this.fEvent.getName();
        }
        if (TRACE_EVENT_TYPE_PROPERTY_ID.equals(id)) {
            return this.fEvent.getEventType().name();
        }
        if (TRACE_EVENT_LOGLEVEL_PROPERTY_ID.equals(id)) {
            return this.fEvent.getLogLevel().name();
        }
        if (TRACE_EVENT_STATE_PROPERTY_ID.equals(id)) {
            return this.fEvent.getState().name();
        }
        return null;
    }
}

